/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.util;

import java.io.Serializable;
import java.util.Arrays;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathIllegalArgumentException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathIllegalStateException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathInternalError;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NumberIsTooSmallException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.util.DoubleArray;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;
import net.advancedplugins.ae.libs.apache.commons.math3.util.MathArrays;
import net.advancedplugins.ae.libs.apache.commons.math3.util.MathUtils;

public class ResizableDoubleArray
implements DoubleArray,
Serializable {
    @Deprecated
    public static final int i = 1;
    @Deprecated
    public static final int g = 0;
    private static final long serialVersionUID = -3485529955529426875L;
    private static final int h = 16;
    private static final double j = 2.0;
    private static final double c = 0.5;
    private double a;
    private double f;
    private ExpansionMode b;
    private double[] d;
    private int k;
    private int e;
    private static final String[] l;

    public ResizableDoubleArray() {
        this(16);
    }

    public ResizableDoubleArray(int n) {
        this(n, 2.0);
    }

    public ResizableDoubleArray(double[] dArray) {
        this(16, 2.0, 2.5, ExpansionMode.MULTIPLICATIVE, dArray);
    }

    @Deprecated
    public ResizableDoubleArray(int n, float f) {
        this(n, (double)f);
    }

    public ResizableDoubleArray(int n, double d) {
        this(n, d, 0.5 + d);
    }

    @Deprecated
    public ResizableDoubleArray(int n, float f, float f2) {
        this(n, (double)f, (double)f2);
    }

    public ResizableDoubleArray(int n, double d, double d2) {
        this(n, d, d2, ExpansionMode.MULTIPLICATIVE, null);
    }

    @Deprecated
    public ResizableDoubleArray(int n, float f, float f2, int n2) {
        this(n, f, f2, n2 == 1 ? ExpansionMode.ADDITIVE : ExpansionMode.MULTIPLICATIVE, null);
        this.setExpansionMode(n2);
    }

    public ResizableDoubleArray(int n, double d, double d2, ExpansionMode expansionMode, double ... dArray) {
        block5: {
            this.a = 2.5;
            this.f = 2.0;
            this.b = ExpansionMode.MULTIPLICATIVE;
            this.k = 0;
            this.e = 0;
            if (n <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.INITIAL_CAPACITY_NOT_POSITIVE, n);
            }
            try {
                try {
                    this.checkContractExpand(d2, d);
                    this.f = d;
                    this.a = d2;
                    this.b = expansionMode;
                    this.d = new double[n];
                    this.k = 0;
                    this.e = 0;
                    if (dArray == null || dArray.length <= 0) break block5;
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw ResizableDoubleArray.b(mathIllegalArgumentException);
                }
                this.addElements(dArray);
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw ResizableDoubleArray.b(mathIllegalArgumentException);
            }
        }
    }

    public ResizableDoubleArray(ResizableDoubleArray resizableDoubleArray) {
        this.a = 2.5;
        this.f = 2.0;
        this.b = ExpansionMode.MULTIPLICATIVE;
        this.k = 0;
        this.e = 0;
        MathUtils.checkNotNull(resizableDoubleArray);
        ResizableDoubleArray.copy(resizableDoubleArray, this);
    }

    public synchronized void addElement(double d) {
        try {
            if (this.d.length <= this.e + this.k) {
                this.expand();
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        this.d[this.e + this.k++] = d;
    }

    public synchronized void addElements(double[] dArray) {
        double[] dArray2 = new double[this.k + dArray.length + 1];
        System.arraycopy(this.d, this.e, dArray2, 0, this.k);
        System.arraycopy(dArray, 0, dArray2, this.k, dArray.length);
        this.d = dArray2;
        this.e = 0;
        this.k += dArray.length;
    }

    public synchronized double addElementRolling(double d) {
        double d2 = this.d[this.e];
        try {
            if (this.e + (this.k + 1) > this.d.length) {
                this.expand();
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            ++this.e;
            this.d[this.e + (this.k - 1)] = d;
            if (this.shouldContract()) {
                this.contract();
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        return d2;
    }

    public synchronized double substituteMostRecentElement(double d) {
        try {
            if (this.k < 1) {
                throw new MathIllegalStateException(LocalizedFormats.CANNOT_SUBSTITUTE_ELEMENT_FROM_EMPTY_ARRAY, new Object[0]);
            }
        }
        catch (MathIllegalStateException mathIllegalStateException) {
            throw ResizableDoubleArray.b(mathIllegalStateException);
        }
        int n = this.e + (this.k - 1);
        double d2 = this.d[n];
        this.d[n] = d;
        return d2;
    }

    @Deprecated
    protected void checkContractExpand(float f, float f2) {
        this.checkContractExpand((double)f, (double)f2);
    }

    protected void checkContractExpand(double d, double d2) {
        if (d < d2) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d, (Number)1, true);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.CONTRACTION_CRITERIA_SMALLER_THAN_EXPANSION_FACTOR, d, d2);
            throw numberIsTooSmallException;
        }
        if (d <= 1.0) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d, (Number)1, false);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.CONTRACTION_CRITERIA_SMALLER_THAN_ONE, d);
            throw numberIsTooSmallException;
        }
        if (d2 <= 1.0) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d, (Number)1, false);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.EXPANSION_FACTOR_SMALLER_THAN_ONE, d2);
            throw numberIsTooSmallException;
        }
    }

    public synchronized void clear() {
        this.k = 0;
        this.e = 0;
    }

    public synchronized void contract() {
        double[] dArray = new double[this.k + 1];
        System.arraycopy(this.d, this.e, dArray, 0, this.k);
        this.d = dArray;
        this.e = 0;
    }

    public synchronized void discardFrontElements(int n) {
        this.discardExtremeElements(n, true);
    }

    public synchronized void discardMostRecentElements(int n) {
        this.discardExtremeElements(n, false);
    }

    private synchronized void discardExtremeElements(int n, boolean bl) {
        try {
            if (n > this.k) {
                throw new MathIllegalArgumentException(LocalizedFormats.TOO_MANY_ELEMENTS_TO_DISCARD_FROM_ARRAY, n, this.k);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (n < 0) {
                throw new MathIllegalArgumentException(LocalizedFormats.CANNOT_DISCARD_NEGATIVE_NUMBER_OF_ELEMENTS, n);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            this.k -= n;
            if (bl) {
                this.e += n;
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (this.shouldContract()) {
                this.contract();
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
    }

    protected synchronized void expand() {
        int n = 0;
        n = this.b == ExpansionMode.MULTIPLICATIVE ? (int)FastMath.ceil((double)this.d.length * this.f) : (int)((long)this.d.length + FastMath.round(this.f));
        double[] dArray = new double[n];
        System.arraycopy(this.d, 0, dArray, 0, this.d.length);
        this.d = dArray;
    }

    private synchronized void expandTo(int n) {
        double[] dArray = new double[n];
        System.arraycopy(this.d, 0, dArray, 0, this.d.length);
        this.d = dArray;
    }

    @Deprecated
    public float getContractionCriteria() {
        return (float)this.getContractionCriterion();
    }

    public double getContractionCriterion() {
        return this.a;
    }

    public synchronized double getElement(int n) {
        try {
            if (n >= this.k) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (n >= 0) {
                return this.d[this.e + n];
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public synchronized double[] getElements() {
        double[] dArray = new double[this.k];
        System.arraycopy(this.d, this.e, dArray, 0, this.k);
        return dArray;
    }

    @Deprecated
    public float getExpansionFactor() {
        return (float)this.f;
    }

    @Deprecated
    public int getExpansionMode() {
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            switch (this.b) {
                case MULTIPLICATIVE: {
                    return 0;
                }
                case ADDITIVE: {
                    return 1;
                }
            }
            throw new MathInternalError();
        }
    }

    @Deprecated
    synchronized int getInternalLength() {
        return this.d.length;
    }

    public int getCapacity() {
        return this.d.length;
    }

    public synchronized int getNumElements() {
        return this.k;
    }

    @Deprecated
    public synchronized double[] getInternalValues() {
        return this.d;
    }

    protected double[] getArrayRef() {
        return this.d;
    }

    protected int getStartIndex() {
        return this.e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setContractionCriteria(float f) {
        this.checkContractExpand(f, this.getExpansionFactor());
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            this.a = f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double compute(MathArrays.Function function) {
        int n;
        int n2;
        double[] dArray;
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            dArray = this.d;
            n2 = this.e;
            n = this.k;
        }
        return function.evaluate(dArray, n2, n);
    }

    public synchronized void setElement(int n, double d) {
        try {
            if (n < 0) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (n + 1 > this.k) {
                this.k = n + 1;
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (this.e + n >= this.d.length) {
                this.expandTo(this.e + (n + 1));
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        this.d[this.e + n] = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setExpansionFactor(float f) {
        this.checkContractExpand(this.getContractionCriterion(), (double)f);
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            this.f = f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Deprecated
    public void setExpansionMode(int n) {
        block14: {
            int n2;
            block11: {
                n2 = FastMath.c();
                if (n == 0) break block11;
                try {
                    block12: {
                        if (n == 1) break block11;
                        break block12;
                        catch (MathIllegalArgumentException mathIllegalArgumentException) {
                            throw ResizableDoubleArray.b(mathIllegalArgumentException);
                        }
                    }
                    Object[] objectArray = new Object[5];
                    objectArray[0] = n;
                    objectArray[1] = 0;
                    String[] stringArray = l;
                    objectArray[2] = stringArray[0];
                    objectArray[3] = 1;
                    objectArray[4] = stringArray[1];
                    throw new MathIllegalArgumentException(LocalizedFormats.UNSUPPORTED_EXPANSION_MODE, objectArray);
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw ResizableDoubleArray.b(mathIllegalArgumentException);
                }
            }
            ResizableDoubleArray resizableDoubleArray = this;
            synchronized (resizableDoubleArray) {
                block13: {
                    if (n != 0) break block13;
                    this.setExpansionMode(ExpansionMode.MULTIPLICATIVE);
                    if (n2 == 0) break block14;
                }
                if (n == 1) {
                    this.setExpansionMode(ExpansionMode.ADDITIVE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setExpansionMode(ExpansionMode expansionMode) {
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            this.b = expansionMode;
        }
    }

    @Deprecated
    protected void setInitialCapacity(int n) {
    }

    public synchronized void setNumElements(int n) {
        try {
            if (n < 0) {
                throw new MathIllegalArgumentException(LocalizedFormats.INDEX_NOT_POSITIVE, n);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        int n2 = this.e + n;
        try {
            if (n2 > this.d.length) {
                this.expandTo(n2);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        this.k = n;
    }

    private synchronized boolean shouldContract() {
        boolean bl;
        block6: {
            boolean bl2;
            block8: {
                block7: {
                    try {
                        try {
                            if (this.b != ExpansionMode.MULTIPLICATIVE) break block6;
                            if (!((double)((float)this.d.length / (float)this.k) > this.a)) break block7;
                        }
                        catch (MathIllegalArgumentException mathIllegalArgumentException) {
                            throw ResizableDoubleArray.b(mathIllegalArgumentException);
                        }
                        bl2 = true;
                        break block8;
                    }
                    catch (MathIllegalArgumentException mathIllegalArgumentException) {
                        throw ResizableDoubleArray.b(mathIllegalArgumentException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }
        try {
            bl = (double)(this.d.length - this.k) > this.a;
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        return bl;
    }

    @Deprecated
    public synchronized int start() {
        return this.e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(ResizableDoubleArray resizableDoubleArray, ResizableDoubleArray resizableDoubleArray2) {
        MathUtils.checkNotNull(resizableDoubleArray);
        MathUtils.checkNotNull(resizableDoubleArray2);
        ResizableDoubleArray resizableDoubleArray3 = resizableDoubleArray;
        synchronized (resizableDoubleArray3) {
            ResizableDoubleArray resizableDoubleArray4 = resizableDoubleArray2;
            synchronized (resizableDoubleArray4) {
                resizableDoubleArray2.a = resizableDoubleArray.a;
                resizableDoubleArray2.f = resizableDoubleArray.f;
                resizableDoubleArray2.b = resizableDoubleArray.b;
                resizableDoubleArray2.d = new double[resizableDoubleArray.d.length];
                System.arraycopy(resizableDoubleArray.d, 0, resizableDoubleArray2.d, 0, resizableDoubleArray2.d.length);
                resizableDoubleArray2.k = resizableDoubleArray.k;
                resizableDoubleArray2.e = resizableDoubleArray.e;
            }
        }
    }

    public synchronized ResizableDoubleArray copy() {
        ResizableDoubleArray resizableDoubleArray = new ResizableDoubleArray();
        ResizableDoubleArray.copy(this, resizableDoubleArray);
        return resizableDoubleArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        try {
            if (object == this) {
                return true;
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (!(object instanceof ResizableDoubleArray)) {
                return false;
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            Object object2 = object;
            synchronized (object2) {
                boolean bl = true;
                ResizableDoubleArray resizableDoubleArray2 = (ResizableDoubleArray)object;
                bl = bl && resizableDoubleArray2.a == this.a;
                bl = bl && resizableDoubleArray2.f == this.f;
                bl = bl && resizableDoubleArray2.b == this.b;
                bl = bl && resizableDoubleArray2.k == this.k;
                boolean bl2 = bl = bl && resizableDoubleArray2.e == this.e;
                if (!bl) {
                    return false;
                }
                return Arrays.equals(this.d, resizableDoubleArray2.d);
            }
        }
    }

    public synchronized int hashCode() {
        int[] nArray = new int[]{Double.valueOf(this.f).hashCode(), Double.valueOf(this.a).hashCode(), this.b.hashCode(), Arrays.hashCode(this.d), this.k, this.e};
        return Arrays.hashCode(nArray);
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String[] stringArray = new String[2];
        int n = 0;
        String string = "\fI'\u0019A r\b_*\u0019A&{\u001eQ$\tM\r\u0000X/\u0004\\9h\u0004C&\u0002L5";
        int n2 = "\fI'\u0019A r\b_*\u0019A&{\u001eQ$\tM\r\u0000X/\u0004\\9h\u0004C&\u0002L5".length();
        int n3 = 19;
        int n4 = -1;
        while (true) {
            char[] cArray;
            block14: {
                int n5;
                char[] cArray2;
                int n6;
                int n7;
                block13: {
                    int n8 = ++n4;
                    Object var6_6 = null;
                    char[] cArray3 = string.substring(n8, n8 + n3).toCharArray();
                    int n9 = cArray3.length;
                    n7 = 0;
                    n6 = 119;
                    cArray2 = cArray3;
                    n5 = n9;
                    if (n9 <= 1) break block13;
                    cArray = cArray2;
                    n5 = n5;
                    if (n5 <= n7) break block14;
                }
                do {
                    int n10 = n6;
                    cArray2 = cArray2;
                    char[] cArray4 = cArray2;
                    int n11 = n6;
                    int n12 = n7;
                    while (true) {
                        int n13;
                        switch (n7 % 7) {
                            case 0: {
                                n13 = 54;
                                break;
                            }
                            case 1: {
                                n13 = 107;
                                break;
                            }
                            case 2: {
                                n13 = 28;
                                break;
                            }
                            case 3: {
                                n13 = 58;
                                break;
                            }
                            case 4: {
                                n13 = 127;
                                break;
                            }
                            case 5: {
                                n13 = 7;
                                break;
                            }
                            default: {
                                n13 = 73;
                            }
                        }
                        cArray4[n12] = (char)(cArray4[n12] ^ (n11 ^ n13));
                        ++n7;
                        n6 = n10;
                        if (n10 != 0) break;
                        n10 = n6;
                        cArray2 = cArray2;
                        n12 = n6;
                        cArray4 = cArray2;
                        n11 = n6;
                    }
                    cArray = cArray2;
                    n5 = n5;
                } while (n5 > n7);
            }
            stringArray[n++] = new String(cArray).intern();
            if ((n4 += n3) >= n2) {
                l = stringArray;
                return;
            }
            n3 = string.charAt(n4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ExpansionMode
    extends Enum<ExpansionMode> {
        public static final /* enum */ ExpansionMode MULTIPLICATIVE;
        public static final /* enum */ ExpansionMode ADDITIVE;
        private static final /* synthetic */ ExpansionMode[] a;

        public static ExpansionMode[] values() {
            return (ExpansionMode[])a.clone();
        }

        public static ExpansionMode valueOf(String string) {
            return Enum.valueOf(ExpansionMode.class, string);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String[] stringArray = new String[2];
            int n = 0;
            String string = "ni\u001e]P3Wj\u007f\u0013]P5^\bbx\u0016@M*Mf";
            int n2 = "ni\u001e]P3Wj\u007f\u0013]P5^\bbx\u0016@M*Mf".length();
            int n3 = 14;
            int n4 = -1;
            while (true) {
                char[] cArray;
                block14: {
                    int n5;
                    char[] cArray2;
                    int n6;
                    int n7;
                    block13: {
                        int n8 = ++n4;
                        Object var7_6 = null;
                        char[] cArray3 = string.substring(n8, n8 + n3).toCharArray();
                        int n9 = cArray3.length;
                        n7 = 0;
                        n6 = 46;
                        cArray2 = cArray3;
                        n5 = n9;
                        if (n9 <= 1) break block13;
                        cArray = cArray2;
                        n5 = n5;
                        if (n5 <= n7) break block14;
                    }
                    do {
                        int n10 = n6;
                        cArray2 = cArray2;
                        char[] cArray4 = cArray2;
                        int n11 = n6;
                        int n12 = n7;
                        while (true) {
                            int n13;
                            switch (n7 % 7) {
                                case 0: {
                                    n13 = 13;
                                    break;
                                }
                                case 1: {
                                    n13 = 18;
                                    break;
                                }
                                case 2: {
                                    n13 = 124;
                                    break;
                                }
                                case 3: {
                                    n13 = 39;
                                    break;
                                }
                                case 4: {
                                    n13 = 55;
                                    break;
                                }
                                case 5: {
                                    n13 = 77;
                                    break;
                                }
                                default: {
                                    n13 = 53;
                                }
                            }
                            cArray4[n12] = (char)(cArray4[n12] ^ (n11 ^ n13));
                            ++n7;
                            n6 = n10;
                            if (n10 != 0) break;
                            n10 = n6;
                            cArray2 = cArray2;
                            n12 = n6;
                            cArray4 = cArray2;
                            n11 = n6;
                        }
                        cArray = cArray2;
                        n5 = n5;
                    } while (n5 > n7);
                }
                stringArray[n++] = new String(cArray).intern();
                if ((n4 += n3) >= n2) {
                    String[] stringArray2 = stringArray;
                    MULTIPLICATIVE = new ExpansionMode();
                    ADDITIVE = new ExpansionMode();
                    a = new ExpansionMode[]{MULTIPLICATIVE, ADDITIVE};
                    return;
                }
                n3 = string.charAt(n4);
            }
        }
    }
}

