/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.items.listener;

import net.advancedplugins.items.Core;
import net.advancedplugins.items.api.AdvancedItemsAPI;
import net.advancedplugins.items.objects.CustomItem;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerDropItemEvent;

public class DropItemListener
implements Listener {
    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent playerDropItemEvent) {
        Item item = playerDropItemEvent.getItemDrop();
        if (!AdvancedItemsAPI.isCustomItem(item.getItemStack())) {
            return;
        }
        CustomItem customItem = Core.getItemsHandler().getCustomItem(AdvancedItemsAPI.getCustomItemName(item.getItemStack()));
        if (customItem == null) {
            return;
        }
        if (customItem.getItemSettings().isDisableInteractions()) {
            playerDropItemEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrop(EntitySpawnEvent entitySpawnEvent) {
        if (!(entitySpawnEvent.getEntity() instanceof Item)) {
            return;
        }
        Item item = (Item)entitySpawnEvent.getEntity();
        if (!AdvancedItemsAPI.isCustomItem(item.getItemStack())) {
            return;
        }
        CustomItem customItem = Core.getItemsHandler().getCustomItem(AdvancedItemsAPI.getCustomItemName(item.getItemStack()));
        if (customItem == null) {
            return;
        }
        if (customItem.getItemSettings().isDroppedItemName()) {
            item.setCustomName(item.getItemStack().getItemMeta().getDisplayName());
            item.setCustomNameVisible(true);
        }
        if (customItem.getItemSettings().isDroppedItemGlow()) {
            item.setGlowing(true);
        }
    }
}

