/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import net.advancedplugins.items.impl.commons.effects.effects.AdvancedEffect;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;

public class GammaDistribution
extends AbstractRealDistribution {
    public static final double o = 1.0E-9;
    private static final long serialVersionUID = 20120524L;
    private final double n;
    private final double l;
    private final double g;
    private final double k;
    private final double f;
    private final double j;
    private final double i;
    private final double p;
    private final double m;
    private final double h;
    private static final String q;

    public GammaDistribution(double d, double d2) {
        this(d, d2, 1.0E-9);
    }

    public GammaDistribution(double d, double d2, double d3) {
        this(new Well19937c(), d, d2, d3);
    }

    public GammaDistribution(RandomGenerator randomGenerator, double d, double d2) {
        this(randomGenerator, d, d2, 1.0E-9);
    }

    public GammaDistribution(RandomGenerator randomGenerator, double d, double d2, double d3) {
        super(randomGenerator);
        int n = AbstractRealDistribution.a();
        try {
            if (d <= 0.0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SHAPE, d);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw GammaDistribution.b(notStrictlyPositiveException);
        }
        try {
            if (d2 <= 0.0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SCALE, d2);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw GammaDistribution.b(notStrictlyPositiveException);
        }
        this.n = d;
        this.l = d2;
        this.h = d3;
        this.g = d + 4.7421875 + 0.5;
        double d4 = Math.E / (Math.PI * 2 * this.g);
        try {
            this.j = d * FastMath.sqrt(d4) / Gamma.lanczos(d);
            this.i = FastMath.log(d) + 0.5 * FastMath.log(d4) - FastMath.log(Gamma.lanczos(d));
            this.k = this.j / d2 * FastMath.pow(this.g, -d) * FastMath.exp(d + 4.7421875);
            this.f = this.i - FastMath.log(d2) - FastMath.log(this.g) * d + d + 4.7421875;
            this.p = d + 4.7421875 - FastMath.log(Double.MAX_VALUE);
            this.m = FastMath.log(Double.MAX_VALUE) / (d - 1.0);
            if (n == 0) {
                AdvancedEffect.b(q);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw GammaDistribution.b(notStrictlyPositiveException);
        }
    }

    @Deprecated
    public double getAlpha() {
        return this.n;
    }

    public double getShape() {
        return this.n;
    }

    @Deprecated
    public double getBeta() {
        return this.l;
    }

    public double getScale() {
        return this.l;
    }

    public double density(double d) {
        double d2;
        block5: {
            try {
                if (d < 0.0) {
                    return 0.0;
                }
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw GammaDistribution.b(notStrictlyPositiveException);
            }
            d2 = d / this.l;
            try {
                if (!(d2 <= this.p) && !(FastMath.log(d2) >= this.m)) break block5;
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw GammaDistribution.b(notStrictlyPositiveException);
            }
            double d3 = (d2 - this.g) / this.g;
            double d4 = this.n * (FastMath.log1p(d3) - d3);
            double d5 = -d2 * 5.2421875 / this.g + 4.7421875 + d4;
            return this.j / d * FastMath.exp(d5);
        }
        return this.k * FastMath.exp(-d2) * FastMath.pow(d2, this.n - 1.0);
    }

    public double logDensity(double d) {
        double d2;
        block5: {
            try {
                if (d < 0.0) {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw GammaDistribution.b(notStrictlyPositiveException);
            }
            d2 = d / this.l;
            try {
                if (!(d2 <= this.p) && !(FastMath.log(d2) >= this.m)) break block5;
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw GammaDistribution.b(notStrictlyPositiveException);
            }
            double d3 = (d2 - this.g) / this.g;
            double d4 = this.n * (FastMath.log1p(d3) - d3);
            double d5 = -d2 * 5.2421875 / this.g + 4.7421875 + d4;
            return this.i - FastMath.log(d) + d5;
        }
        return this.f - d2 + FastMath.log(d2) * (this.n - 1.0);
    }

    public double cumulativeProbability(double d) {
        double d2;
        block3: {
            block2: {
                int n = AbstractRealDistribution.a();
                if (!(d <= 0.0)) break block2;
                d2 = 0.0;
                if (n != 0) break block3;
            }
            d2 = Gamma.regularizedGammaP(this.n, d / this.l);
        }
        return d2;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.h;
    }

    public double getNumericalMean() {
        return this.n * this.l;
    }

    public double getNumericalVariance() {
        return this.n * this.l * this.l;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double sample() {
        int n = AbstractRealDistribution.b();
        if (this.n < 1.0) {
            while (true) {
                double d;
                double d2;
                block16: {
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    if ((d6 = (d5 = 1.0 + this.n / Math.E) * (d4 = this.b.nextDouble())) <= 1.0) {
                        d2 = FastMath.pow(d6, 1.0 / this.n);
                        d3 = this.b.nextDouble();
                        try {
                            try {
                                double d7 = d3 - FastMath.exp(-d2);
                                d = d7 == 0.0 ? 0 : (d7 > 0.0 ? 1 : -1);
                                if (n != 0) break block16;
                                if (d <= 0) return this.l * d2;
                            }
                            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                                throw GammaDistribution.b(notStrictlyPositiveException);
                            }
                            if (n == 0) continue;
                            return this.l * d2;
                        }
                        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                            throw GammaDistribution.b(notStrictlyPositiveException);
                        }
                    }
                    d2 = -1.0 * FastMath.log((d5 - d6) / this.n);
                    d3 = this.b.nextDouble();
                    double d8 = d3 - FastMath.pow(d2, this.n - 1.0);
                    d = d8 == 0.0 ? 0 : (d8 > 0.0 ? 1 : -1);
                }
                if (d <= 0 || n != 0) return this.l * d2;
                continue;
                break;
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw GammaDistribution.b(notStrictlyPositiveException);
            }
        }
        double d = this.n - 0.3333333333333333;
        double d9 = 1.0 / (3.0 * FastMath.sqrt(d));
        block11: while (true) {
            double d10 = this.b.nextGaussian();
            double d11 = (1.0 + d9 * d10) * (1.0 + d9 * d10) * (1.0 + d9 * d10);
            while (d11 <= 0.0) {
                if (n != 0) continue;
                if (n == 0) continue block11;
            }
            double d12 = d10 * d10;
            double d13 = this.b.nextDouble();
            try {
                if (d13 < 1.0 - 0.0331 * d12 * d12) {
                    return this.l * d * d11;
                }
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw GammaDistribution.b(notStrictlyPositiveException);
            }
            if (FastMath.log(d13) < 0.5 * d12 + d * (1.0 - d11 + FastMath.log(d11))) return this.l * d * d11;
            continue;
            break;
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw GammaDistribution.b(notStrictlyPositiveException);
        }
    }

    private static NotStrictlyPositiveException b(NotStrictlyPositiveException notStrictlyPositiveException) {
        return notStrictlyPositiveException;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block12: {
            int n;
            char[] cArray2;
            int n2;
            int n3;
            block11: {
                Object var0 = null;
                char[] cArray3 = "#tm\u001f\u0018".toCharArray();
                int n4 = cArray3.length;
                n3 = 0;
                n2 = 114;
                cArray2 = cArray3;
                n = n4;
                if (n4 <= 1) break block11;
                cArray = cArray2;
                n = n;
                if (n <= n3) break block12;
            }
            do {
                int n5 = n2;
                cArray2 = cArray2;
                char[] cArray4 = cArray2;
                int n6 = n2;
                int n7 = n3;
                while (true) {
                    int n8;
                    switch (n3 % 7) {
                        case 0: {
                            n8 = 51;
                            break;
                        }
                        case 1: {
                            n8 = 115;
                            break;
                        }
                        case 2: {
                            n8 = 126;
                            break;
                        }
                        case 3: {
                            n8 = 32;
                            break;
                        }
                        case 4: {
                            n8 = 14;
                            break;
                        }
                        case 5: {
                            n8 = 44;
                            break;
                        }
                        default: {
                            n8 = 19;
                        }
                    }
                    cArray4[n7] = (char)(cArray4[n7] ^ (n6 ^ n8));
                    ++n3;
                    n2 = n5;
                    if (n5 != 0) break;
                    n5 = n2;
                    cArray2 = cArray2;
                    n7 = n2;
                    cArray4 = cArray2;
                    n6 = n2;
                }
                cArray = cArray2;
                n = n;
            } while (n > n3);
        }
        q = new String(cArray).intern();
    }
}

