/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Beta;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.commons.math3.util.FastMath;

public class PascalDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 6751309484392813623L;
    private final int c;
    private final double d;
    private final double f;
    private final double e;

    public PascalDistribution(int n, double d) {
        this(new Well19937c(), n, d);
    }

    public PascalDistribution(RandomGenerator randomGenerator, int n, double d) {
        block5: {
            super(randomGenerator);
            if (n <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESSES, n);
            }
            try {
                try {
                    if (!(d < 0.0) && !(d > 1.0)) break block5;
                }
                catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                    throw PascalDistribution.b(notStrictlyPositiveException);
                }
                throw new OutOfRangeException(d, (Number)0, 1);
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw PascalDistribution.b(notStrictlyPositiveException);
            }
        }
        this.c = n;
        this.d = d;
        this.f = FastMath.log(d);
        this.e = FastMath.log1p(-d);
    }

    public int getNumberOfSuccesses() {
        return this.c;
    }

    public double getProbabilityOfSuccess() {
        return this.d;
    }

    public double probability(int n) {
        double d;
        block3: {
            block2: {
                int n2 = AbstractRealDistribution.a();
                if (n >= 0) break block2;
                d = 0.0;
                if (n2 != 0) break block3;
            }
            d = CombinatoricsUtils.binomialCoefficientDouble(n + this.c - 1, this.c - 1) * FastMath.pow(this.d, this.c) * FastMath.pow(1.0 - this.d, n);
        }
        return d;
    }

    public double logProbability(int n) {
        double d;
        block3: {
            block2: {
                int n2 = AbstractRealDistribution.a();
                if (n >= 0) break block2;
                d = Double.NEGATIVE_INFINITY;
                if (n2 != 0) break block3;
            }
            d = CombinatoricsUtils.binomialCoefficientLog(n + this.c - 1, this.c - 1) + this.f * (double)this.c + this.e * (double)n;
        }
        return d;
    }

    public double cumulativeProbability(int n) {
        double d;
        block3: {
            block2: {
                int n2 = AbstractRealDistribution.a();
                if (n >= 0) break block2;
                d = 0.0;
                if (n2 != 0) break block3;
            }
            d = Beta.regularizedBeta(this.d, this.c, (double)n + 1.0);
        }
        return d;
    }

    public double getNumericalMean() {
        double d = this.getProbabilityOfSuccess();
        double d2 = this.getNumberOfSuccesses();
        return d2 * (1.0 - d) / d;
    }

    public double getNumericalVariance() {
        double d = this.getProbabilityOfSuccess();
        double d2 = this.getNumberOfSuccesses();
        return d2 * (1.0 - d) / (d * d);
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    public boolean isSupportConnected() {
        return true;
    }

    private static NotStrictlyPositiveException b(NotStrictlyPositiveException notStrictlyPositiveException) {
        return notStrictlyPositiveException;
    }
}

