/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.io.PrintStream;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.util.FastMath;

class FastMathCalc {
    private static final long b = 0x40000000L;
    private static final double[] a;
    private static final double[][] d;
    private static final String c;
    private static final String e;
    private static final String[] f;

    private FastMathCalc() {
    }

    private static void buildSinCosTables(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, double[] dArray5, double[] dArray6) {
        double[] dArray7;
        double[] dArray8;
        int n2;
        String string;
        block13: {
            int n3;
            double[] dArray9;
            block12: {
                dArray9 = new double[2];
                string = FastMath.b();
                for (n2 = 0; n2 < 7; ++n2) {
                    double d = (double)n2 / 8.0;
                    try {
                        FastMathCalc.slowSin(d, dArray9);
                        dArray[n2] = dArray9[0];
                        dArray2[n2] = dArray9[1];
                        FastMathCalc.slowCos(d, dArray9);
                        dArray3[n2] = dArray9[0];
                        dArray4[n2] = dArray9[1];
                        if (string == null) {
                            if (string == null) continue;
                            break;
                        }
                        break block12;
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw FastMathCalc.b(dimensionMismatchException);
                    }
                }
                n2 = 7;
            }
            while (n2 < n) {
                block15: {
                    double[] dArray10 = new double[2];
                    dArray8 = new double[2];
                    dArray7 = new double[2];
                    double[] dArray11 = new double[2];
                    double[] dArray12 = new double[2];
                    try {
                        block14: {
                            try {
                                try {
                                    n3 = n2 & 1;
                                    if (string != null) break block13;
                                    if (n3 != 0) break block14;
                                }
                                catch (DimensionMismatchException dimensionMismatchException) {
                                    throw FastMathCalc.b(dimensionMismatchException);
                                }
                                dArray10[0] = dArray[n2 / 2];
                                dArray10[1] = dArray2[n2 / 2];
                                dArray8[0] = dArray3[n2 / 2];
                                dArray8[1] = dArray4[n2 / 2];
                                FastMathCalc.splitMult(dArray10, dArray8, dArray9);
                                dArray[n2] = dArray9[0] * 2.0;
                                dArray2[n2] = dArray9[1] * 2.0;
                                FastMathCalc.splitMult(dArray8, dArray8, dArray7);
                                FastMathCalc.splitMult(dArray10, dArray10, dArray12);
                                dArray12[0] = -dArray12[0];
                                dArray12[1] = -dArray12[1];
                                FastMathCalc.splitAdd(dArray7, dArray12, dArray9);
                                dArray3[n2] = dArray9[0];
                                dArray4[n2] = dArray9[1];
                                if (string == null) break block15;
                            }
                            catch (DimensionMismatchException dimensionMismatchException) {
                                throw FastMathCalc.b(dimensionMismatchException);
                            }
                        }
                        dArray10[0] = dArray[n2 / 2];
                        dArray10[1] = dArray2[n2 / 2];
                        dArray8[0] = dArray3[n2 / 2];
                        dArray8[1] = dArray4[n2 / 2];
                        dArray7[0] = dArray[n2 / 2 + 1];
                        dArray7[1] = dArray2[n2 / 2 + 1];
                        dArray11[0] = dArray3[n2 / 2 + 1];
                        dArray11[1] = dArray4[n2 / 2 + 1];
                        FastMathCalc.splitMult(dArray10, dArray11, dArray12);
                        FastMathCalc.splitMult(dArray8, dArray7, dArray9);
                        FastMathCalc.splitAdd(dArray9, dArray12, dArray9);
                        dArray[n2] = dArray9[0];
                        dArray2[n2] = dArray9[1];
                        FastMathCalc.splitMult(dArray8, dArray11, dArray9);
                        FastMathCalc.splitMult(dArray10, dArray7, dArray12);
                        dArray12[0] = -dArray12[0];
                        dArray12[1] = -dArray12[1];
                        FastMathCalc.splitAdd(dArray9, dArray12, dArray9);
                        dArray3[n2] = dArray9[0];
                        dArray4[n2] = dArray9[1];
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw FastMathCalc.b(dimensionMismatchException);
                    }
                }
                ++n2;
                if (string == null) continue;
            }
            n3 = n2 = 0;
        }
        while (n2 < n) {
            double[] dArray13 = new double[2];
            dArray8 = new double[2];
            dArray7 = new double[]{dArray3[n2], dArray4[n2]};
            FastMathCalc.splitReciprocal(dArray7, dArray8);
            dArray13[0] = dArray[n2];
            dArray13[1] = dArray2[n2];
            FastMathCalc.splitMult(dArray13, dArray8, dArray7);
            dArray5[n2] = dArray7[0];
            dArray6[n2] = dArray7[1];
            ++n2;
            if (string == null) continue;
        }
    }

    static double slowCos(double d, double[] dArray) {
        double[] dArray2;
        block12: {
            double[] dArray3 = new double[2];
            dArray2 = new double[2];
            double[] dArray4 = new double[2];
            String string = FastMath.b();
            double[] dArray5 = new double[2];
            FastMathCalc.split(d, dArray3);
            dArray2[1] = 0.0;
            dArray2[0] = 0.0;
            for (int i = a.length - 1; i >= 0; --i) {
                block14: {
                    try {
                        try {
                            block13: {
                                try {
                                    try {
                                        FastMathCalc.splitMult(dArray3, dArray2, dArray5);
                                        dArray2[0] = dArray5[0];
                                        dArray2[1] = dArray5[1];
                                        if (string != null) break block12;
                                        if ((i & 1) == 0) break block13;
                                    }
                                    catch (DimensionMismatchException dimensionMismatchException) {
                                        throw FastMathCalc.b(dimensionMismatchException);
                                    }
                                    if (string == null) continue;
                                }
                                catch (DimensionMismatchException dimensionMismatchException) {
                                    throw FastMathCalc.b(dimensionMismatchException);
                                }
                            }
                            FastMathCalc.split(a[i], dArray5);
                            FastMathCalc.splitReciprocal(dArray5, dArray4);
                            if ((i & 2) == 0) break block14;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw FastMathCalc.b(dimensionMismatchException);
                        }
                        dArray4[0] = -dArray4[0];
                        dArray4[1] = -dArray4[1];
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw FastMathCalc.b(dimensionMismatchException);
                    }
                }
                FastMathCalc.splitAdd(dArray2, dArray4, dArray5);
                dArray2[0] = dArray5[0];
                dArray2[1] = dArray5[1];
                if (string == null) continue;
            }
            try {
                if (dArray != null) {
                    dArray[0] = dArray2[0];
                    dArray[1] = dArray2[1];
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw FastMathCalc.b(dimensionMismatchException);
            }
        }
        return dArray2[0] + dArray2[1];
    }

    static double slowSin(double d, double[] dArray) {
        double[] dArray2;
        block12: {
            double[] dArray3 = new double[2];
            dArray2 = new double[2];
            double[] dArray4 = new double[2];
            double[] dArray5 = new double[2];
            String string = FastMath.b();
            FastMathCalc.split(d, dArray3);
            String string2 = string;
            dArray2[1] = 0.0;
            dArray2[0] = 0.0;
            for (int i = a.length - 1; i >= 0; --i) {
                block14: {
                    try {
                        try {
                            block13: {
                                try {
                                    try {
                                        FastMathCalc.splitMult(dArray3, dArray2, dArray5);
                                        dArray2[0] = dArray5[0];
                                        dArray2[1] = dArray5[1];
                                        if (string2 != null) break block12;
                                        if ((i & 1) != 0) break block13;
                                    }
                                    catch (DimensionMismatchException dimensionMismatchException) {
                                        throw FastMathCalc.b(dimensionMismatchException);
                                    }
                                    if (string2 == null) continue;
                                }
                                catch (DimensionMismatchException dimensionMismatchException) {
                                    throw FastMathCalc.b(dimensionMismatchException);
                                }
                            }
                            FastMathCalc.split(a[i], dArray5);
                            FastMathCalc.splitReciprocal(dArray5, dArray4);
                            if ((i & 2) == 0) break block14;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw FastMathCalc.b(dimensionMismatchException);
                        }
                        dArray4[0] = -dArray4[0];
                        dArray4[1] = -dArray4[1];
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw FastMathCalc.b(dimensionMismatchException);
                    }
                }
                FastMathCalc.splitAdd(dArray2, dArray4, dArray5);
                dArray2[0] = dArray5[0];
                dArray2[1] = dArray5[1];
                if (string2 == null) continue;
            }
            try {
                if (dArray != null) {
                    dArray[0] = dArray2[0];
                    dArray[1] = dArray2[1];
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw FastMathCalc.b(dimensionMismatchException);
            }
        }
        return dArray2[0] + dArray2[1];
    }

    static double slowexp(double d, double[] dArray) {
        double[] dArray2;
        block7: {
            double[] dArray3 = new double[2];
            dArray2 = new double[2];
            String string = FastMath.b();
            double[] dArray4 = new double[2];
            double[] dArray5 = new double[2];
            FastMathCalc.split(d, dArray3);
            dArray2[1] = 0.0;
            dArray2[0] = 0.0;
            String string2 = string;
            for (int i = a.length - 1; i >= 0; --i) {
                try {
                    FastMathCalc.splitMult(dArray3, dArray2, dArray5);
                    dArray2[0] = dArray5[0];
                    dArray2[1] = dArray5[1];
                    FastMathCalc.split(a[i], dArray5);
                    FastMathCalc.splitReciprocal(dArray5, dArray4);
                    FastMathCalc.splitAdd(dArray2, dArray4, dArray5);
                    dArray2[0] = dArray5[0];
                    dArray2[1] = dArray5[1];
                    if (string2 == null) {
                        if (string2 == null) continue;
                        break;
                    }
                    break block7;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw FastMathCalc.b(dimensionMismatchException);
                }
            }
            try {
                if (dArray != null) {
                    dArray[0] = dArray2[0];
                    dArray[1] = dArray2[1];
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw FastMathCalc.b(dimensionMismatchException);
            }
        }
        return dArray2[0] + dArray2[1];
    }

    private static void split(double d, double[] dArray) {
        block5: {
            double d2;
            block4: {
                String string = FastMath.b();
                try {
                    if (!(d < 8.0E298) || !(d > -8.0E298)) break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw FastMathCalc.b(dimensionMismatchException);
                }
                d2 = d * 1.073741824E9;
                dArray[0] = d + d2 - d2;
                dArray[1] = d - dArray[0];
                if (string == null) break block5;
            }
            d2 = d * 9.313225746154785E-10;
            dArray[0] = (d + d2 - d) * 1.073741824E9;
            dArray[1] = d - dArray[0];
        }
    }

    private static void resplit(double[] dArray) {
        block5: {
            double d;
            double d2;
            double d3;
            block4: {
                d3 = dArray[0] + dArray[1];
                d2 = -(d3 - dArray[0] - dArray[1]);
                String string = FastMath.b();
                try {
                    if (!(d3 < 8.0E298) || !(d3 > -8.0E298)) break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw FastMathCalc.b(dimensionMismatchException);
                }
                d = d3 * 1.073741824E9;
                dArray[0] = d3 + d - d;
                dArray[1] = d3 - dArray[0] + d2;
                if (string == null) break block5;
            }
            d = d3 * 9.313225746154785E-10;
            dArray[0] = (d3 + d - d3) * 1.073741824E9;
            dArray[1] = d3 - dArray[0] + d2;
        }
    }

    private static void splitMult(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[0] * dArray2[0];
        dArray3[1] = dArray[0] * dArray2[1] + dArray[1] * dArray2[0] + dArray[1] * dArray2[1];
        FastMathCalc.resplit(dArray3);
    }

    private static void splitAdd(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[0] + dArray2[0];
        dArray3[1] = dArray[1] + dArray2[1];
        FastMathCalc.resplit(dArray3);
    }

    static void splitReciprocal(double[] dArray, double[] dArray2) {
        double d = 2.384185791015625E-7;
        double d2 = 0.9999997615814209;
        String string = FastMath.b();
        try {
            if (dArray[0] == 0.0) {
                dArray[0] = dArray[1];
                dArray[1] = 0.0;
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw FastMathCalc.b(dimensionMismatchException);
        }
        try {
            dArray2[0] = 0.9999997615814209 / dArray[0];
            dArray2[1] = (2.384185791015625E-7 * dArray[0] - 0.9999997615814209 * dArray[1]) / (dArray[0] * dArray[0] + dArray[0] * dArray[1]);
            if (dArray2[1] != dArray2[1]) {
                dArray2[1] = 0.0;
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw FastMathCalc.b(dimensionMismatchException);
        }
        FastMathCalc.resplit(dArray2);
        for (int i = 0; i < 2; ++i) {
            double d3 = 1.0 - dArray2[0] * dArray[0] - dArray2[0] * dArray[1] - dArray2[1] * dArray[0] - dArray2[1] * dArray[1];
            dArray2[1] = dArray2[1] + (d3 *= dArray2[0] + dArray2[1]);
            if (string == null) continue;
        }
    }

    private static void quadMult(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        double[] dArray6 = new double[2];
        FastMathCalc.split(dArray[0], dArray4);
        FastMathCalc.split(dArray2[0], dArray5);
        FastMathCalc.splitMult(dArray4, dArray5, dArray6);
        dArray3[0] = dArray6[0];
        dArray3[1] = dArray6[1];
        FastMathCalc.split(dArray2[1], dArray5);
        FastMathCalc.splitMult(dArray4, dArray5, dArray6);
        double d = dArray3[0] + dArray6[0];
        dArray3[1] = dArray3[1] - (d - dArray3[0] - dArray6[0]);
        dArray3[0] = d;
        d = dArray3[0] + dArray6[1];
        dArray3[1] = dArray3[1] - (d - dArray3[0] - dArray6[1]);
        dArray3[0] = d;
        FastMathCalc.split(dArray[1], dArray4);
        FastMathCalc.split(dArray2[0], dArray5);
        FastMathCalc.splitMult(dArray4, dArray5, dArray6);
        d = dArray3[0] + dArray6[0];
        dArray3[1] = dArray3[1] - (d - dArray3[0] - dArray6[0]);
        dArray3[0] = d;
        d = dArray3[0] + dArray6[1];
        dArray3[1] = dArray3[1] - (d - dArray3[0] - dArray6[1]);
        dArray3[0] = d;
        FastMathCalc.split(dArray[1], dArray4);
        FastMathCalc.split(dArray2[1], dArray5);
        FastMathCalc.splitMult(dArray4, dArray5, dArray6);
        d = dArray3[0] + dArray6[0];
        dArray3[1] = dArray3[1] - (d - dArray3[0] - dArray6[0]);
        dArray3[0] = d;
        d = dArray3[0] + dArray6[1];
        dArray3[1] = dArray3[1] - (d - dArray3[0] - dArray6[1]);
        dArray3[0] = d;
    }

    static double expint(int n, double[] dArray) {
        double[] dArray2;
        block8: {
            double[] dArray3 = new double[2];
            double[] dArray4 = new double[2];
            dArray2 = new double[2];
            String string = FastMath.b();
            dArray3[0] = Math.E;
            dArray3[1] = 1.4456468917292502E-16;
            FastMathCalc.split(1.0, dArray2);
            while (n > 0) {
                block9: {
                    try {
                        try {
                            if (string != null) break block8;
                            if ((n & 1) == 0) break block9;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw FastMathCalc.b(dimensionMismatchException);
                        }
                        FastMathCalc.quadMult(dArray2, dArray3, dArray4);
                        dArray2[0] = dArray4[0];
                        dArray2[1] = dArray4[1];
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw FastMathCalc.b(dimensionMismatchException);
                    }
                }
                FastMathCalc.quadMult(dArray3, dArray3, dArray4);
                dArray3[0] = dArray4[0];
                dArray3[1] = dArray4[1];
                n >>= 1;
                if (string == null) continue;
            }
            try {
                if (dArray != null) {
                    dArray[0] = dArray2[0];
                    dArray[1] = dArray2[1];
                    FastMathCalc.resplit(dArray);
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw FastMathCalc.b(dimensionMismatchException);
            }
        }
        return dArray2[0] + dArray2[1];
    }

    static double[] slowLog(double d) {
        double[] dArray;
        block4: {
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[2];
            dArray = new double[2];
            double[] dArray4 = new double[2];
            FastMathCalc.split(d, dArray2);
            dArray2[0] = dArray2[0] + 1.0;
            FastMathCalc.resplit(dArray2);
            FastMathCalc.splitReciprocal(dArray2, dArray4);
            dArray2[0] = dArray2[0] - 2.0;
            FastMathCalc.resplit(dArray2);
            FastMathCalc.splitMult(dArray2, dArray4, dArray);
            dArray2[0] = dArray[0];
            String string = FastMath.b();
            dArray2[1] = dArray[1];
            FastMathCalc.splitMult(dArray2, dArray2, dArray3);
            dArray[0] = FastMathCalc.d[FastMathCalc.d.length - 1][0];
            dArray[1] = FastMathCalc.d[FastMathCalc.d.length - 1][1];
            String string2 = string;
            for (int i = FastMathCalc.d.length - 2; i >= 0; --i) {
                try {
                    FastMathCalc.splitMult(dArray, dArray3, dArray4);
                    dArray[0] = dArray4[0];
                    dArray[1] = dArray4[1];
                    FastMathCalc.splitAdd(dArray, FastMathCalc.d[i], dArray4);
                    dArray[0] = dArray4[0];
                    dArray[1] = dArray4[1];
                    if (string2 == null) {
                        if (string2 == null) continue;
                        break;
                    }
                    break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw FastMathCalc.b(dimensionMismatchException);
                }
            }
            FastMathCalc.splitMult(dArray, dArray2, dArray4);
            dArray[0] = dArray4[0];
            dArray[1] = dArray4[1];
        }
        return dArray;
    }

    static void printarray(PrintStream printStream, String string, int n, double[][] dArray) {
        block5: {
            printStream.println(string);
            String string2 = FastMath.b();
            FastMathCalc.checkLen(n, dArray.length);
            String string3 = string2;
            String[] stringArray = f;
            printStream.println(stringArray[7]);
            int n2 = 0;
            double[][] dArray2 = dArray;
            int n3 = dArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                block6: {
                    double[] dArray3 = dArray2[n4];
                    stringArray = f;
                    printStream.print(stringArray[0]);
                    double[] dArray4 = dArray3;
                    int n5 = dArray4.length;
                    if (string3 != null) break block5;
                    for (int i = 0; i < n5; ++i) {
                        double d = dArray4[i];
                        try {
                            stringArray = f;
                            printStream.printf(stringArray[8], FastMathCalc.format(d));
                            if (string3 == null) {
                                if (string3 == null) continue;
                                break;
                            }
                            break block6;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw FastMathCalc.b(dimensionMismatchException);
                        }
                    }
                    stringArray = f;
                    printStream.println(stringArray[4] + n2++);
                    ++n4;
                }
                if (string3 == null) continue;
            }
            printStream.println(f[6]);
        }
    }

    static void printarray(PrintStream printStream, String string, int n, double[] dArray) {
        block4: {
            printStream.println(string + "=");
            FastMathCalc.checkLen(n, dArray.length);
            String string2 = FastMath.b();
            String[] stringArray = f;
            printStream.println(stringArray[2]);
            double[] dArray2 = dArray;
            int n2 = dArray2.length;
            String string3 = string2;
            for (int i = 0; i < n2; ++i) {
                double d = dArray2[i];
                try {
                    stringArray = f;
                    printStream.printf(stringArray[1], FastMathCalc.format(d));
                    if (string3 == null) {
                        if (string3 == null) continue;
                        break;
                    }
                    break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw FastMathCalc.b(dimensionMismatchException);
                }
            }
            printStream.println(f[6]);
        }
    }

    static String format(double d) {
        String string;
        StringBuilder stringBuilder;
        try {
            if (d != d) {
                String[] stringArray = f;
                return stringArray[5];
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw FastMathCalc.b(dimensionMismatchException);
        }
        try {
            stringBuilder = new StringBuilder();
            string = d >= 0.0 ? "+" : "";
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw FastMathCalc.b(dimensionMismatchException);
        }
        return stringBuilder.append(string).append(Double.toString(d)).append(f[3]).toString();
    }

    private static void checkLen(int n, int n2) {
        try {
            if (n != n2) {
                throw new DimensionMismatchException(n2, n);
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw FastMathCalc.b(dimensionMismatchException);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        int n;
        Object var6_6;
        String[] stringArray = new String[9];
        int n2 = 0;
        String string = "6\"rp\n\u001bR6y\f6\"rp\n\u001bR6'!uD\u00056\"rpQ\u0002r.\u0006k.r\u007f\u0005\u001b\u000bRm'2F^\\Xc\u001c|\u00066\"rpW\u0000";
        int n3 = "6\"rp\n\u001bR6y\f6\"rp\n\u001bR6'!uD\u00056\"rpQ\u0002r.\u0006k.r\u007f\u0005\u001b\u000bRm'2F^\\Xc\u001c|\u00066\"rpW\u0000".length();
        int n4 = 9;
        int n5 = -1;
        while (true) {
            char[] cArray;
            block26: {
                int n6;
                char[] cArray2;
                int n7;
                block25: {
                    int n8 = ++n5;
                    var6_6 = null;
                    char[] cArray3 = string.substring(n8, n8 + n4).toCharArray();
                    int n9 = cArray3.length;
                    n = 0;
                    n7 = 71;
                    cArray2 = cArray3;
                    n6 = n9;
                    if (n9 <= 1) break block25;
                    cArray = cArray2;
                    n6 = n6;
                    if (n6 <= n) break block26;
                }
                do {
                    int n10 = n7;
                    cArray2 = cArray2;
                    char[] cArray4 = cArray2;
                    int n11 = n7;
                    int n12 = n;
                    while (true) {
                        int n13;
                        switch (n % 7) {
                            case 0: {
                                n13 = 81;
                                break;
                            }
                            case 1: {
                                n13 = 69;
                                break;
                            }
                            case 2: {
                                n13 = 21;
                                break;
                            }
                            case 3: {
                                n13 = 23;
                                break;
                            }
                            case 4: {
                                n13 = 109;
                                break;
                            }
                            case 5: {
                                n13 = 124;
                                break;
                            }
                            default: {
                                n13 = 53;
                            }
                        }
                        cArray4[n12] = (char)(cArray4[n12] ^ (n11 ^ n13));
                        ++n;
                        n7 = n10;
                        if (n10 != 0) break;
                        n10 = n7;
                        cArray2 = cArray2;
                        n12 = n7;
                        cArray4 = cArray2;
                        n11 = n7;
                    }
                    cArray = cArray2;
                    n6 = n6;
                } while (n6 > n);
            }
            stringArray[n2++] = new String(cArray).intern();
            if ((n5 += n4) >= n3) break;
            n4 = string.charAt(n5);
        }
        string = "3'wuT\u001e\b6*e`\u0001\fB`";
        n3 = "3'wuT\u001e\b6*e`\u0001\fB`".length();
        n4 = 6;
        n5 = -1;
        while (true) {
            char[] cArray;
            block28: {
                int n14;
                char[] cArray5;
                int n15;
                block27: {
                    int n16 = ++n5;
                    var6_6 = null;
                    char[] cArray6 = string.substring(n16, n16 + n4).toCharArray();
                    int n17 = cArray6.length;
                    n = 0;
                    n15 = 66;
                    cArray5 = cArray6;
                    n14 = n17;
                    if (n17 <= 1) break block27;
                    cArray = cArray5;
                    n14 = n14;
                    if (n14 <= n) break block28;
                }
                do {
                    int n18 = n15;
                    cArray5 = cArray5;
                    char[] cArray7 = cArray5;
                    int n19 = n15;
                    int n20 = n;
                    while (true) {
                        int n21;
                        switch (n % 7) {
                            case 0: {
                                n21 = 81;
                                break;
                            }
                            case 1: {
                                n21 = 69;
                                break;
                            }
                            case 2: {
                                n21 = 21;
                                break;
                            }
                            case 3: {
                                n21 = 23;
                                break;
                            }
                            case 4: {
                                n21 = 109;
                                break;
                            }
                            case 5: {
                                n21 = 124;
                                break;
                            }
                            default: {
                                n21 = 53;
                            }
                        }
                        cArray7[n20] = (char)(cArray7[n20] ^ (n19 ^ n21));
                        ++n;
                        n15 = n18;
                        if (n18 != 0) break;
                        n18 = n15;
                        cArray5 = cArray5;
                        n20 = n15;
                        cArray7 = cArray5;
                        n19 = n15;
                    }
                    cArray = cArray5;
                    n14 = n14;
                } while (n14 > n);
            }
            stringArray[n2++] = new String(cArray).intern();
            if ((n5 += n4) >= n3) {
                f = stringArray;
                c = f[2];
                e = f[6];
                a = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17};
                d = new double[][]{{2.0, 0.0}, {0.6666666269302368, 3.9736429850260626E-8}, {0.3999999761581421, 2.3841857910019882E-8}, {0.2857142686843872, 1.7029898543501842E-8}, {0.2222222089767456, 1.3245471311735498E-8}, {0.1818181574344635, 2.4384203044354907E-8}, {0.1538461446762085, 9.140260083262505E-9}, {0.13333332538604736, 9.220590270857665E-9}, {0.11764700710773468, 1.2393345855018391E-8}, {0.10526403784751892, 8.251545029714408E-9}, {0.0952233225107193, 1.2675934823758863E-8}, {0.08713622391223907, 1.1430250008909141E-8}, {0.07842259109020233, 2.404307984052299E-9}, {0.08371849358081818, 1.176342548272881E-8}, {0.03058958f, 1.2958646899018938E-9}, {0.14982303977012634, 1.225743062930824E-8}};
                return;
            }
            n4 = string.charAt(n5);
        }
    }

    private static DimensionMismatchException b(DimensionMismatchException dimensionMismatchException) {
        return dimensionMismatchException;
    }
}

