/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.util.Iterator;
import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.ZeroException;

public class IntegerSequence {
    private IntegerSequence() {
    }

    public static Range range(int n, int n2) {
        return IntegerSequence.range(n, n2, 1);
    }

    public static Range range(int n, int n2, int n3) {
        return new Range(n, n2, n3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Incrementor
    implements Iterator<Integer> {
        private static final MaxCountExceededCallback a = new MaxCountExceededCallback(){

            public void trigger(int n) {
                throw new MaxCountExceededException(n);
            }
        };
        private final int e;
        private final int d;
        private final int f;
        private final MaxCountExceededCallback c;
        private int b = 0;

        private Incrementor(int n, int n2, int n3, MaxCountExceededCallback maxCountExceededCallback) {
            if (maxCountExceededCallback == null) {
                throw new NullArgumentException();
            }
            this.e = n;
            this.d = n2;
            this.f = n3;
            this.c = maxCountExceededCallback;
            this.b = n;
        }

        public static Incrementor create() {
            return new Incrementor(0, 0, 1, a);
        }

        public Incrementor withStart(int n) {
            return new Incrementor(n, this.d, this.f, this.c);
        }

        public Incrementor withMaximalCount(int n) {
            return new Incrementor(this.e, n, this.f, this.c);
        }

        public Incrementor withIncrement(int n) {
            try {
                if (n == 0) {
                    throw new ZeroException();
                }
            }
            catch (NullArgumentException nullArgumentException) {
                throw Incrementor.b(nullArgumentException);
            }
            return new Incrementor(this.e, this.d, n, this.c);
        }

        public Incrementor withCallback(MaxCountExceededCallback maxCountExceededCallback) {
            return new Incrementor(this.e, this.d, this.f, maxCountExceededCallback);
        }

        public int getMaximalCount() {
            return this.d;
        }

        public int getCount() {
            return this.b;
        }

        public boolean canIncrement() {
            return this.canIncrement(1);
        }

        public boolean canIncrement(int n) {
            boolean bl;
            block8: {
                int n2;
                block6: {
                    block7: {
                        n2 = this.b + n * this.f;
                        try {
                            try {
                                if (this.f >= 0) break block6;
                                if (n2 <= this.d) break block7;
                            }
                            catch (NullArgumentException nullArgumentException) {
                                throw Incrementor.b(nullArgumentException);
                            }
                            bl = true;
                            break block8;
                        }
                        catch (NullArgumentException nullArgumentException) {
                            throw Incrementor.b(nullArgumentException);
                        }
                    }
                    bl = false;
                    break block8;
                }
                try {
                    bl = n2 < this.d;
                }
                catch (NullArgumentException nullArgumentException) {
                    throw Incrementor.b(nullArgumentException);
                }
            }
            return bl;
        }

        public void increment(int n) {
            try {
                if (n <= 0) {
                    throw new NotStrictlyPositiveException(n);
                }
            }
            catch (MaxCountExceededException maxCountExceededException) {
                throw Incrementor.b(maxCountExceededException);
            }
            try {
                if (!this.canIncrement(0)) {
                    this.c.trigger(this.d);
                }
            }
            catch (MaxCountExceededException maxCountExceededException) {
                throw Incrementor.b(maxCountExceededException);
            }
            this.b += n * this.f;
        }

        public void increment() {
            this.increment(1);
        }

        @Override
        public boolean hasNext() {
            return this.canIncrement(0);
        }

        @Override
        public Integer next() {
            int n = this.b;
            this.increment();
            return n;
        }

        @Override
        public void remove() {
            throw new MathUnsupportedOperationException();
        }

        private static RuntimeException b(RuntimeException runtimeException) {
            return runtimeException;
        }

        public static interface MaxCountExceededCallback {
            public void trigger(int var1) throws MaxCountExceededException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Range
    implements Iterable<Integer> {
        private final int d;
        private final int a;
        private final int b;
        private final int c;

        public Range(int n, int n2, int n3) {
            this.a = n;
            this.b = n2;
            this.c = n3;
            int n4 = (n2 - n) / n3 + 1;
            this.d = n4 < 0 ? 0 : n4;
        }

        public int size() {
            return this.d;
        }

        @Override
        public Iterator<Integer> iterator() {
            return Incrementor.create().withStart(this.a).withMaximalCount(this.b + (this.c > 0 ? 1 : -1)).withIncrement(this.c);
        }
    }
}

