/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.DoubleArray;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

public class ResizableDoubleArray
implements DoubleArray,
Serializable {
    @Deprecated
    public static final int h = 1;
    @Deprecated
    public static final int i = 0;
    private static final long serialVersionUID = -3485529955529426875L;
    private static final int k = 16;
    private static final double b = 2.0;
    private static final double g = 0.5;
    private double d;
    private double e;
    private ExpansionMode a;
    private double[] c;
    private int f;
    private int j;
    private static final String[] l;

    public ResizableDoubleArray() {
        this(16);
    }

    public ResizableDoubleArray(int n) {
        this(n, 2.0);
    }

    public ResizableDoubleArray(double[] dArray) {
        this(16, 2.0, 2.5, ExpansionMode.MULTIPLICATIVE, dArray);
    }

    @Deprecated
    public ResizableDoubleArray(int n, float f) {
        this(n, (double)f);
    }

    public ResizableDoubleArray(int n, double d) {
        this(n, d, 0.5 + d);
    }

    @Deprecated
    public ResizableDoubleArray(int n, float f, float f2) {
        this(n, (double)f, (double)f2);
    }

    public ResizableDoubleArray(int n, double d, double d2) {
        this(n, d, d2, ExpansionMode.MULTIPLICATIVE, null);
    }

    @Deprecated
    public ResizableDoubleArray(int n, float f, float f2, int n2) {
        this(n, f, f2, n2 == 1 ? ExpansionMode.ADDITIVE : ExpansionMode.MULTIPLICATIVE, null);
        this.setExpansionMode(n2);
    }

    public ResizableDoubleArray(int n, double d, double d2, ExpansionMode expansionMode, double ... dArray) {
        block5: {
            this.d = 2.5;
            this.e = 2.0;
            this.a = ExpansionMode.MULTIPLICATIVE;
            this.f = 0;
            this.j = 0;
            if (n <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.INITIAL_CAPACITY_NOT_POSITIVE, n);
            }
            try {
                try {
                    this.checkContractExpand(d2, d);
                    this.e = d;
                    this.d = d2;
                    this.a = expansionMode;
                    this.c = new double[n];
                    this.f = 0;
                    this.j = 0;
                    if (dArray == null || dArray.length <= 0) break block5;
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw ResizableDoubleArray.b(mathIllegalArgumentException);
                }
                this.addElements(dArray);
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw ResizableDoubleArray.b(mathIllegalArgumentException);
            }
        }
    }

    public ResizableDoubleArray(ResizableDoubleArray resizableDoubleArray) {
        this.d = 2.5;
        this.e = 2.0;
        this.a = ExpansionMode.MULTIPLICATIVE;
        this.f = 0;
        this.j = 0;
        MathUtils.checkNotNull(resizableDoubleArray);
        ResizableDoubleArray.copy(resizableDoubleArray, this);
    }

    public synchronized void addElement(double d) {
        try {
            if (this.c.length <= this.j + this.f) {
                this.expand();
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        this.c[this.j + this.f++] = d;
    }

    public synchronized void addElements(double[] dArray) {
        double[] dArray2 = new double[this.f + dArray.length + 1];
        System.arraycopy(this.c, this.j, dArray2, 0, this.f);
        System.arraycopy(dArray, 0, dArray2, this.f, dArray.length);
        this.c = dArray2;
        this.j = 0;
        this.f += dArray.length;
    }

    public synchronized double addElementRolling(double d) {
        double d2 = this.c[this.j];
        try {
            if (this.j + (this.f + 1) > this.c.length) {
                this.expand();
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            ++this.j;
            this.c[this.j + (this.f - 1)] = d;
            if (this.shouldContract()) {
                this.contract();
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        return d2;
    }

    public synchronized double substituteMostRecentElement(double d) {
        try {
            if (this.f < 1) {
                throw new MathIllegalStateException(LocalizedFormats.CANNOT_SUBSTITUTE_ELEMENT_FROM_EMPTY_ARRAY, new Object[0]);
            }
        }
        catch (MathIllegalStateException mathIllegalStateException) {
            throw ResizableDoubleArray.b(mathIllegalStateException);
        }
        int n = this.j + (this.f - 1);
        double d2 = this.c[n];
        this.c[n] = d;
        return d2;
    }

    @Deprecated
    protected void checkContractExpand(float f, float f2) {
        this.checkContractExpand((double)f, (double)f2);
    }

    protected void checkContractExpand(double d, double d2) {
        if (d < d2) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d, (Number)1, true);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.CONTRACTION_CRITERIA_SMALLER_THAN_EXPANSION_FACTOR, d, d2);
            throw numberIsTooSmallException;
        }
        if (d <= 1.0) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d, (Number)1, false);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.CONTRACTION_CRITERIA_SMALLER_THAN_ONE, d);
            throw numberIsTooSmallException;
        }
        if (d2 <= 1.0) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d, (Number)1, false);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.EXPANSION_FACTOR_SMALLER_THAN_ONE, d2);
            throw numberIsTooSmallException;
        }
    }

    public synchronized void clear() {
        this.f = 0;
        this.j = 0;
    }

    public synchronized void contract() {
        double[] dArray = new double[this.f + 1];
        System.arraycopy(this.c, this.j, dArray, 0, this.f);
        this.c = dArray;
        this.j = 0;
    }

    public synchronized void discardFrontElements(int n) {
        this.discardExtremeElements(n, true);
    }

    public synchronized void discardMostRecentElements(int n) {
        this.discardExtremeElements(n, false);
    }

    private synchronized void discardExtremeElements(int n, boolean bl) {
        try {
            if (n > this.f) {
                throw new MathIllegalArgumentException(LocalizedFormats.TOO_MANY_ELEMENTS_TO_DISCARD_FROM_ARRAY, n, this.f);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (n < 0) {
                throw new MathIllegalArgumentException(LocalizedFormats.CANNOT_DISCARD_NEGATIVE_NUMBER_OF_ELEMENTS, n);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            this.f -= n;
            if (bl) {
                this.j += n;
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (this.shouldContract()) {
                this.contract();
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
    }

    protected synchronized void expand() {
        int n = 0;
        n = this.a == ExpansionMode.MULTIPLICATIVE ? (int)FastMath.ceil((double)this.c.length * this.e) : (int)((long)this.c.length + FastMath.round(this.e));
        double[] dArray = new double[n];
        System.arraycopy(this.c, 0, dArray, 0, this.c.length);
        this.c = dArray;
    }

    private synchronized void expandTo(int n) {
        double[] dArray = new double[n];
        System.arraycopy(this.c, 0, dArray, 0, this.c.length);
        this.c = dArray;
    }

    @Deprecated
    public float getContractionCriteria() {
        return (float)this.getContractionCriterion();
    }

    public double getContractionCriterion() {
        return this.d;
    }

    public synchronized double getElement(int n) {
        try {
            if (n >= this.f) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (n >= 0) {
                return this.c[this.j + n];
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public synchronized double[] getElements() {
        double[] dArray = new double[this.f];
        System.arraycopy(this.c, this.j, dArray, 0, this.f);
        return dArray;
    }

    @Deprecated
    public float getExpansionFactor() {
        return (float)this.e;
    }

    @Deprecated
    public int getExpansionMode() {
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            switch (this.a) {
                case MULTIPLICATIVE: {
                    return 0;
                }
                case ADDITIVE: {
                    return 1;
                }
            }
            throw new MathInternalError();
        }
    }

    @Deprecated
    synchronized int getInternalLength() {
        return this.c.length;
    }

    public int getCapacity() {
        return this.c.length;
    }

    public synchronized int getNumElements() {
        return this.f;
    }

    @Deprecated
    public synchronized double[] getInternalValues() {
        return this.c;
    }

    protected double[] getArrayRef() {
        return this.c;
    }

    protected int getStartIndex() {
        return this.j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setContractionCriteria(float f) {
        this.checkContractExpand(f, this.getExpansionFactor());
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            this.d = f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double compute(MathArrays.Function function) {
        int n;
        int n2;
        double[] dArray;
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            dArray = this.c;
            n2 = this.j;
            n = this.f;
        }
        return function.evaluate(dArray, n2, n);
    }

    public synchronized void setElement(int n, double d) {
        try {
            if (n < 0) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (n + 1 > this.f) {
                this.f = n + 1;
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (this.j + n >= this.c.length) {
                this.expandTo(this.j + (n + 1));
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        this.c[this.j + n] = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setExpansionFactor(float f) {
        this.checkContractExpand(this.getContractionCriterion(), (double)f);
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            this.e = f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Deprecated
    public void setExpansionMode(int n) {
        block14: {
            String string;
            block11: {
                string = FastMath.b();
                if (n == 0) break block11;
                try {
                    block12: {
                        if (n == 1) break block11;
                        break block12;
                        catch (MathIllegalArgumentException mathIllegalArgumentException) {
                            throw ResizableDoubleArray.b(mathIllegalArgumentException);
                        }
                    }
                    Object[] objectArray = new Object[5];
                    objectArray[0] = n;
                    objectArray[1] = 0;
                    String[] stringArray = l;
                    objectArray[2] = stringArray[1];
                    objectArray[3] = 1;
                    objectArray[4] = stringArray[0];
                    throw new MathIllegalArgumentException(LocalizedFormats.UNSUPPORTED_EXPANSION_MODE, objectArray);
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw ResizableDoubleArray.b(mathIllegalArgumentException);
                }
            }
            ResizableDoubleArray resizableDoubleArray = this;
            synchronized (resizableDoubleArray) {
                block13: {
                    if (n != 0) break block13;
                    this.setExpansionMode(ExpansionMode.MULTIPLICATIVE);
                    if (string == null) break block14;
                }
                if (n == 1) {
                    this.setExpansionMode(ExpansionMode.ADDITIVE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setExpansionMode(ExpansionMode expansionMode) {
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            this.a = expansionMode;
        }
    }

    @Deprecated
    protected void setInitialCapacity(int n) {
    }

    public synchronized void setNumElements(int n) {
        try {
            if (n < 0) {
                throw new MathIllegalArgumentException(LocalizedFormats.INDEX_NOT_POSITIVE, n);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        int n2 = this.j + n;
        try {
            if (n2 > this.c.length) {
                this.expandTo(n2);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        this.f = n;
    }

    private synchronized boolean shouldContract() {
        boolean bl;
        block6: {
            boolean bl2;
            block8: {
                block7: {
                    try {
                        try {
                            if (this.a != ExpansionMode.MULTIPLICATIVE) break block6;
                            if (!((double)((float)this.c.length / (float)this.f) > this.d)) break block7;
                        }
                        catch (MathIllegalArgumentException mathIllegalArgumentException) {
                            throw ResizableDoubleArray.b(mathIllegalArgumentException);
                        }
                        bl2 = true;
                        break block8;
                    }
                    catch (MathIllegalArgumentException mathIllegalArgumentException) {
                        throw ResizableDoubleArray.b(mathIllegalArgumentException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }
        try {
            bl = (double)(this.c.length - this.f) > this.d;
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        return bl;
    }

    @Deprecated
    public synchronized int start() {
        return this.j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(ResizableDoubleArray resizableDoubleArray, ResizableDoubleArray resizableDoubleArray2) {
        MathUtils.checkNotNull(resizableDoubleArray);
        MathUtils.checkNotNull(resizableDoubleArray2);
        ResizableDoubleArray resizableDoubleArray3 = resizableDoubleArray;
        synchronized (resizableDoubleArray3) {
            ResizableDoubleArray resizableDoubleArray4 = resizableDoubleArray2;
            synchronized (resizableDoubleArray4) {
                resizableDoubleArray2.d = resizableDoubleArray.d;
                resizableDoubleArray2.e = resizableDoubleArray.e;
                resizableDoubleArray2.a = resizableDoubleArray.a;
                resizableDoubleArray2.c = new double[resizableDoubleArray.c.length];
                System.arraycopy(resizableDoubleArray.c, 0, resizableDoubleArray2.c, 0, resizableDoubleArray2.c.length);
                resizableDoubleArray2.f = resizableDoubleArray.f;
                resizableDoubleArray2.j = resizableDoubleArray.j;
            }
        }
    }

    public synchronized ResizableDoubleArray copy() {
        ResizableDoubleArray resizableDoubleArray = new ResizableDoubleArray();
        ResizableDoubleArray.copy(this, resizableDoubleArray);
        return resizableDoubleArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        try {
            if (object == this) {
                return true;
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (!(object instanceof ResizableDoubleArray)) {
                return false;
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            Object object2 = object;
            synchronized (object2) {
                boolean bl = true;
                ResizableDoubleArray resizableDoubleArray2 = (ResizableDoubleArray)object;
                bl = bl && resizableDoubleArray2.d == this.d;
                bl = bl && resizableDoubleArray2.e == this.e;
                bl = bl && resizableDoubleArray2.a == this.a;
                bl = bl && resizableDoubleArray2.f == this.f;
                boolean bl2 = bl = bl && resizableDoubleArray2.j == this.j;
                if (!bl) {
                    return false;
                }
                return Arrays.equals(this.c, resizableDoubleArray2.c);
            }
        }
    }

    public synchronized int hashCode() {
        int[] nArray = new int[]{Double.valueOf(this.e).hashCode(), Double.valueOf(this.d).hashCode(), this.a.hashCode(), Arrays.hashCode(this.c), this.f, this.j};
        return Arrays.hashCode(nArray);
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String[] stringArray = new String[2];
        int n = 0;
        String string = "c\u0011=[#!lg\n4]3-\u0013o\u00005F>8vk\u00168F>>\u007f}\u00186V2";
        int n2 = "c\u0011=[#!lg\n4]3-\u0013o\u00005F>8vk\u00168F>>\u007f}\u00186V2".length();
        int n3 = 13;
        int n4 = -1;
        while (true) {
            char[] cArray;
            block14: {
                int n5;
                char[] cArray2;
                int n6;
                int n7;
                block13: {
                    int n8 = ++n4;
                    Object var6_6 = null;
                    char[] cArray3 = string.substring(n8, n8 + n3).toCharArray();
                    int n9 = cArray3.length;
                    n7 = 0;
                    n6 = 95;
                    cArray2 = cArray3;
                    n5 = n9;
                    if (n9 <= 1) break block13;
                    cArray = cArray2;
                    n5 = n5;
                    if (n5 <= n7) break block14;
                }
                do {
                    int n10 = n6;
                    cArray2 = cArray2;
                    char[] cArray4 = cArray2;
                    int n11 = n6;
                    int n12 = n7;
                    while (true) {
                        int n13;
                        switch (n7 % 7) {
                            case 0: {
                                n13 = 125;
                                break;
                            }
                            case 1: {
                                n13 = 10;
                                break;
                            }
                            case 2: {
                                n13 = 38;
                                break;
                            }
                            case 3: {
                                n13 = 77;
                                break;
                            }
                            case 4: {
                                n13 = 40;
                                break;
                            }
                            case 5: {
                                n13 = 55;
                                break;
                            }
                            default: {
                                n13 = 101;
                            }
                        }
                        cArray4[n12] = (char)(cArray4[n12] ^ (n11 ^ n13));
                        ++n7;
                        n6 = n10;
                        if (n10 != 0) break;
                        n10 = n6;
                        cArray2 = cArray2;
                        n12 = n6;
                        cArray4 = cArray2;
                        n11 = n6;
                    }
                    cArray = cArray2;
                    n5 = n5;
                } while (n5 > n7);
            }
            stringArray[n++] = new String(cArray).intern();
            if ((n4 += n3) >= n2) {
                l = stringArray;
                return;
            }
            n3 = string.charAt(n4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ExpansionMode
    extends Enum<ExpansionMode> {
        public static final /* enum */ ExpansionMode MULTIPLICATIVE;
        public static final /* enum */ ExpansionMode ADDITIVE;
        private static final /* synthetic */ ExpansionMode[] a;

        public static ExpansionMode[] values() {
            return (ExpansionMode[])a.clone();
        }

        public static ExpansionMode valueOf(String string) {
            return Enum.valueOf(ExpansionMode.class, string);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String[] stringArray = new String[2];
            int n = 0;
            String string = "cd{\u000f_c\u0017grv\u000f_e\u001e\bous\u0012Bz\rk";
            int n2 = "cd{\u000f_c\u0017grv\u000f_e\u001e\bous\u0012Bz\rk".length();
            int n3 = 14;
            int n4 = -1;
            while (true) {
                char[] cArray;
                block14: {
                    int n5;
                    char[] cArray2;
                    int n6;
                    int n7;
                    block13: {
                        int n8 = ++n4;
                        Object var7_6 = null;
                        char[] cArray3 = string.substring(n8, n8 + n3).toCharArray();
                        int n9 = cArray3.length;
                        n7 = 0;
                        n6 = 106;
                        cArray2 = cArray3;
                        n5 = n9;
                        if (n9 <= 1) break block13;
                        cArray = cArray2;
                        n5 = n5;
                        if (n5 <= n7) break block14;
                    }
                    do {
                        int n10 = n6;
                        cArray2 = cArray2;
                        char[] cArray4 = cArray2;
                        int n11 = n6;
                        int n12 = n7;
                        while (true) {
                            int n13;
                            switch (n7 % 7) {
                                case 0: {
                                    n13 = 68;
                                    break;
                                }
                                case 1: {
                                    n13 = 91;
                                    break;
                                }
                                case 2: {
                                    n13 = 93;
                                    break;
                                }
                                case 3: {
                                    n13 = 49;
                                    break;
                                }
                                case 4: {
                                    n13 = 124;
                                    break;
                                }
                                case 5: {
                                    n13 = 89;
                                    break;
                                }
                                default: {
                                    n13 = 49;
                                }
                            }
                            cArray4[n12] = (char)(cArray4[n12] ^ (n11 ^ n13));
                            ++n7;
                            n6 = n10;
                            if (n10 != 0) break;
                            n10 = n6;
                            cArray2 = cArray2;
                            n12 = n6;
                            cArray4 = cArray2;
                            n11 = n6;
                        }
                        cArray = cArray2;
                        n5 = n5;
                    } while (n5 > n7);
                }
                stringArray[n++] = new String(cArray).intern();
                if ((n4 += n3) >= n2) {
                    String[] stringArray2 = stringArray;
                    MULTIPLICATIVE = new ExpansionMode();
                    ADDITIVE = new ExpansionMode();
                    a = new ExpansionMode[]{MULTIPLICATIVE, ADDITIVE};
                    return;
                }
                n3 = string.charAt(n4);
            }
        }
    }
}

