/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.extremall.advancedkits.libs.boostedyaml.block.Block;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Comments {
    public static final CommentLine BLANK_LINE = new CommentLine(Optional.empty(), Optional.empty(), "", CommentType.BLANK_LINE);

    @Nullable
    public static List<CommentLine> get(@NotNull Block<?> block, @NotNull NodeType nodeType, @NotNull Position position) {
        switch (position) {
            case BEFORE: {
                if (nodeType == NodeType.KEY) {
                    return block.beforeKeyComments;
                }
                return block.beforeValueComments;
            }
            case INLINE: {
                if (nodeType == NodeType.KEY) {
                    return block.inlineKeyComments;
                }
                return block.inlineValueComments;
            }
            case AFTER: {
                if (nodeType == NodeType.KEY) {
                    return block.afterKeyComments;
                }
                return block.afterValueComments;
            }
        }
        return null;
    }

    public static void set(@NotNull Block<?> block, @NotNull NodeType nodeType, @NotNull Position position, @Nullable List<CommentLine> list) {
        if (list != null) {
            list = new ArrayList<CommentLine>(list);
        }
        switch (position) {
            case BEFORE: {
                if (nodeType == NodeType.KEY) {
                    block.beforeKeyComments = list;
                    return;
                }
                block.beforeValueComments = list;
                return;
            }
            case INLINE: {
                if (nodeType == NodeType.KEY) {
                    block.inlineKeyComments = list;
                    return;
                }
                block.inlineValueComments = list;
                return;
            }
            case AFTER: {
                if (nodeType == NodeType.KEY) {
                    block.afterKeyComments = list;
                    return;
                }
                block.afterValueComments = list;
            }
        }
    }

    public static void remove(@NotNull Block<?> block, @NotNull NodeType nodeType, @NotNull Position position) {
        Comments.set(block, nodeType, position, null);
    }

    public static void add(@NotNull Block<?> block, @NotNull NodeType nodeType, @NotNull Position position, @NotNull List<CommentLine> list) {
        list.forEach(commentLine -> Comments.add(block, nodeType, position, commentLine));
    }

    public static void add(@NotNull Block<?> block, @NotNull NodeType nodeType, @NotNull Position position, @NotNull CommentLine commentLine) {
        switch (position) {
            case BEFORE: {
                if (nodeType == NodeType.KEY) {
                    if (block.beforeKeyComments == null) {
                        block.beforeKeyComments = new ArrayList<CommentLine>();
                    }
                    block.beforeKeyComments.add(commentLine);
                    return;
                }
                if (block.beforeValueComments == null) {
                    block.beforeValueComments = new ArrayList<CommentLine>();
                }
                block.beforeValueComments.add(commentLine);
                return;
            }
            case INLINE: {
                if (nodeType == NodeType.KEY) {
                    if (block.inlineKeyComments == null) {
                        block.inlineKeyComments = new ArrayList<CommentLine>();
                    }
                    block.inlineKeyComments.add(commentLine);
                    return;
                }
                if (block.inlineValueComments == null) {
                    block.inlineValueComments = new ArrayList<CommentLine>();
                }
                block.inlineValueComments.add(commentLine);
                return;
            }
            case AFTER: {
                if (nodeType == NodeType.KEY) {
                    if (block.afterKeyComments == null) {
                        block.afterKeyComments = new ArrayList<CommentLine>();
                    }
                    block.afterKeyComments.add(commentLine);
                    return;
                }
                if (block.afterValueComments == null) {
                    block.afterValueComments = new ArrayList<CommentLine>();
                }
                block.afterValueComments.add(commentLine);
            }
        }
    }

    @NotNull
    public static CommentLine create(@NotNull String string, @NotNull Position position) {
        return new CommentLine(Optional.empty(), Optional.empty(), string, position == Position.INLINE ? CommentType.IN_LINE : CommentType.BLOCK);
    }

    public static enum NodeType {
        KEY,
        VALUE;

    }

    public static enum Position {
        BEFORE,
        INLINE,
        AFTER;

    }
}

