/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.dvs.segment;

import java.util.Arrays;
import me.extremall.advancedkits.libs.boostedyaml.dvs.segment.Segment;

public class RangeSegment
implements Segment {
    private final int start;
    private final int end;
    private final int step;
    private final int minStringLength;
    private final int maxStringLength;
    private final int fill;
    private final int length;

    public RangeSegment(int n2, int n3, int n4, int n5) {
        this.start = n2;
        this.end = n3;
        this.step = n4;
        this.fill = n5;
        if (n4 == 0) {
            throw new IllegalArgumentException("Step cannot be zero!");
        }
        if (n2 < n3 && n4 < 0 || n2 > n3 && n4 > 0) {
            throw new IllegalArgumentException(String.format("Invalid step for the given range! start=%d end=%d step=%d", n2, n3, n4));
        }
        if (n2 == n3) {
            throw new IllegalArgumentException(String.format("Parameters define an empty range, start=end! start=%d end=%d", n2, n3));
        }
        this.length = (int)Math.ceil((double)Math.abs(n2 - n3) / (double)Math.abs(n4));
        int n6 = n2 + n4 * (this.length - 1);
        if (n2 < 0 || n3 < 0 && n6 < 0) {
            throw new IllegalArgumentException(String.format("Range contains negative integers! start=%d end=%d step=%d", n2, n3, n4));
        }
        if (n5 > 0 && !this.validateFill(n5, Math.max(n2, n6))) {
            throw new IllegalArgumentException(String.format("Some integer from the range exceeds maximum length defined by the filling parameter! start=%d end=%d last=%d fill=%d", n2, n3, n6, n5));
        }
        int n7 = n5 > 0 ? n5 : (this.maxStringLength = this.countDigits(n4 > 0 ? n3 : n2));
        this.minStringLength = n5 > 0 ? n5 : this.countDigits(n4 > 0 ? n2 : n3);
    }

    @Deprecated
    public RangeSegment(int n2, int n3) {
        this(n2, n3, n2 < n3 ? 1 : -1, 0);
    }

    @Deprecated
    public RangeSegment(int n2, int n3, int n4) {
        this(n2, n3, n4, 0);
    }

    private boolean validateFill(int n2, int n3) {
        int n4 = 9;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (n4 >= n3) {
                return true;
            }
            n4 *= 10;
            n4 += 9;
        }
        return false;
    }

    @Override
    public int parse(String string, int n2) {
        int n3;
        int n4;
        if (this.fill > 0) {
            if (this.fill > string.length() - n2) {
                return -1;
            }
            try {
                return this.getRangeIndex(Integer.parseInt(string.substring(n2, this.fill)));
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        if (string.length() <= n2) {
            return -1;
        }
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < this.maxStringLength && n3 < string.length() - n2 && (n3 != 1 || n5 != 0 || n6 != 1) && (n4 = Character.digit(string.charAt(n2 + n3), 10)) != -1; n5 += n4, ++n6, ++n3) {
            n5 *= 10;
        }
        if (n6 == 0) {
            return -1;
        }
        if (n5 == 0) {
            return this.getRangeIndex(0);
        }
        while (n5 > 0 && n6 >= this.minStringLength) {
            n3 = this.getRangeIndex(n5);
            if (n3 != -1) {
                return n3;
            }
            n5 /= 10;
            --n6;
        }
        return -1;
    }

    private int countDigits(int n2) {
        if (n2 == 0) {
            return 1;
        }
        int n3 = 0;
        while (n2 > 0) {
            n2 /= 10;
            ++n3;
        }
        return n3;
    }

    private int getRangeIndex(int n2) {
        if (this.step > 0 ? this.start > n2 || this.end <= n2 : this.start < n2 || this.end >= n2) {
            return -1;
        }
        int n3 = Math.abs(n2 - this.start);
        if (n2 >= 0 && n3 % this.step == 0) {
            return n3 / Math.abs(this.step);
        }
        return -1;
    }

    @Override
    public String getElement(int n2) {
        if (n2 >= this.length) {
            throw new IndexOutOfBoundsException(String.format("Index out of bounds! i=%d length=%d", n2, this.length));
        }
        String string = Integer.toString(this.start + this.step * n2, 10);
        if (this.fill <= 0 || string.length() == this.fill) {
            return string;
        }
        char[] cArray = new char[this.fill - string.length()];
        Arrays.fill(cArray, '0');
        return new StringBuilder(string).insert(0, cArray).toString();
    }

    @Override
    public int getElementLength(int n2) {
        if (n2 >= this.length) {
            throw new IndexOutOfBoundsException(String.format("Index out of bounds! i=%d length=%d", n2, this.length));
        }
        if (this.fill > 0) {
            return this.fill;
        }
        RangeSegment rangeSegment = this;
        return rangeSegment.countDigits(rangeSegment.start + this.step * n2);
    }

    @Override
    public int length() {
        return this.length;
    }

    public String toString() {
        return "RangeSegment{start=" + this.start + ", end=" + this.end + ", step=" + this.step + ", fill=" + this.fill + ", length=" + this.length + '}';
    }
}

