/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.engine;

import java.util.HashMap;
import java.util.Map;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.constructor.StandardConstructor;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Node;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;
import me.extremall.advancedkits.libs.boostedyaml.serialization.YamlSerializer;
import org.jetbrains.annotations.NotNull;

public class ExtendedConstructor
extends StandardConstructor {
    private final YamlSerializer serializer;
    private final Map<Node, Object> constructed = new HashMap<Node, Object>();

    public ExtendedConstructor(@NotNull LoadSettings loadSettings, @NotNull YamlSerializer yamlSerializer) {
        super(loadSettings);
        this.serializer = yamlSerializer;
        ExtendedConstructor extendedConstructor = this;
        this.tagConstructors.put(Tag.MAP, extendedConstructor.new ConstructMap((StandardConstructor.ConstructYamlMap)extendedConstructor.tagConstructors.get(Tag.MAP)));
    }

    @Override
    public Object construct(Node node) {
        Object object = super.construct(node);
        this.constructed.put(node, object);
        return object;
    }

    @Override
    public Object constructObjectNoCheck(Node node) {
        Object object = super.constructObjectNoCheck(node);
        this.constructed.put(node, object);
        return object;
    }

    @NotNull
    public Object getConstructed(@NotNull Node node) {
        return this.constructed.get(node);
    }

    public void clear() {
        this.constructed.clear();
    }

    class ConstructMap
    extends StandardConstructor.ConstructYamlMap {
        private final StandardConstructor.ConstructYamlMap previous;

        private ConstructMap(StandardConstructor.ConstructYamlMap constructYamlMap) {
            super(ExtendedConstructor.this);
            this.previous = constructYamlMap;
        }

        @Override
        public Object construct(Node object) {
            object = (Map)this.previous.construct((Node)object);
            Object object2 = ExtendedConstructor.this.serializer.deserialize((Map<Object, Object>)object);
            if (object2 == null) {
                return object;
            }
            return object2;
        }
    }
}

