/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.engine;

import java.util.Map;
import me.extremall.advancedkits.libs.boostedyaml.YamlDocument;
import me.extremall.advancedkits.libs.boostedyaml.block.Block;
import me.extremall.advancedkits.libs.boostedyaml.block.Comments;
import me.extremall.advancedkits.libs.boostedyaml.block.implementation.Section;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.RepresentToNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Node;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.representer.StandardRepresenter;
import me.extremall.advancedkits.libs.boostedyaml.settings.general.GeneralSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedRepresenter
extends StandardRepresenter {
    private final GeneralSettings generalSettings;

    public ExtendedRepresenter(@NotNull GeneralSettings generalSettings, @NotNull DumpSettings iterator) {
        super((DumpSettings)((Object)iterator));
        this.generalSettings = generalSettings;
        iterator = new RepresentSection();
        RepresentSerializable representSerializable = new RepresentSerializable();
        this.representers.put(Section.class, iterator);
        this.representers.put(YamlDocument.class, iterator);
        this.representers.put(Enum.class, new RepresentEnum());
        for (Class<?> clazz : generalSettings.getSerializer().getSupportedClasses()) {
            this.representers.put(clazz, representSerializable);
        }
        for (Class<?> clazz : generalSettings.getSerializer().getSupportedParentClasses()) {
            this.parentClassRepresenters.put(clazz, representSerializable);
        }
    }

    @NotNull
    public Node applyKeyComments(@Nullable Block<?> block, @NotNull Node node) {
        if (block != null) {
            node.setBlockComments(Comments.get(block, Comments.NodeType.KEY, Comments.Position.BEFORE));
            node.setInLineComments(Comments.get(block, Comments.NodeType.KEY, Comments.Position.INLINE));
            node.setEndComments(Comments.get(block, Comments.NodeType.KEY, Comments.Position.AFTER));
        }
        return node;
    }

    @NotNull
    public Node applyValueComments(@Nullable Block<?> block, @NotNull Node node) {
        if (block != null) {
            node.setBlockComments(Comments.get(block, Comments.NodeType.VALUE, Comments.Position.BEFORE));
            node.setInLineComments(Comments.get(block, Comments.NodeType.VALUE, Comments.Position.INLINE));
            node.setEndComments(Comments.get(block, Comments.NodeType.VALUE, Comments.Position.AFTER));
        }
        return node;
    }

    @Override
    public NodeTuple representMappingEntry(Map.Entry<?, ?> object) {
        Block block = object.getValue() instanceof Block ? (Block)object.getValue() : null;
        Node node = this.applyKeyComments(block, this.representData(object.getKey()));
        object = this.applyValueComments(block, this.representData(block == null ? object.getValue() : block.getStoredValue()));
        return new NodeTuple(node, (Node)object);
    }

    class RepresentEnum
    implements RepresentToNode {
        private RepresentEnum() {
        }

        @Override
        public Node representData(Object object) {
            return ExtendedRepresenter.this.representData(((Enum)object).name());
        }
    }

    class RepresentSection
    implements RepresentToNode {
        private RepresentSection() {
        }

        @Override
        public Node representData(Object object) {
            object = (Section)object;
            return ExtendedRepresenter.this.applyKeyComments((Block<?>)object, ExtendedRepresenter.this.representData(((Block)object).getStoredValue()));
        }
    }

    class RepresentSerializable
    implements RepresentToNode {
        private RepresentSerializable() {
        }

        @Override
        public Node representData(Object map) {
            Map<Object, Object> map2 = ExtendedRepresenter.this.generalSettings.getSerializer().serialize(map, ExtendedRepresenter.this.generalSettings.getDefaultMapSupplier());
            return ExtendedRepresenter.this.representData(map2 == null ? map : map2);
        }
    }
}

