/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.ConstructNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.SettingKey;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.SpecVersion;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.env.EnvConfig;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.YamlVersionException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.resolver.JsonScalarResolver;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.resolver.ScalarResolver;

public final class LoadSettingsBuilder {
    private String label = "reader";
    private Map<Tag, ConstructNode> tagConstructors;
    private ScalarResolver scalarResolver;
    private IntFunction<List> defaultList;
    private IntFunction<Set> defaultSet;
    private IntFunction<Map> defaultMap;
    private UnaryOperator<SpecVersion> versionFunction;
    private Integer bufferSize = 1024;
    private boolean allowDuplicateKeys = false;
    private boolean allowRecursiveKeys = false;
    private boolean parseComments = false;
    private int maxAliasesForCollections = 50;
    private boolean useMarks = true;
    private Optional<EnvConfig> envConfig;
    private final Map<SettingKey, Object> customProperties = new HashMap<SettingKey, Object>();

    LoadSettingsBuilder() {
        this.tagConstructors = new HashMap<Tag, ConstructNode>();
        this.scalarResolver = new JsonScalarResolver();
        this.defaultList = ArrayList::new;
        this.defaultSet = LinkedHashSet::new;
        this.defaultMap = LinkedHashMap::new;
        this.versionFunction = specVersion -> {
            if (specVersion.getMajor() != 1) {
                throw new YamlVersionException((SpecVersion)specVersion);
            }
            return specVersion;
        };
        this.envConfig = Optional.empty();
    }

    public final LoadSettingsBuilder setLabel(String string) {
        Objects.requireNonNull(string, "label cannot be null");
        this.label = string;
        return this;
    }

    public final LoadSettingsBuilder setTagConstructors(Map<Tag, ConstructNode> map) {
        this.tagConstructors = map;
        return this;
    }

    public final LoadSettingsBuilder setScalarResolver(ScalarResolver scalarResolver) {
        Objects.requireNonNull(scalarResolver, "scalarResolver cannot be null");
        this.scalarResolver = scalarResolver;
        return this;
    }

    public final LoadSettingsBuilder setDefaultList(IntFunction<List> intFunction) {
        Objects.requireNonNull(intFunction, "defaultList cannot be null");
        this.defaultList = intFunction;
        return this;
    }

    public final LoadSettingsBuilder setDefaultSet(IntFunction<Set> intFunction) {
        Objects.requireNonNull(intFunction, "defaultSet cannot be null");
        this.defaultSet = intFunction;
        return this;
    }

    public final LoadSettingsBuilder setDefaultMap(IntFunction<Map> intFunction) {
        Objects.requireNonNull(intFunction, "defaultMap cannot be null");
        this.defaultMap = intFunction;
        return this;
    }

    public final LoadSettingsBuilder setBufferSize(Integer n2) {
        this.bufferSize = n2;
        return this;
    }

    public final LoadSettingsBuilder setAllowDuplicateKeys(boolean bl2) {
        this.allowDuplicateKeys = bl2;
        return this;
    }

    public final LoadSettingsBuilder setAllowRecursiveKeys(boolean bl2) {
        this.allowRecursiveKeys = bl2;
        return this;
    }

    public final LoadSettingsBuilder setMaxAliasesForCollections(int n2) {
        this.maxAliasesForCollections = n2;
        return this;
    }

    public final LoadSettingsBuilder setUseMarks(boolean bl2) {
        this.useMarks = bl2;
        return this;
    }

    public final LoadSettingsBuilder setVersionFunction(UnaryOperator<SpecVersion> unaryOperator) {
        Objects.requireNonNull(unaryOperator, "versionFunction cannot be null");
        this.versionFunction = unaryOperator;
        return this;
    }

    public final LoadSettingsBuilder setEnvConfig(Optional<EnvConfig> optional) {
        this.envConfig = optional;
        return this;
    }

    public final LoadSettingsBuilder setCustomProperty(SettingKey settingKey, Object object) {
        this.customProperties.put(settingKey, object);
        return this;
    }

    public final LoadSettingsBuilder setParseComments(boolean bl2) {
        this.parseComments = bl2;
        return this;
    }

    public final LoadSettings build() {
        return new LoadSettings(this.label, this.tagConstructors, this.scalarResolver, this.defaultList, this.defaultSet, this.defaultMap, this.versionFunction, this.bufferSize, this.allowDuplicateKeys, this.allowRecursiveKeys, this.maxAliasesForCollections, this.useMarks, this.customProperties, this.envConfig, this.parseComments);
    }
}

