/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.EmitterException;

public class Anchor {
    private static final Set<Character> INVALID_ANCHOR = new HashSet<Character>();
    private static final Pattern SPACES_PATTERN = Pattern.compile("\\s");
    private final String value;

    public Anchor(String string) {
        Objects.requireNonNull(string);
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Empty anchor.");
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!INVALID_ANCHOR.contains(Character.valueOf(c2))) continue;
            throw new EmitterException("Invalid character '" + c2 + "' in the anchor: " + string);
        }
        Matcher matcher = SPACES_PATTERN.matcher(string);
        if (matcher.find()) {
            throw new EmitterException("Anchor may not contain spaces: " + string);
        }
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (Anchor)object;
        return Objects.equals(this.value, ((Anchor)object).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    static {
        INVALID_ANCHOR.add(Character.valueOf('['));
        INVALID_ANCHOR.add(Character.valueOf(']'));
        INVALID_ANCHOR.add(Character.valueOf('{'));
        INVALID_ANCHOR.add(Character.valueOf('}'));
        INVALID_ANCHOR.add(Character.valueOf(','));
        INVALID_ANCHOR.add(Character.valueOf('*'));
        INVALID_ANCHOR.add(Character.valueOf('&'));
    }
}

