/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.external.com.google.gdata.util.common.base.Escaper;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.external.com.google.gdata.util.common.base.PercentEscaper;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;

public abstract class UriEncoder {
    private static final CharsetDecoder UTF8Decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT);
    private static final String SAFE_CHARS = "-_.!~*'()@:$&,;=[]/";
    private static final Escaper escaper = new PercentEscaper("-_.!~*'()@:$&,;=[]/", false);

    private UriEncoder() {
    }

    public static String encode(String string) {
        return escaper.escape(string);
    }

    public static String decode(ByteBuffer buffer) {
        buffer = UTF8Decoder.decode((ByteBuffer)buffer);
        return ((CharBuffer)buffer).toString();
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new YamlEngineException(unsupportedEncodingException);
        }
    }
}

