/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.emitter;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.TreeSet;
import java.util.regex.Pattern;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.StreamDataWriter;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentEventsCollector;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentType;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.Anchor;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.ArrayStack;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.CharConstants;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.SpecVersion;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.emitter.Emitable;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.emitter.EmitterState;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.emitter.ScalarAnalysis;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.AliasEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.CollectionEndEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.CollectionStartEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.CommentEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.DocumentEndEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.DocumentStartEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.Event;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.MappingStartEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.NodeEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.ScalarEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.SequenceStartEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.StreamEndEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.StreamStartEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.EmitterException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.scanner.StreamReader;

public final class Emitter
implements Emitable {
    private static final Map<Character, String> ESCAPE_REPLACEMENTS = new HashMap<Character, String>();
    public static final int MIN_INDENT = 1;
    public static final int MAX_INDENT = 10;
    private static final String SPACE = " ";
    private static final Map<String, String> DEFAULT_TAG_PREFIXES;
    private final StreamDataWriter stream;
    private final ArrayStack<EmitterState> states;
    private EmitterState state;
    private final Queue<Event> events;
    private Event event;
    private final ArrayStack<Integer> indents;
    private Integer indent;
    private int flowLevel;
    private boolean rootContext;
    private boolean mappingContext;
    private boolean simpleKeyContext;
    private int column;
    private boolean whitespace;
    private boolean indention;
    private boolean openEnded;
    private final Boolean canonical;
    private final Boolean multiLineFlow;
    private final boolean allowUnicode;
    private int bestIndent;
    private final int indicatorIndent;
    private final boolean indentWithIndicator;
    private int bestWidth;
    private final String bestLineBreak;
    private final boolean splitLines;
    private final int maxSimpleKeyLength;
    private final boolean emitComments;
    private Map<String, String> tagPrefixes;
    private Optional<Anchor> preparedAnchor;
    private String preparedTag;
    private ScalarAnalysis analysis;
    private Optional<ScalarStyle> scalarStyle;
    private final CommentEventsCollector blockCommentsCollector;
    private final CommentEventsCollector inlineCommentsCollector;
    private static final Pattern HANDLE_FORMAT;

    public Emitter(DumpSettings dumpSettings, StreamDataWriter streamDataWriter) {
        this.stream = streamDataWriter;
        this.states = new ArrayStack(100);
        this.state = new ExpectStreamStart();
        this.events = new ArrayDeque<Event>(100);
        this.event = null;
        this.indents = new ArrayStack(10);
        this.indent = null;
        this.flowLevel = 0;
        this.mappingContext = false;
        this.simpleKeyContext = false;
        this.column = 0;
        this.whitespace = true;
        this.indention = true;
        this.openEnded = false;
        this.canonical = dumpSettings.isCanonical();
        this.multiLineFlow = dumpSettings.isMultiLineFlow();
        this.allowUnicode = dumpSettings.isUseUnicodeEncoding();
        this.bestIndent = 2;
        if (dumpSettings.getIndent() > 1 && dumpSettings.getIndent() < 10) {
            this.bestIndent = dumpSettings.getIndent();
        }
        this.indicatorIndent = dumpSettings.getIndicatorIndent();
        this.indentWithIndicator = dumpSettings.getIndentWithIndicator();
        this.bestWidth = 80;
        if (dumpSettings.getWidth() > this.bestIndent << 1) {
            this.bestWidth = dumpSettings.getWidth();
        }
        this.bestLineBreak = dumpSettings.getBestLineBreak();
        this.splitLines = dumpSettings.isSplitLines();
        this.maxSimpleKeyLength = dumpSettings.getMaxSimpleKeyLength();
        this.emitComments = dumpSettings.getDumpComments();
        this.tagPrefixes = new LinkedHashMap<String, String>();
        this.preparedAnchor = Optional.empty();
        this.preparedTag = null;
        this.analysis = null;
        this.scalarStyle = Optional.empty();
        this.blockCommentsCollector = new CommentEventsCollector(this.events, CommentType.BLANK_LINE, CommentType.BLOCK);
        this.inlineCommentsCollector = new CommentEventsCollector(this.events, CommentType.IN_LINE);
    }

    @Override
    public final void emit(Event event) {
        this.events.add(event);
        while (!this.needMoreEvents()) {
            this.event = this.events.poll();
            this.state.expect();
            this.event = null;
        }
    }

    private boolean needMoreEvents() {
        if (this.events.isEmpty()) {
            return true;
        }
        Iterator<Event> iterator = this.events.iterator();
        Event event = (Event)iterator.next();
        while (event instanceof CommentEvent) {
            if (!iterator.hasNext()) {
                return true;
            }
            event = (Event)iterator.next();
        }
        if (event instanceof DocumentStartEvent) {
            return this.needEvents(iterator, 1);
        }
        if (event instanceof SequenceStartEvent) {
            return this.needEvents(iterator, 2);
        }
        if (event instanceof MappingStartEvent) {
            return this.needEvents(iterator, 3);
        }
        if (event instanceof StreamStartEvent) {
            return this.needEvents(iterator, 2);
        }
        if (event instanceof StreamEndEvent) {
            return false;
        }
        if (this.emitComments) {
            return this.needEvents(iterator, 1);
        }
        return false;
    }

    private boolean needEvents(Iterator<Event> iterator, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (iterator.hasNext()) {
            Event event = iterator.next();
            if (event instanceof CommentEvent) continue;
            ++n4;
            if (event instanceof DocumentStartEvent || event instanceof CollectionStartEvent) {
                ++n3;
            } else if (event instanceof DocumentEndEvent || event instanceof CollectionEndEvent) {
                --n3;
            } else if (event instanceof StreamEndEvent) {
                n3 = -1;
            }
            if (n3 >= 0) continue;
            return false;
        }
        return n4 < n2;
    }

    private void increaseIndent(boolean bl2, boolean bl3) {
        this.indents.push(this.indent);
        if (this.indent == null) {
            if (bl2) {
                this.indent = this.bestIndent;
                return;
            }
            this.indent = 0;
            return;
        }
        if (!bl3) {
            Emitter emitter = this;
            this.indent = emitter.indent + this.bestIndent;
        }
    }

    private void expectNode(boolean bl2, boolean bl3, boolean bl4) {
        this.rootContext = bl2;
        this.mappingContext = bl3;
        this.simpleKeyContext = bl4;
        if (this.event.getEventId() == Event.ID.Alias) {
            this.expectAlias();
            return;
        }
        if (this.event.getEventId() == Event.ID.Scalar || this.event.getEventId() == Event.ID.SequenceStart || this.event.getEventId() == Event.ID.MappingStart) {
            this.processAnchor("&");
            this.processTag();
            Emitter emitter = this;
            emitter.handleNodeEvent(emitter.event.getEventId());
            return;
        }
        throw new EmitterException("expected NodeEvent, but got " + (Object)((Object)this.event.getEventId()));
    }

    private void handleNodeEvent(Event.ID iD) {
        switch (iD) {
            case Scalar: {
                this.expectScalar();
                return;
            }
            case SequenceStart: {
                if (this.flowLevel != 0 || this.canonical.booleanValue() || ((SequenceStartEvent)this.event).isFlow() || this.checkEmptySequence()) {
                    this.expectFlowSequence();
                    return;
                }
                this.expectBlockSequence();
                return;
            }
            case MappingStart: {
                if (this.flowLevel != 0 || this.canonical.booleanValue() || ((MappingStartEvent)this.event).isFlow() || this.checkEmptyMapping()) {
                    this.expectFlowMapping();
                    return;
                }
                this.expectBlockMapping();
                return;
            }
        }
        throw new IllegalStateException();
    }

    private void expectAlias() {
        if (this.event instanceof AliasEvent) {
            this.processAnchor("*");
            this.state = this.states.pop();
            return;
        }
        throw new EmitterException("Expecting Alias.");
    }

    private void expectScalar() {
        this.increaseIndent(true, false);
        this.processScalar();
        this.indent = this.indents.pop();
        this.state = this.states.pop();
    }

    private void expectFlowSequence() {
        this.writeIndicator("[", true, true, false);
        ++this.flowLevel;
        this.increaseIndent(true, false);
        if (this.multiLineFlow.booleanValue()) {
            this.writeIndent();
        }
        this.state = new ExpectFirstFlowSequenceItem();
    }

    private void expectFlowMapping() {
        this.writeIndicator("{", true, true, false);
        ++this.flowLevel;
        this.increaseIndent(true, false);
        if (this.multiLineFlow.booleanValue()) {
            this.writeIndent();
        }
        this.state = new ExpectFirstFlowMappingKey();
    }

    private void expectBlockSequence() {
        boolean bl2 = this.mappingContext && !this.indention;
        this.increaseIndent(false, bl2);
        this.state = new ExpectFirstBlockSequenceItem();
    }

    private void expectBlockMapping() {
        this.increaseIndent(false, false);
        this.state = new ExpectFirstBlockMappingKey();
    }

    private boolean isFoldedOrLiteral(Event object) {
        if (object.getEventId() != Event.ID.Scalar) {
            return false;
        }
        object = (ScalarEvent)object;
        return (object = ((ScalarEvent)object).getScalarStyle()) == ScalarStyle.FOLDED || object == ScalarStyle.LITERAL;
    }

    private boolean checkEmptySequence() {
        return this.event.getEventId() == Event.ID.SequenceStart && !this.events.isEmpty() && this.events.peek().getEventId() == Event.ID.SequenceEnd;
    }

    private boolean checkEmptyMapping() {
        return this.event.getEventId() == Event.ID.MappingStart && !this.events.isEmpty() && this.events.peek().getEventId() == Event.ID.MappingEnd;
    }

    private boolean checkSimpleKey() {
        Optional<Object> optional;
        int n2 = 0;
        if (this.event instanceof NodeEvent && (optional = ((NodeEvent)this.event).getAnchor()).isPresent()) {
            if (!this.preparedAnchor.isPresent()) {
                this.preparedAnchor = optional;
            }
            n2 = 0 + ((Anchor)optional.get()).getValue().length();
        }
        optional = Optional.empty();
        if (this.event.getEventId() == Event.ID.Scalar) {
            optional = ((ScalarEvent)this.event).getTag();
        } else if (this.event instanceof CollectionStartEvent) {
            optional = ((CollectionStartEvent)this.event).getTag();
        }
        if (optional.isPresent()) {
            if (this.preparedTag == null) {
                this.preparedTag = this.prepareTag((String)optional.get());
            }
            n2 += this.preparedTag.length();
        }
        if (this.event.getEventId() == Event.ID.Scalar) {
            if (this.analysis == null) {
                this.analysis = this.analyzeScalar(((ScalarEvent)this.event).getValue());
            }
            n2 += this.analysis.getScalar().length();
        }
        return n2 < this.maxSimpleKeyLength && (this.event.getEventId() == Event.ID.Alias || this.event.getEventId() == Event.ID.Scalar && !this.analysis.isEmpty() && !this.analysis.isMultiline() || this.checkEmptySequence() || this.checkEmptyMapping());
    }

    private void processAnchor(String string) {
        Object object = (NodeEvent)this.event;
        if (((Optional)(object = ((NodeEvent)object).getAnchor())).isPresent()) {
            Anchor anchor = (Anchor)((Optional)object).get();
            if (!this.preparedAnchor.isPresent()) {
                this.preparedAnchor = object;
            }
            this.writeIndicator(string + anchor, true, false, false);
        }
        this.preparedAnchor = Optional.empty();
    }

    private void processTag() {
        Optional<String> optional;
        if (this.event.getEventId() == Event.ID.Scalar) {
            ScalarEvent scalarEvent = (ScalarEvent)this.event;
            optional = scalarEvent.getTag();
            if (!this.scalarStyle.isPresent()) {
                this.scalarStyle = this.chooseScalarStyle(scalarEvent);
            }
            if ((!this.canonical.booleanValue() || !optional.isPresent()) && (!this.scalarStyle.isPresent() && scalarEvent.getImplicit().canOmitTagInPlainScalar() || this.scalarStyle.isPresent() && scalarEvent.getImplicit().canOmitTagInNonPlainScalar())) {
                this.preparedTag = null;
                return;
            }
            if (scalarEvent.getImplicit().canOmitTagInPlainScalar() && !optional.isPresent()) {
                optional = Optional.of("!");
                this.preparedTag = null;
            }
        } else {
            CollectionStartEvent collectionStartEvent = (CollectionStartEvent)this.event;
            optional = collectionStartEvent.getTag();
            if (!(this.canonical.booleanValue() && optional.isPresent() || !collectionStartEvent.isImplicit())) {
                this.preparedTag = null;
                return;
            }
        }
        if (!optional.isPresent()) {
            throw new EmitterException("tag is not specified");
        }
        if (this.preparedTag == null) {
            this.preparedTag = this.prepareTag(optional.get());
        }
        Emitter emitter = this;
        emitter.writeIndicator(emitter.preparedTag, true, false, false);
        this.preparedTag = null;
    }

    private Optional<ScalarStyle> chooseScalarStyle(ScalarEvent scalarEvent) {
        if (this.analysis == null) {
            this.analysis = this.analyzeScalar(scalarEvent.getValue());
        }
        if (!scalarEvent.isPlain() && scalarEvent.getScalarStyle() == ScalarStyle.DOUBLE_QUOTED || this.canonical.booleanValue()) {
            return Optional.of(ScalarStyle.DOUBLE_QUOTED);
        }
        if (scalarEvent.isPlain() && scalarEvent.getImplicit().canOmitTagInPlainScalar() && (!this.simpleKeyContext || !this.analysis.isEmpty() && !this.analysis.isMultiline()) && (this.flowLevel != 0 && this.analysis.isAllowFlowPlain() || this.flowLevel == 0 && this.analysis.isAllowBlockPlain())) {
            return Optional.empty();
        }
        if (!(scalarEvent.isPlain() || scalarEvent.getScalarStyle() != ScalarStyle.LITERAL && scalarEvent.getScalarStyle() != ScalarStyle.FOLDED || this.flowLevel != 0 || this.simpleKeyContext || !this.analysis.isAllowBlock())) {
            return Optional.of(scalarEvent.getScalarStyle());
        }
        if (!(!scalarEvent.isPlain() && scalarEvent.getScalarStyle() != ScalarStyle.SINGLE_QUOTED || !this.analysis.isAllowSingleQuoted() || this.simpleKeyContext && this.analysis.isMultiline())) {
            return Optional.of(ScalarStyle.SINGLE_QUOTED);
        }
        return Optional.of(ScalarStyle.DOUBLE_QUOTED);
    }

    private void processScalar() {
        boolean bl2;
        ScalarEvent scalarEvent = (ScalarEvent)this.event;
        if (this.analysis == null) {
            this.analysis = this.analyzeScalar(scalarEvent.getValue());
        }
        if (!this.scalarStyle.isPresent()) {
            this.scalarStyle = this.chooseScalarStyle(scalarEvent);
        }
        boolean bl3 = bl2 = !this.simpleKeyContext && this.splitLines;
        if (!this.scalarStyle.isPresent()) {
            Emitter emitter = this;
            emitter.writePlain(emitter.analysis.getScalar(), bl2);
        } else {
            switch (this.scalarStyle.get()) {
                case DOUBLE_QUOTED: {
                    Emitter emitter = this;
                    emitter.writeDoubleQuoted(emitter.analysis.getScalar(), bl2);
                    break;
                }
                case SINGLE_QUOTED: {
                    Emitter emitter = this;
                    emitter.writeSingleQuoted(emitter.analysis.getScalar(), bl2);
                    break;
                }
                case FOLDED: {
                    Emitter emitter = this;
                    emitter.writeFolded(emitter.analysis.getScalar(), bl2);
                    break;
                }
                case LITERAL: {
                    Emitter emitter = this;
                    emitter.writeLiteral(emitter.analysis.getScalar());
                    break;
                }
                default: {
                    throw new YamlEngineException("Unexpected scalarStyle: " + this.scalarStyle);
                }
            }
        }
        this.analysis = null;
        this.scalarStyle = Optional.empty();
    }

    private String prepareVersion(SpecVersion specVersion) {
        if (specVersion.getMajor() != 1) {
            throw new EmitterException("unsupported YAML version: " + specVersion);
        }
        return specVersion.getRepresentation();
    }

    private String prepareTagHandle(String string) {
        block6: {
            block5: {
                if (string.length() == 0) {
                    throw new EmitterException("tag handle must not be empty");
                }
                if (string.charAt(0) != '!') break block5;
                String string2 = string;
                if (string2.charAt(string2.length() - 1) == '!') break block6;
            }
            throw new EmitterException("tag handle must start and end with '!': " + string);
        }
        if (!"!".equals(string) && !HANDLE_FORMAT.matcher(string).matches()) {
            throw new EmitterException("invalid character in the tag handle: " + string);
        }
        return string;
    }

    private String prepareTagPrefix(String string) {
        if (string.length() == 0) {
            throw new EmitterException("tag prefix must not be empty");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        if (string.charAt(0) == '!') {
            n2 = 1;
        }
        while (n2 < string.length()) {
            ++n2;
        }
        if (n2 > 0) {
            stringBuilder.append(string, 0, n2);
        }
        return stringBuilder.toString();
    }

    private String prepareTag(String string) {
        int n2;
        String string22;
        if (string.length() == 0) {
            throw new EmitterException("tag must not be empty");
        }
        if ("!".equals(string)) {
            return string;
        }
        String string3 = null;
        String string4 = string;
        for (String string22 : this.tagPrefixes.keySet()) {
            if (!string.startsWith(string22) || !"!".equals(string22) && string22.length() >= string.length()) continue;
            string3 = string22;
        }
        if (string3 != null) {
            string4 = string.substring(string3.length());
            string3 = this.tagPrefixes.get(string3);
        }
        String string5 = string22 = (n2 = string4.length()) > 0 ? string4.substring(0, n2) : "";
        if (string3 != null) {
            return string3 + string22;
        }
        return "!<" + string22 + ">";
    }

    private ScalarAnalysis analyzeScalar(String string) {
        int n2;
        int n3;
        int n4;
        if (string.length() == 0) {
            return new ScalarAnalysis(string, true, false, false, true, true, false);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        if (string.startsWith("---") || string.startsWith("...")) {
            bl2 = true;
            bl3 = true;
        }
        int n5 = 1;
        boolean bl12 = string.length() == 1 || CharConstants.NULL_BL_T_LINEBR.has(string.codePointAt(1));
        boolean bl13 = false;
        boolean bl14 = false;
        int n6 = 0;
        while (n6 < string.length()) {
            n4 = string.codePointAt(n6);
            if (n6 == 0) {
                if ("#,[]{}&*!|>'\"%@`".indexOf(n4) != -1) {
                    bl3 = true;
                    bl2 = true;
                }
                if (n4 == 63 || n4 == 58) {
                    bl3 = true;
                    if (bl12) {
                        bl2 = true;
                    }
                }
                if (n4 == 45 && bl12) {
                    bl3 = true;
                    bl2 = true;
                }
            } else {
                if (",?[]{}".indexOf(n4) != -1) {
                    bl3 = true;
                }
                if (n4 == 58) {
                    bl3 = true;
                    if (bl12) {
                        bl2 = true;
                    }
                }
                if (n4 == 35 && n5 != 0) {
                    bl3 = true;
                    bl2 = true;
                }
            }
            boolean bl15 = CharConstants.LINEBR.has(n4);
            n3 = bl15 ? 1 : 0;
            if (bl15) {
                bl4 = true;
            }
            if (!(n4 == 10 || 32 <= n4 && n4 <= 126 || (n4 == 133 || n4 >= 160 && n4 <= 55295 || n4 >= 57344 && n4 <= 65533 || n4 >= 65536 && n4 <= 0x10FFFF) && this.allowUnicode)) {
                bl5 = true;
            }
            if (n4 == 32) {
                if (n6 == 0) {
                    bl6 = true;
                }
                if (n6 == string.length() - 1) {
                    bl8 = true;
                }
                if (bl14) {
                    bl10 = true;
                }
                bl13 = true;
                bl14 = false;
            } else if (n3 != 0) {
                if (n6 == 0) {
                    bl7 = true;
                }
                if (n6 == string.length() - 1) {
                    bl9 = true;
                }
                if (bl13) {
                    bl11 = true;
                }
                bl13 = false;
                bl14 = true;
            } else {
                bl13 = false;
                bl14 = false;
            }
            n5 = CharConstants.NULL_BL_T.has(n4) || n3 != 0 ? 1 : 0;
            bl12 = true;
            if ((n6 += Character.charCount(n4)) + 1 >= string.length() || (n2 = n6 + Character.charCount(string.codePointAt(n6))) >= string.length()) continue;
            bl12 = CharConstants.NULL_BL_T.has(string.codePointAt(n2)) || n3 != 0;
        }
        n4 = 1;
        n3 = 1;
        n2 = 1;
        n5 = 1;
        if (bl6 || bl7 || bl8 || bl9) {
            n3 = 0;
            n4 = 0;
        }
        if (bl8) {
            n5 = 0;
        }
        if (bl10) {
            n2 = 0;
            n3 = 0;
            n4 = 0;
        }
        if (bl11 || bl5) {
            n5 = 0;
            n2 = 0;
            n3 = 0;
            n4 = 0;
        }
        if (bl4) {
            n4 = 0;
        }
        if (bl3) {
            n4 = 0;
        }
        if (bl2) {
            n3 = 0;
        }
        return new ScalarAnalysis(string, false, bl4, n4 != 0, n3 != 0, n2 != 0, n5 != 0);
    }

    final void flushStream() {
        this.stream.flush();
    }

    final void writeStreamStart() {
    }

    final void writeStreamEnd() {
        this.flushStream();
    }

    final void writeIndicator(String string, boolean bl2, boolean bl3, boolean bl4) {
        if (!this.whitespace && bl2) {
            ++this.column;
            this.stream.write(SPACE);
        }
        this.whitespace = bl3;
        this.indention = this.indention && bl4;
        this.column += string.length();
        this.openEnded = false;
        this.stream.write(string);
    }

    final void writeIndent() {
        int n2 = this.indent != null ? this.indent : 0;
        if (!this.indention || this.column > n2 || this.column == n2 && !this.whitespace) {
            this.writeLineBreak(null);
        }
        this.writeWhitespace(n2 - this.column);
    }

    private void writeWhitespace(int n2) {
        if (n2 <= 0) {
            return;
        }
        this.whitespace = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.stream.write(SPACE);
        }
        this.column += n2;
    }

    private void writeLineBreak(String string) {
        this.whitespace = true;
        this.indention = true;
        this.column = 0;
        if (string == null) {
            this.stream.write(this.bestLineBreak);
            return;
        }
        this.stream.write(string);
    }

    final void writeVersionDirective(String string) {
        this.stream.write("%YAML ");
        this.stream.write(string);
        this.writeLineBreak(null);
    }

    final void writeTagDirective(String string, String string2) {
        this.stream.write("%TAG ");
        this.stream.write(string);
        this.stream.write(SPACE);
        this.stream.write(string2);
        this.writeLineBreak(null);
    }

    private void writeSingleQuoted(String string, boolean bl2) {
        this.writeIndicator("'", true, false, false);
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            int n3;
            char c2 = '\u0000';
            if (i2 < string.length()) {
                c2 = string.charAt(i2);
            }
            if (bl3) {
                if (c2 == '\u0000' || c2 != ' ') {
                    if (n2 + 1 == i2 && this.column > this.bestWidth && bl2 && n2 != 0 && i2 != string.length()) {
                        this.writeIndent();
                    } else {
                        n3 = i2 - n2;
                        this.column += n3;
                        this.stream.write(string, n2, n3);
                    }
                    n2 = i2;
                }
            } else if (bl4) {
                if (c2 == '\u0000' || CharConstants.LINEBR.hasNo(c2)) {
                    if (string.charAt(n2) == '\n') {
                        this.writeLineBreak(null);
                    }
                    String string2 = string.substring(n2, i2);
                    for (char c3 : string2.toCharArray()) {
                        if (c3 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c3));
                    }
                    this.writeIndent();
                    n2 = i2;
                }
            } else if (CharConstants.LINEBR.has(c2, "\u0000 '") && n2 < i2) {
                n3 = i2 - n2;
                this.column += n3;
                this.stream.write(string, n2, n3);
                n2 = i2;
            }
            if (c2 == '\'') {
                this.column += 2;
                this.stream.write("''");
                n2 = i2 + 1;
            }
            if (c2 == '\u0000') continue;
            bl3 = c2 == ' ';
            bl4 = CharConstants.LINEBR.has(c2);
        }
        this.writeIndicator("'", false, false, false);
    }

    private void writeDoubleQuoted(String string, boolean bl2) {
        this.writeIndicator("\"", true, false, false);
        int n2 = 0;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            Character c2 = null;
            if (i2 < string.length()) {
                c2 = Character.valueOf(string.charAt(i2));
            }
            if (c2 == null || "\"\\\u0085\u2028\u2029\ufeff".indexOf(c2.charValue()) != -1 || ' ' > c2.charValue() || c2.charValue() > '~') {
                if (n2 < i2) {
                    int n3 = i2 - n2;
                    this.column += n3;
                    this.stream.write(string, n2, n3);
                    n2 = i2;
                }
                if (c2 != null) {
                    String string2;
                    if (ESCAPE_REPLACEMENTS.containsKey(c2)) {
                        string2 = "\\" + ESCAPE_REPLACEMENTS.get(c2);
                    } else if (!this.allowUnicode || !StreamReader.isPrintable(c2.charValue())) {
                        if (c2.charValue() <= '\u00ff') {
                            String string3;
                            String string4 = string3 = "0" + Integer.toString(c2.charValue(), 16);
                            string2 = "\\x" + string4.substring(string4.length() - 2);
                        } else if (c2.charValue() >= '\ud800' && c2.charValue() <= '\udbff') {
                            if (i2 + 1 < string.length()) {
                                Object object = Character.valueOf(string.charAt(++i2));
                                Object object2 = object = "000" + Long.toHexString(Character.toCodePoint(c2.charValue(), ((Character)object).charValue()));
                                string2 = "\\U" + ((String)object2).substring(((String)object2).length() - 8);
                            } else {
                                String string5;
                                String string6 = string5 = "000" + Integer.toString(c2.charValue(), 16);
                                string2 = "\\u" + string6.substring(string6.length() - 4);
                            }
                        } else {
                            String string7;
                            String string8 = string7 = "000" + Integer.toString(c2.charValue(), 16);
                            string2 = "\\u" + string8.substring(string8.length() - 4);
                        }
                    } else {
                        string2 = String.valueOf(c2);
                    }
                    this.column += string2.length();
                    this.stream.write(string2);
                    n2 = i2 + 1;
                }
            }
            if (i2 <= 0 || i2 >= string.length() - 1 || c2.charValue() != ' ' && n2 < i2 || this.column + (i2 - n2) <= this.bestWidth || !bl2) continue;
            String string9 = n2 >= i2 ? "\\" : string.substring(n2, i2) + "\\";
            if (n2 < i2) {
                n2 = i2;
            }
            this.column += string9.length();
            this.stream.write(string9);
            this.writeIndent();
            this.whitespace = false;
            this.indention = false;
            if (string.charAt(n2) != ' ') continue;
            string9 = "\\";
            this.column += string9.length();
            this.stream.write(string9);
        }
        this.writeIndicator("\"", false, false, false);
    }

    private boolean writeCommentLines(List<CommentLine> object) {
        boolean bl2 = false;
        if (this.emitComments) {
            int n2 = 0;
            boolean bl3 = true;
            object = object.iterator();
            while (object.hasNext()) {
                CommentLine commentLine = (CommentLine)object.next();
                if (commentLine.getCommentType() != CommentType.BLANK_LINE) {
                    if (bl3) {
                        bl3 = false;
                        this.writeIndicator("#", commentLine.getCommentType() == CommentType.IN_LINE, false, false);
                        n2 = this.column > 0 ? this.column - 1 : 0;
                    } else {
                        this.writeWhitespace(n2);
                        this.writeIndicator("#", false, false, false);
                    }
                    this.stream.write(commentLine.getValue());
                    this.writeLineBreak(null);
                } else {
                    this.writeLineBreak(null);
                    this.writeIndent();
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    private void writeBlockComment() {
        if (!this.blockCommentsCollector.isEmpty()) {
            this.writeIndent();
            Emitter emitter = this;
            emitter.writeCommentLines(emitter.blockCommentsCollector.consume());
        }
    }

    private boolean writeInlineComments() {
        Emitter emitter = this;
        return emitter.writeCommentLines(emitter.inlineCommentsCollector.consume());
    }

    private String determineBlockHints(String string) {
        StringBuilder stringBuilder;
        block5: {
            block6: {
                block4: {
                    stringBuilder = new StringBuilder();
                    if (CharConstants.LINEBR.has(string.charAt(0), SPACE)) {
                        stringBuilder.append(this.bestIndent);
                    }
                    String string2 = string;
                    char c2 = string2.charAt(string2.length() - 1);
                    if (!CharConstants.LINEBR.hasNo(c2)) break block4;
                    stringBuilder.append("-");
                    break block5;
                }
                if (string.length() == 1) break block6;
                String string3 = string;
                if (!CharConstants.LINEBR.has(string3.charAt(string3.length() - 2))) break block5;
            }
            stringBuilder.append("+");
        }
        return stringBuilder.toString();
    }

    final void writeFolded(String string, boolean bl2) {
        String string2 = this.determineBlockHints(string);
        this.writeIndicator(">" + string2, true, false, false);
        if (string2.length() > 0) {
            String string3 = string2;
            if (string3.charAt(string3.length() - 1) == '+') {
                this.openEnded = true;
            }
        }
        if (!this.writeInlineComments()) {
            this.writeLineBreak(null);
        }
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = true;
        int n2 = 0;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            int n3;
            char c2 = '\u0000';
            if (i2 < string.length()) {
                c2 = string.charAt(i2);
            }
            if (bl5) {
                if (c2 == '\u0000' || CharConstants.LINEBR.hasNo(c2)) {
                    if (!bl3 && c2 != '\u0000' && c2 != ' ' && string.charAt(n2) == '\n') {
                        this.writeLineBreak(null);
                    }
                    bl3 = c2 == ' ';
                    String string4 = string.substring(n2, i2);
                    for (char c3 : string4.toCharArray()) {
                        if (c3 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c3));
                    }
                    if (c2 != '\u0000') {
                        this.writeIndent();
                    }
                    n2 = i2;
                }
            } else if (bl4) {
                if (c2 != ' ') {
                    if (n2 + 1 == i2 && this.column > this.bestWidth && bl2) {
                        this.writeIndent();
                    } else {
                        n3 = i2 - n2;
                        this.column += n3;
                        this.stream.write(string, n2, n3);
                    }
                    n2 = i2;
                }
            } else if (CharConstants.LINEBR.has(c2, "\u0000 ")) {
                n3 = i2 - n2;
                this.column += n3;
                this.stream.write(string, n2, n3);
                if (c2 == '\u0000') {
                    this.writeLineBreak(null);
                }
                n2 = i2;
            }
            if (c2 == '\u0000') continue;
            bl5 = CharConstants.LINEBR.has(c2);
            bl4 = c2 == ' ';
        }
    }

    final void writeLiteral(String string) {
        String string2 = this.determineBlockHints(string);
        this.writeIndicator("|" + string2, true, false, false);
        if (string2.length() > 0) {
            String string3 = string2;
            if (string3.charAt(string3.length() - 1) == '+') {
                this.openEnded = true;
            }
        }
        if (!this.writeInlineComments()) {
            this.writeLineBreak(null);
        }
        boolean bl2 = true;
        int n2 = 0;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            char c2 = '\u0000';
            if (i2 < string.length()) {
                c2 = string.charAt(i2);
            }
            if (bl2) {
                if (c2 == '\u0000' || CharConstants.LINEBR.hasNo(c2)) {
                    Object object = string.substring(n2, i2);
                    char[] cArray = ((String)object).toCharArray();
                    object = cArray;
                    int n3 = cArray.length;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        Object object2 = object[i3];
                        if (object2 == 10) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf((char)object2));
                    }
                    if (c2 != '\u0000') {
                        this.writeIndent();
                    }
                    n2 = i2;
                }
            } else if (c2 == '\u0000' || CharConstants.LINEBR.has(c2)) {
                this.stream.write(string, n2, i2 - n2);
                if (c2 == '\u0000') {
                    this.writeLineBreak(null);
                }
                n2 = i2;
            }
            if (c2 == '\u0000') continue;
            bl2 = CharConstants.LINEBR.has(c2);
        }
    }

    final void writePlain(String string, boolean bl2) {
        if (this.rootContext) {
            this.openEnded = true;
        }
        if (string.length() == 0) {
            return;
        }
        if (!this.whitespace) {
            ++this.column;
            this.stream.write(SPACE);
        }
        this.whitespace = false;
        this.indention = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            int n3;
            char c2 = '\u0000';
            if (i2 < string.length()) {
                c2 = string.charAt(i2);
            }
            if (bl3) {
                if (c2 != ' ') {
                    if (n2 + 1 == i2 && this.column > this.bestWidth && bl2) {
                        this.writeIndent();
                        this.whitespace = false;
                        this.indention = false;
                    } else {
                        n3 = i2 - n2;
                        this.column += n3;
                        this.stream.write(string, n2, n3);
                    }
                    n2 = i2;
                }
            } else if (bl4) {
                if (CharConstants.LINEBR.hasNo(c2)) {
                    if (string.charAt(n2) == '\n') {
                        this.writeLineBreak(null);
                    }
                    String string2 = string.substring(n2, i2);
                    for (char c3 : string2.toCharArray()) {
                        if (c3 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c3));
                    }
                    this.writeIndent();
                    this.whitespace = false;
                    this.indention = false;
                    n2 = i2;
                }
            } else if (CharConstants.LINEBR.has(c2, "\u0000 ")) {
                n3 = i2 - n2;
                this.column += n3;
                this.stream.write(string, n2, n3);
                n2 = i2;
            }
            if (c2 == '\u0000') continue;
            bl3 = c2 == ' ';
            bl4 = CharConstants.LINEBR.has(c2);
        }
    }

    static {
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0000'), "0");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0007'), "a");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\b'), "b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\t'), "t");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\n'), "n");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u000b'), "v");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\f'), "f");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\r'), "r");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u001b'), "e");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\"'), "\"");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\\'), "\\");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0085'), "N");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u00a0'), "_");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u2028'), "L");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u2029'), "P");
        DEFAULT_TAG_PREFIXES = new LinkedHashMap<String, String>();
        DEFAULT_TAG_PREFIXES.put("!", "!");
        DEFAULT_TAG_PREFIXES.put("tag:yaml.org,2002:", "!!");
        HANDLE_FORMAT = Pattern.compile("^![-_\\w]*!$");
    }

    class ExpectBlockMappingValue
    implements EmitterState {
        private ExpectBlockMappingValue() {
        }

        @Override
        public void expect() {
            Emitter.this.writeIndent();
            Emitter.this.writeIndicator(":", true, false, true);
            Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeInlineComments();
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeBlockComment();
            Emitter.this.states.push(new ExpectBlockMappingKey(false));
            Emitter.this.expectNode(false, true, false);
            Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
            Emitter.this.writeInlineComments();
        }
    }

    class ExpectBlockMappingSimpleValue
    implements EmitterState {
        private ExpectBlockMappingSimpleValue() {
        }

        @Override
        public void expect() {
            Emitter.this.writeIndicator(":", false, false, false);
            Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            if (!Emitter.this.isFoldedOrLiteral(Emitter.this.event) && Emitter.this.writeInlineComments()) {
                Emitter.this.increaseIndent(true, false);
                Emitter.this.writeIndent();
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
            }
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            if (!Emitter.this.blockCommentsCollector.isEmpty()) {
                Emitter.this.increaseIndent(true, false);
                Emitter.this.writeBlockComment();
                Emitter.this.writeIndent();
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
            }
            Emitter.this.states.push(new ExpectBlockMappingKey(false));
            Emitter.this.expectNode(false, true, false);
            Emitter.this.inlineCommentsCollector.collectEvents();
            Emitter.this.writeInlineComments();
        }
    }

    class ExpectBlockMappingKey
    implements EmitterState {
        private final boolean first;

        public ExpectBlockMappingKey(boolean bl2) {
            this.first = bl2;
        }

        @Override
        public void expect() {
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeBlockComment();
            if (!this.first && Emitter.this.event.getEventId() == Event.ID.MappingEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
                return;
            }
            Emitter.this.writeIndent();
            if (Emitter.this.checkSimpleKey()) {
                Emitter.this.states.push(new ExpectBlockMappingSimpleValue());
                Emitter.this.expectNode(false, true, true);
                return;
            }
            Emitter.this.writeIndicator("?", true, false, true);
            Emitter.this.states.push(new ExpectBlockMappingValue());
            Emitter.this.expectNode(false, true, false);
        }
    }

    class ExpectFirstBlockMappingKey
    implements EmitterState {
        private ExpectFirstBlockMappingKey() {
        }

        @Override
        public void expect() {
            new ExpectBlockMappingKey(true).expect();
        }
    }

    class ExpectBlockSequenceItem
    implements EmitterState {
        private final boolean first;

        public ExpectBlockSequenceItem(boolean bl2) {
            this.first = bl2;
        }

        @Override
        public void expect() {
            if (!this.first && Emitter.this.event.getEventId() == Event.ID.SequenceEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
                return;
            }
            if (Emitter.this.event instanceof CommentEvent) {
                Emitter.this.blockCommentsCollector.collectEvents(Emitter.this.event);
                return;
            }
            Emitter.this.writeIndent();
            if (!Emitter.this.indentWithIndicator || this.first) {
                Emitter.this.writeWhitespace(Emitter.this.indicatorIndent);
            }
            Emitter.this.writeIndicator("-", true, false, true);
            if (Emitter.this.indentWithIndicator && this.first) {
                Emitter.this.indent = Emitter.this.indent + Emitter.this.indicatorIndent;
            }
            if (!Emitter.this.blockCommentsCollector.isEmpty()) {
                Emitter.this.increaseIndent(false, false);
                Emitter.this.writeBlockComment();
                if (Emitter.this.event instanceof ScalarEvent) {
                    Emitter.this.analysis = Emitter.this.analyzeScalar(((ScalarEvent)Emitter.this.event).getValue());
                    if (!Emitter.this.analysis.isEmpty()) {
                        Emitter.this.writeIndent();
                    }
                }
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
            }
            Emitter.this.states.push(new ExpectBlockSequenceItem(false));
            Emitter.this.expectNode(false, false, false);
            Emitter.this.inlineCommentsCollector.collectEvents();
            Emitter.this.writeInlineComments();
        }
    }

    class ExpectFirstBlockSequenceItem
    implements EmitterState {
        private ExpectFirstBlockSequenceItem() {
        }

        @Override
        public void expect() {
            new ExpectBlockSequenceItem(true).expect();
        }
    }

    class ExpectFlowMappingValue
    implements EmitterState {
        private ExpectFlowMappingValue() {
        }

        @Override
        public void expect() {
            if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth || Emitter.this.multiLineFlow.booleanValue()) {
                Emitter.this.writeIndent();
            }
            Emitter.this.writeIndicator(":", true, false, false);
            Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeInlineComments();
            Emitter.this.states.push(new ExpectFlowMappingKey());
            Emitter.this.expectNode(false, true, false);
            Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
            Emitter.this.writeInlineComments();
        }
    }

    class ExpectFlowMappingSimpleValue
    implements EmitterState {
        private ExpectFlowMappingSimpleValue() {
        }

        @Override
        public void expect() {
            Emitter.this.writeIndicator(":", false, false, false);
            Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeInlineComments();
            Emitter.this.states.push(new ExpectFlowMappingKey());
            Emitter.this.expectNode(false, true, false);
            Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
            Emitter.this.writeInlineComments();
        }
    }

    class ExpectFlowMappingKey
    implements EmitterState {
        private ExpectFlowMappingKey() {
        }

        @Override
        public void expect() {
            if (Emitter.this.event.getEventId() == Event.ID.MappingEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.flowLevel--;
                if (Emitter.this.canonical.booleanValue()) {
                    Emitter.this.writeIndicator(",", false, false, false);
                    Emitter.this.writeIndent();
                }
                if (Emitter.this.multiLineFlow.booleanValue()) {
                    Emitter.this.writeIndent();
                }
                Emitter.this.writeIndicator("}", false, false, false);
                Emitter.this.inlineCommentsCollector.collectEvents();
                Emitter.this.writeInlineComments();
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
                return;
            }
            Emitter.this.writeIndicator(",", false, false, false);
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeBlockComment();
            if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth && Emitter.this.splitLines || Emitter.this.multiLineFlow.booleanValue()) {
                Emitter.this.writeIndent();
            }
            if (!Emitter.this.canonical.booleanValue() && Emitter.this.checkSimpleKey()) {
                Emitter.this.states.push(new ExpectFlowMappingSimpleValue());
                Emitter.this.expectNode(false, true, true);
                return;
            }
            Emitter.this.writeIndicator("?", true, false, false);
            Emitter.this.states.push(new ExpectFlowMappingValue());
            Emitter.this.expectNode(false, true, false);
        }
    }

    class ExpectFirstFlowMappingKey
    implements EmitterState {
        private ExpectFirstFlowMappingKey() {
        }

        @Override
        public void expect() {
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeBlockComment();
            if (Emitter.this.event.getEventId() == Event.ID.MappingEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.flowLevel--;
                Emitter.this.writeIndicator("}", false, false, false);
                Emitter.this.inlineCommentsCollector.collectEvents();
                Emitter.this.writeInlineComments();
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
                return;
            }
            if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth && Emitter.this.splitLines || Emitter.this.multiLineFlow.booleanValue()) {
                Emitter.this.writeIndent();
            }
            if (!Emitter.this.canonical.booleanValue() && Emitter.this.checkSimpleKey()) {
                Emitter.this.states.push(new ExpectFlowMappingSimpleValue());
                Emitter.this.expectNode(false, true, true);
                return;
            }
            Emitter.this.writeIndicator("?", true, false, false);
            Emitter.this.states.push(new ExpectFlowMappingValue());
            Emitter.this.expectNode(false, true, false);
        }
    }

    class ExpectFlowSequenceItem
    implements EmitterState {
        private ExpectFlowSequenceItem() {
        }

        @Override
        public void expect() {
            if (Emitter.this.event.getEventId() == Event.ID.SequenceEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.flowLevel--;
                if (Emitter.this.canonical.booleanValue()) {
                    Emitter.this.writeIndicator(",", false, false, false);
                    Emitter.this.writeIndent();
                } else if (Emitter.this.multiLineFlow.booleanValue()) {
                    Emitter.this.writeIndent();
                }
                Emitter.this.writeIndicator("]", false, false, false);
                Emitter.this.inlineCommentsCollector.collectEvents();
                Emitter.this.writeInlineComments();
                if (Emitter.this.multiLineFlow.booleanValue()) {
                    Emitter.this.writeIndent();
                }
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
                return;
            }
            if (Emitter.this.event instanceof CommentEvent) {
                Emitter.this.event = Emitter.this.blockCommentsCollector.collectEvents(Emitter.this.event);
                return;
            }
            Emitter.this.writeIndicator(",", false, false, false);
            Emitter.this.writeBlockComment();
            if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth && Emitter.this.splitLines || Emitter.this.multiLineFlow.booleanValue()) {
                Emitter.this.writeIndent();
            }
            Emitter.this.states.push(new ExpectFlowSequenceItem());
            Emitter.this.expectNode(false, false, false);
            Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
            Emitter.this.writeInlineComments();
        }
    }

    class ExpectFirstFlowSequenceItem
    implements EmitterState {
        private ExpectFirstFlowSequenceItem() {
        }

        @Override
        public void expect() {
            if (Emitter.this.event.getEventId() == Event.ID.SequenceEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.flowLevel--;
                Emitter.this.writeIndicator("]", false, false, false);
                Emitter.this.inlineCommentsCollector.collectEvents();
                Emitter.this.writeInlineComments();
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
                return;
            }
            if (Emitter.this.event instanceof CommentEvent) {
                Emitter.this.blockCommentsCollector.collectEvents(Emitter.this.event);
                Emitter.this.writeBlockComment();
                return;
            }
            if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth && Emitter.this.splitLines || Emitter.this.multiLineFlow.booleanValue()) {
                Emitter.this.writeIndent();
            }
            Emitter.this.states.push(new ExpectFlowSequenceItem());
            Emitter.this.expectNode(false, false, false);
            Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
            Emitter.this.writeInlineComments();
        }
    }

    class ExpectDocumentRoot
    implements EmitterState {
        private ExpectDocumentRoot() {
        }

        @Override
        public void expect() {
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            if (!Emitter.this.blockCommentsCollector.isEmpty()) {
                Emitter.this.writeBlockComment();
                if (Emitter.this.event instanceof DocumentEndEvent) {
                    new ExpectDocumentEnd().expect();
                    return;
                }
            }
            Emitter.this.states.push(new ExpectDocumentEnd());
            Emitter.this.expectNode(true, false, false);
        }
    }

    class ExpectDocumentEnd
    implements EmitterState {
        private ExpectDocumentEnd() {
        }

        @Override
        public void expect() {
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeBlockComment();
            if (Emitter.this.event.getEventId() == Event.ID.DocumentEnd) {
                Emitter.this.writeIndent();
                if (((DocumentEndEvent)Emitter.this.event).isExplicit()) {
                    Emitter.this.writeIndicator("...", true, false, false);
                    Emitter.this.writeIndent();
                }
                Emitter.this.flushStream();
                Emitter.this.state = new ExpectDocumentStart(false);
                return;
            }
            throw new EmitterException("expected DocumentEndEvent, but got " + Emitter.this.event);
        }
    }

    class ExpectDocumentStart
    implements EmitterState {
        private final boolean first;

        public ExpectDocumentStart(boolean bl2) {
            this.first = bl2;
        }

        @Override
        public void expect() {
            if (Emitter.this.event.getEventId() == Event.ID.DocumentStart) {
                DocumentStartEvent documentStartEvent = (DocumentStartEvent)Emitter.this.event;
                this.handleDocumentStartEvent(documentStartEvent);
                Emitter.this.state = new ExpectDocumentRoot();
                return;
            }
            if (Emitter.this.event.getEventId() == Event.ID.StreamEnd) {
                Emitter.this.writeStreamEnd();
                Emitter.this.state = new ExpectNothing();
                return;
            }
            if (Emitter.this.event instanceof CommentEvent) {
                Emitter.this.blockCommentsCollector.collectEvents(Emitter.this.event);
                Emitter.this.writeBlockComment();
                return;
            }
            throw new EmitterException("expected DocumentStartEvent, but got " + Emitter.this.event);
        }

        private void handleDocumentStartEvent(DocumentStartEvent documentStartEvent) {
            boolean bl2;
            if ((documentStartEvent.getSpecVersion().isPresent() || !documentStartEvent.getTags().isEmpty()) && Emitter.this.openEnded) {
                Emitter.this.writeIndicator("...", true, false, false);
                Emitter.this.writeIndent();
            }
            documentStartEvent.getSpecVersion().ifPresent(specVersion -> Emitter.this.writeVersionDirective(Emitter.this.prepareVersion(specVersion)));
            Emitter.this.tagPrefixes = new LinkedHashMap(DEFAULT_TAG_PREFIXES);
            if (!documentStartEvent.getTags().isEmpty()) {
                this.handleTagDirectives(documentStartEvent.getTags());
            }
            if (!(bl2 = this.first && !documentStartEvent.isExplicit() && Emitter.this.canonical == false && !documentStartEvent.getSpecVersion().isPresent() && documentStartEvent.getTags().isEmpty() && !this.checkEmptyDocument())) {
                Emitter.this.writeIndent();
                Emitter.this.writeIndicator("---", true, false, false);
                if (Emitter.this.canonical.booleanValue()) {
                    Emitter.this.writeIndent();
                }
            }
        }

        private void handleTagDirectives(Map<String, String> map) {
            Object object = new TreeSet<String>(map.keySet());
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                String string2 = map.get(string);
                Emitter.this.tagPrefixes.put(string2, string);
                string = Emitter.this.prepareTagHandle(string);
                string2 = Emitter.this.prepareTagPrefix(string2);
                Emitter.this.writeTagDirective(string, string2);
            }
        }

        private boolean checkEmptyDocument() {
            if (Emitter.this.event.getEventId() != Event.ID.DocumentStart || Emitter.this.events.isEmpty()) {
                return false;
            }
            Event event = (Event)Emitter.this.events.peek();
            if (event.getEventId() == Event.ID.Scalar) {
                return !((NodeEvent)(event = (ScalarEvent)event)).getAnchor().isPresent() && !((ScalarEvent)event).getTag().isPresent() && ((ScalarEvent)event).getImplicit() != null && ((ScalarEvent)event).getValue().length() == 0;
            }
            return false;
        }
    }

    class ExpectFirstDocumentStart
    implements EmitterState {
        private ExpectFirstDocumentStart() {
        }

        @Override
        public void expect() {
            new ExpectDocumentStart(true).expect();
        }
    }

    class ExpectNothing
    implements EmitterState {
        private ExpectNothing() {
        }

        @Override
        public void expect() {
            throw new EmitterException("expecting nothing, but got " + Emitter.this.event);
        }
    }

    class ExpectStreamStart
    implements EmitterState {
        private ExpectStreamStart() {
        }

        @Override
        public void expect() {
            if (Emitter.this.event.getEventId() == Event.ID.StreamStart) {
                Emitter.this.writeStreamStart();
                Emitter.this.state = new ExpectFirstDocumentStart();
                return;
            }
            throw new EmitterException("expected StreamStartEvent, but got " + Emitter.this.event);
        }
    }
}

