/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.route;

import java.util.regex.Pattern;
import me.extremall.advancedkits.libs.boostedyaml.route.Route;
import me.extremall.advancedkits.libs.boostedyaml.settings.general.GeneralSettings;
import org.jetbrains.annotations.NotNull;

public class RouteFactory {
    private final char separator;
    private final String escapedSeparator;

    public RouteFactory(@NotNull GeneralSettings generalSettings) {
        this.separator = generalSettings.getRouteSeparator();
        this.escapedSeparator = generalSettings.getEscapedSeparator();
    }

    public RouteFactory(char c2) {
        this.separator = c2;
        this.escapedSeparator = Pattern.quote(String.valueOf(c2));
    }

    public RouteFactory() {
        this.separator = (char)46;
        this.escapedSeparator = GeneralSettings.DEFAULT_ESCAPED_SEPARATOR;
    }

    @NotNull
    public Route create(String string) {
        return Route.fromString(string, this);
    }

    public char getSeparator() {
        return this.separator;
    }

    @NotNull
    public String getEscapedSeparator() {
        return this.escapedSeparator;
    }
}

