/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.settings.dumper;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.DumpSettingsBuilder;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.NonPrintableStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.SpecVersion;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.resolver.ScalarResolver;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.serializer.AnchorGenerator;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.serializer.NumberAnchorGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumperSettings {
    public static final DumperSettings DEFAULT = DumperSettings.builder().build();
    private final DumpSettingsBuilder builder;
    private final Supplier<AnchorGenerator> generatorSupplier;

    private DumperSettings(Builder builder) {
        this.builder = builder.builder;
        this.generatorSupplier = builder.anchorGeneratorSupplier;
    }

    public DumpSettings buildEngineSettings() {
        return this.builder.setAnchorGenerator(this.generatorSupplier.get()).setDumpComments(true).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DumpSettingsBuilder dumpSettingsBuilder) {
        return new Builder(dumpSettingsBuilder);
    }

    public static Builder builder(DumperSettings dumperSettings) {
        return DumperSettings.builder(dumperSettings.builder).setAnchorGenerator(dumperSettings.generatorSupplier);
    }

    public static class Builder {
        public static final Supplier<AnchorGenerator> DEFAULT_ANCHOR_GENERATOR = () -> new NumberAnchorGenerator(0);
        public static final FlowStyle DEFAULT_FLOW_STYLE = FlowStyle.BLOCK;
        public static final ScalarStyle DEFAULT_SCALAR_STYLE = ScalarStyle.PLAIN;
        public static final boolean DEFAULT_START_MARKER = false;
        public static final boolean DEFAULT_END_MARKER = false;
        public static final Tag DEFAULT_ROOT_TAG = null;
        public static final boolean DEFAULT_CANONICAL = false;
        public static final boolean DEFAULT_MULTILINE_FORMAT = false;
        public static final Encoding DEFAULT_ENCODING = Encoding.UNICODE;
        public static final int DEFAULT_INDENTATION = 2;
        public static final int DEFAULT_INDICATOR_INDENTATION = 0;
        public static final int DEFAULT_MAX_LINE_WIDTH = 0;
        public static final int DEFAULT_MAX_SIMPLE_KEY_LENGTH = 0;
        public static final boolean DEFAULT_ESCAPE_UNPRINTABLE = true;
        private final DumpSettingsBuilder builder;
        private Supplier<AnchorGenerator> anchorGeneratorSupplier = DEFAULT_ANCHOR_GENERATOR;

        private Builder(DumpSettingsBuilder dumpSettingsBuilder) {
            this.builder = dumpSettingsBuilder;
        }

        private Builder() {
            this.builder = DumpSettings.builder();
            this.setFlowStyle(DEFAULT_FLOW_STYLE);
            this.setScalarStyle(DEFAULT_SCALAR_STYLE);
            this.setStartMarker(false);
            this.setEndMarker(false);
            this.setRootTag(DEFAULT_ROOT_TAG);
            this.setCanonicalForm(false);
            this.setMultilineStyle(false);
            this.setEncoding(DEFAULT_ENCODING);
            this.setIndentation(2);
            this.setIndicatorIndentation(0);
            this.setLineWidth(0);
            this.setMaxSimpleKeyLength(0);
            this.setEscapeUnprintable(true);
        }

        public Builder setAnchorGenerator(@NotNull Supplier<AnchorGenerator> supplier) {
            this.anchorGeneratorSupplier = supplier;
            return this;
        }

        public Builder setFlowStyle(@NotNull FlowStyle flowStyle) {
            this.builder.setDefaultFlowStyle(flowStyle);
            return this;
        }

        public Builder setScalarStyle(@NotNull ScalarStyle scalarStyle) {
            this.builder.setDefaultScalarStyle(scalarStyle);
            return this;
        }

        public Builder setStartMarker(boolean bl2) {
            this.builder.setExplicitStart(bl2);
            return this;
        }

        public Builder setEndMarker(boolean bl2) {
            this.builder.setExplicitEnd(bl2);
            return this;
        }

        public Builder setScalarResolver(@NotNull ScalarResolver scalarResolver) {
            this.builder.setScalarResolver(scalarResolver);
            return this;
        }

        public Builder setRootTag(@Nullable Tag tag) {
            this.builder.setExplicitRootTag(Optional.ofNullable(tag));
            return this;
        }

        public Builder setYamlDirective(@Nullable SpecVersion specVersion) {
            this.builder.setYamlDirective(Optional.ofNullable(specVersion));
            return this;
        }

        public Builder setTagDirectives(@NotNull Map<String, String> map) {
            this.builder.setTagDirective(map);
            return this;
        }

        public Builder setCanonicalForm(boolean bl2) {
            this.builder.setCanonical(bl2);
            return this;
        }

        public Builder setMultilineStyle(boolean bl2) {
            this.builder.setMultiLineFlow(bl2);
            return this;
        }

        public Builder setEncoding(@NotNull Encoding encoding) {
            this.builder.setUseUnicodeEncoding(encoding.isUnicode());
            return this;
        }

        public Builder setIndentation(int n2) {
            this.builder.setIndent(n2);
            return this;
        }

        public Builder setIndicatorIndentation(int n2) {
            this.builder.setIndentWithIndicator(n2 > 0);
            this.builder.setIndicatorIndent(Math.max(n2, 0));
            return this;
        }

        public Builder setLineWidth(int n2) {
            this.builder.setWidth(n2 <= 0 ? Integer.MAX_VALUE : n2);
            return this;
        }

        public Builder setLineBreak(@NotNull String string) {
            this.builder.setBestLineBreak(string);
            return this;
        }

        public Builder setMaxSimpleKeyLength(int n2) {
            if (n2 > 1018) {
                throw new IllegalArgumentException("Maximum simple key length is limited to 1018!");
            }
            this.builder.setMaxSimpleKeyLength(n2 <= 0 ? 1024 : n2 + 6);
            return this;
        }

        public Builder setEscapeUnprintable(boolean bl2) {
            return this.setUnprintableStyle(bl2 ? NonPrintableStyle.ESCAPE : NonPrintableStyle.BINARY);
        }

        public Builder setUnprintableStyle(@NotNull NonPrintableStyle nonPrintableStyle) {
            this.builder.setNonPrintableStyle(nonPrintableStyle);
            return this;
        }

        public DumperSettings build() {
            return new DumperSettings(this);
        }
    }

    public static enum Encoding {
        UNICODE,
        ASCII;


        final boolean isUnicode() {
            return this == UNICODE;
        }
    }
}

