/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.settings.updater;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import me.extremall.advancedkits.libs.boostedyaml.YamlDocument;
import me.extremall.advancedkits.libs.boostedyaml.dvs.Pattern;
import me.extremall.advancedkits.libs.boostedyaml.dvs.versioning.AutomaticVersioning;
import me.extremall.advancedkits.libs.boostedyaml.dvs.versioning.ManualVersioning;
import me.extremall.advancedkits.libs.boostedyaml.dvs.versioning.Versioning;
import me.extremall.advancedkits.libs.boostedyaml.route.Route;
import me.extremall.advancedkits.libs.boostedyaml.route.RouteFactory;
import me.extremall.advancedkits.libs.boostedyaml.settings.updater.MergeRule;
import me.extremall.advancedkits.libs.boostedyaml.settings.updater.ValueMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdaterSettings {
    public static final boolean DEFAULT_AUTO_SAVE = true;
    public static final boolean DEFAULT_ENABLE_DOWNGRADING = true;
    public static final boolean DEFAULT_KEEP_ALL = false;
    public static final OptionSorting DEFAULT_OPTION_SORTING = OptionSorting.SORT_BY_DEFAULTS;
    public static final Map<MergeRule, Boolean> DEFAULT_MERGE_RULES = Collections.unmodifiableMap(new HashMap<MergeRule, Boolean>(){
        {
            this.put(MergeRule.MAPPINGS, Boolean.TRUE);
            this.put(MergeRule.MAPPING_AT_SECTION, Boolean.FALSE);
            this.put(MergeRule.SECTION_AT_MAPPING, Boolean.FALSE);
        }
    });
    public static final Versioning DEFAULT_VERSIONING = null;
    public static final UpdaterSettings DEFAULT = UpdaterSettings.builder().build();
    private final boolean autoSave;
    private final boolean enableDowngrading;
    private final boolean keepAll;
    private final Map<MergeRule, Boolean> mergeRules;
    private final Map<String, RouteSet> ignored;
    private final Map<String, RouteMap<Route, String>> relocations;
    private final Map<String, Map<Route, ValueMapper>> mappers;
    private final Map<String, List<Consumer<YamlDocument>>> customLogic;
    private final Versioning versioning;
    private final OptionSorting optionSorting;

    public UpdaterSettings(Builder builder) {
        this.autoSave = builder.autoSave;
        this.enableDowngrading = builder.enableDowngrading;
        this.keepAll = builder.keepAll;
        this.optionSorting = builder.optionSorting;
        this.mergeRules = builder.mergeRules;
        this.ignored = builder.ignored;
        this.relocations = builder.relocations;
        this.mappers = builder.mappers;
        this.customLogic = builder.customLogic;
        this.versioning = builder.versioning;
    }

    public Map<MergeRule, Boolean> getMergeRules() {
        return this.mergeRules;
    }

    public Set<Route> getIgnoredRoutes(@NotNull String object, char c2) {
        if ((object = this.ignored.get(object)) == null) {
            return Collections.emptySet();
        }
        return ((RouteSet)object).merge(c2);
    }

    public Map<Route, Route> getRelocations(@NotNull String object, char c2) {
        if ((object = this.relocations.get(object)) == null) {
            return Collections.emptyMap();
        }
        return ((RouteMap)object).merge(Function.identity(), string -> Route.fromString(string, c2), c2);
    }

    public Map<Route, ValueMapper> getMappers(@NotNull String string, char c2) {
        return this.mappers.getOrDefault(string, Collections.emptyMap());
    }

    public List<Consumer<YamlDocument>> getCustomLogic(@NotNull String string) {
        return this.customLogic.getOrDefault(string, Collections.emptyList());
    }

    public Versioning getVersioning() {
        return this.versioning;
    }

    public boolean isEnableDowngrading() {
        return this.enableDowngrading;
    }

    public boolean isKeepAll() {
        return this.keepAll;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public OptionSorting getOptionSorting() {
        return this.optionSorting;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UpdaterSettings updaterSettings) {
        return UpdaterSettings.builder().setAutoSave(updaterSettings.autoSave).setEnableDowngrading(updaterSettings.enableDowngrading).setKeepAll(updaterSettings.keepAll).setOptionSorting(updaterSettings.optionSorting).setMergeRules(updaterSettings.mergeRules).setIgnoredRoutesInternal(updaterSettings.ignored).setRelocationsInternal(updaterSettings.relocations).addMappers(updaterSettings.mappers).addCustomLogic(updaterSettings.customLogic).setVersioning(updaterSettings.versioning);
    }

    static class RouteSet {
        private Set<Route> routes = null;
        private Set<String> strings = null;

        private RouteSet() {
        }

        public Set<Route> merge(char c2) {
            if ((this.routes == null || this.routes.isEmpty()) && (this.strings == null || this.strings.isEmpty())) {
                return Collections.emptySet();
            }
            HashSet<Route> hashSet = new HashSet<Route>();
            if (this.strings != null) {
                this.strings.forEach(string -> hashSet.add(Route.fromString(string, c2)));
            }
            if (this.routes != null) {
                hashSet.addAll(this.routes);
            }
            return hashSet;
        }

        public Set<Route> getRouteSet() {
            if (this.routes == null) {
                this.routes = new HashSet<Route>();
                return this.routes;
            }
            return this.routes;
        }

        public Set<String> getStringSet() {
            if (this.strings == null) {
                this.strings = new HashSet<String>();
                return this.strings;
            }
            return this.strings;
        }
    }

    static class RouteMap<R, S> {
        private Map<Route, R> routes = null;
        private Map<String, S> strings = null;

        private RouteMap() {
        }

        @NotNull
        public <T> Map<Route, T> merge(@NotNull Function<R, T> function, @NotNull Function<S, T> function2, char c2) {
            if ((this.routes == null || this.routes.isEmpty()) && (this.strings == null || this.strings.isEmpty())) {
                return Collections.emptyMap();
            }
            HashMap hashMap = new HashMap();
            if (this.strings != null) {
                this.strings.forEach((string, object) -> hashMap.put(Route.fromString(string, c2), function2.apply(object)));
            }
            if (this.routes != null) {
                this.routes.forEach((route, object) -> hashMap.put(route, function.apply(object)));
            }
            return hashMap;
        }

        @NotNull
        public Map<Route, R> getRouteMap() {
            if (this.routes == null) {
                this.routes = new HashMap<Route, R>();
                return this.routes;
            }
            return this.routes;
        }

        @NotNull
        public Map<String, S> getStringMap() {
            if (this.strings == null) {
                this.strings = new HashMap<String, S>();
                return this.strings;
            }
            return this.strings;
        }
    }

    public static class Builder {
        private boolean autoSave = true;
        private boolean enableDowngrading = true;
        private boolean keepAll = false;
        private final Map<MergeRule, Boolean> mergeRules = new HashMap<MergeRule, Boolean>(DEFAULT_MERGE_RULES);
        private final Map<String, RouteSet> ignored = new HashMap<String, RouteSet>();
        private final Map<String, RouteMap<Route, String>> relocations = new HashMap<String, RouteMap<Route, String>>();
        private final Map<String, Map<Route, ValueMapper>> mappers = new HashMap<String, Map<Route, ValueMapper>>();
        private final Map<String, List<Consumer<YamlDocument>>> customLogic = new HashMap<String, List<Consumer<YamlDocument>>>();
        private Versioning versioning = DEFAULT_VERSIONING;
        private OptionSorting optionSorting = DEFAULT_OPTION_SORTING;

        private Builder() {
        }

        public Builder setAutoSave(boolean bl2) {
            this.autoSave = bl2;
            return this;
        }

        public Builder setEnableDowngrading(boolean bl2) {
            this.enableDowngrading = bl2;
            return this;
        }

        public Builder setKeepAll(boolean bl2) {
            this.keepAll = bl2;
            return this;
        }

        public Builder setOptionSorting(@NotNull OptionSorting optionSorting) {
            this.optionSorting = optionSorting;
            return this;
        }

        public Builder setMergeRules(@NotNull Map<MergeRule, Boolean> map) {
            this.mergeRules.putAll(map);
            return this;
        }

        public Builder setMergeRule(@NotNull MergeRule mergeRule, boolean bl2) {
            this.mergeRules.put(mergeRule, bl2);
            return this;
        }

        private Builder setIgnoredRoutesInternal(@NotNull Map<String, RouteSet> map) {
            this.ignored.putAll(map);
            return this;
        }

        @Deprecated
        public Builder setIgnoredRoutes(@NotNull Map<String, Set<Route>> map) {
            map.forEach((string2, set) -> this.ignored.computeIfAbsent((String)string2, string -> new RouteSet()).getRouteSet().addAll((Collection<Route>)set));
            return this;
        }

        @Deprecated
        public Builder setIgnoredRoutes(@NotNull String string2, @NotNull Set<Route> set) {
            this.ignored.computeIfAbsent(string2, string -> new RouteSet()).getRouteSet().addAll(set);
            return this;
        }

        @Deprecated
        public Builder setIgnoredStringRoutes(@NotNull Map<String, Set<String>> map) {
            map.forEach((string2, set) -> this.ignored.computeIfAbsent((String)string2, string -> new RouteSet()).getStringSet().addAll((Collection<String>)set));
            return this;
        }

        @Deprecated
        public Builder setIgnoredStringRoutes(@NotNull String string2, @NotNull Set<String> set) {
            this.ignored.computeIfAbsent(string2, string -> new RouteSet()).getStringSet().addAll(set);
            return this;
        }

        public Builder addIgnoredRoute(@NotNull String string, @NotNull Route route) {
            return this.addIgnoredRoutes(string, Collections.singleton(route));
        }

        public Builder addIgnoredRoutes(@NotNull String string, @NotNull Set<Route> set) {
            return this.addIgnoredRoutes(Collections.singletonMap(string, set));
        }

        public Builder addIgnoredRoutes(@NotNull Map<String, Set<Route>> map) {
            map.forEach((string2, set) -> this.ignored.computeIfAbsent((String)string2, string -> new RouteSet()).getRouteSet().addAll((Collection<Route>)set));
            return this;
        }

        public Builder addIgnoredRoute(@NotNull String string, @NotNull String string2, char c2) {
            return this.addIgnoredRoutes(string, Collections.singleton(string2), c2);
        }

        public Builder addIgnoredRoutes(@NotNull String string, @NotNull Set<String> set, char c2) {
            this.addIgnoredRoutes(string, set, new RouteFactory(c2));
            return this;
        }

        public Builder addIgnoredRoutes(@NotNull Map<String, Set<String>> map, char c2) {
            RouteFactory routeFactory = new RouteFactory(c2);
            map.forEach((string, set) -> this.addIgnoredRoutes((String)string, (Set<String>)set, routeFactory));
            return this;
        }

        private void addIgnoredRoutes(@NotNull String object, @NotNull Set<String> set, @NotNull RouteFactory routeFactory) {
            object = this.ignored.computeIfAbsent((String)object, string -> new RouteSet()).getRouteSet();
            set.forEach(arg_0 -> Builder.lambda$addIgnoredRoutes$10((Set)object, routeFactory, arg_0));
        }

        private Builder setRelocationsInternal(@NotNull Map<String, RouteMap<Route, String>> map) {
            this.relocations.putAll(map);
            return this;
        }

        @Deprecated
        public Builder setRelocations(@NotNull Map<String, Map<Route, Route>> map2) {
            map2.forEach((string2, map) -> this.relocations.computeIfAbsent((String)string2, string -> new RouteMap()).getRouteMap().putAll(map));
            return this;
        }

        @Deprecated
        public Builder setRelocations(@NotNull String string2, @NotNull Map<Route, Route> map) {
            this.relocations.computeIfAbsent(string2, string -> new RouteMap()).getRouteMap().putAll(map);
            return this;
        }

        @Deprecated
        public Builder setStringRelocations(@NotNull Map<String, Map<String, String>> map2) {
            map2.forEach((string2, map) -> this.relocations.computeIfAbsent((String)string2, string -> new RouteMap()).getStringMap().putAll(map));
            return this;
        }

        @Deprecated
        public Builder setStringRelocations(@NotNull String string2, @NotNull Map<String, String> map) {
            this.relocations.computeIfAbsent(string2, string -> new RouteMap()).getStringMap().putAll(map);
            return this;
        }

        public Builder addRelocation(@NotNull String string, @NotNull Route route, @NotNull Route route2) {
            return this.addRelocations(string, Collections.singletonMap(route, route2));
        }

        public Builder addRelocations(@NotNull String string, @NotNull Map<Route, Route> map) {
            return this.addRelocations(Collections.singletonMap(string, map));
        }

        public Builder addRelocations(@NotNull Map<String, Map<Route, Route>> map2) {
            map2.forEach((string2, map) -> this.relocations.computeIfAbsent((String)string2, string -> new RouteMap()).getRouteMap().putAll(map));
            return this;
        }

        public Builder addRelocation(@NotNull String string, @NotNull String string2, @NotNull String string3, char c2) {
            return this.addRelocations(string, Collections.singletonMap(string2, string3), c2);
        }

        public Builder addRelocations(@NotNull String string, @NotNull Map<String, String> map, char c2) {
            this.addRelocations(Collections.singletonMap(string, map), c2);
            return this;
        }

        public Builder addRelocations(@NotNull Map<String, Map<String, String>> map2, char c2) {
            RouteFactory routeFactory = new RouteFactory(c2);
            map2.forEach((object, map) -> {
                object = this.relocations.computeIfAbsent((String)object, string -> new RouteMap()).getRouteMap();
                map.forEach((arg_0, arg_1) -> Builder.lambda$null$20((Map)object, routeFactory, arg_0, arg_1));
            });
            return this;
        }

        public Builder addMapper(@NotNull String string, @NotNull Route route, @NotNull ValueMapper valueMapper) {
            return this.addMappers(string, Collections.singletonMap(route, valueMapper));
        }

        public Builder addMappers(@NotNull String string, @NotNull Map<Route, ValueMapper> map) {
            return this.addMappers(Collections.singletonMap(string, map));
        }

        public Builder addMappers(@NotNull Map<String, Map<Route, ValueMapper>> map2) {
            map2.forEach((string2, map) -> this.mappers.computeIfAbsent((String)string2, string -> new HashMap()).putAll(map));
            return this;
        }

        public Builder addMapper(@NotNull String string, @NotNull String string2, @NotNull ValueMapper valueMapper, char c2) {
            return this.addMappers(string, Collections.singletonMap(string2, valueMapper), c2);
        }

        public Builder addMappers(@NotNull String string, @NotNull Map<String, ValueMapper> map, char c2) {
            return this.addMappers(Collections.singletonMap(string, map), c2);
        }

        public Builder addMappers(@NotNull Map<String, Map<String, ValueMapper>> map2, char c2) {
            RouteFactory routeFactory = new RouteFactory(c2);
            map2.forEach((object, map) -> {
                object = this.mappers.computeIfAbsent((String)object, string -> new HashMap());
                map.forEach((arg_0, arg_1) -> Builder.lambda$null$25((Map)object, routeFactory, arg_0, arg_1));
            });
            return this;
        }

        public Builder addCustomLogic(@NotNull String string, @NotNull Consumer<YamlDocument> consumer) {
            return this.addCustomLogic(string, Collections.singletonList(consumer));
        }

        public Builder addCustomLogic(@NotNull Map<String, List<Consumer<YamlDocument>>> map) {
            map.forEach(this::addCustomLogic);
            return this;
        }

        public Builder addCustomLogic(@NotNull String string2, @NotNull Collection<Consumer<YamlDocument>> collection) {
            this.customLogic.computeIfAbsent(string2, string -> new ArrayList()).addAll(collection);
            return this;
        }

        public Builder setVersioning(@NotNull Versioning versioning) {
            this.versioning = versioning;
            return this;
        }

        public Builder setVersioning(@NotNull Pattern pattern, @Nullable String string, @NotNull String string2) {
            return this.setVersioning(new ManualVersioning(pattern, string, string2));
        }

        public Builder setVersioning(@NotNull Pattern pattern, @NotNull Route route) {
            return this.setVersioning(new AutomaticVersioning(pattern, route));
        }

        public Builder setVersioning(@NotNull Pattern pattern, @NotNull String string) {
            return this.setVersioning(new AutomaticVersioning(pattern, string));
        }

        public UpdaterSettings build() {
            return new UpdaterSettings(this);
        }

        private static /* synthetic */ void lambda$null$25(Map map, RouteFactory routeFactory, String string, ValueMapper valueMapper) {
            map.put(routeFactory.create(string), valueMapper);
        }

        private static /* synthetic */ void lambda$null$20(Map map, RouteFactory routeFactory, String string, String string2) {
            map.put(routeFactory.create(string), routeFactory.create(string2));
        }

        private static /* synthetic */ void lambda$addIgnoredRoutes$10(Set set, RouteFactory routeFactory, String string) {
            set.add(routeFactory.create(string));
        }
    }

    public static enum OptionSorting {
        NONE,
        SORT_BY_DEFAULTS;

    }
}

