/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.updater;

import java.util.Objects;
import me.extremall.advancedkits.libs.boostedyaml.block.implementation.Section;
import me.extremall.advancedkits.libs.boostedyaml.dvs.Version;
import me.extremall.advancedkits.libs.boostedyaml.dvs.versioning.Versioning;
import me.extremall.advancedkits.libs.boostedyaml.route.Route;
import me.extremall.advancedkits.libs.boostedyaml.settings.updater.UpdaterSettings;
import me.extremall.advancedkits.libs.boostedyaml.updater.operators.Mapper;
import me.extremall.advancedkits.libs.boostedyaml.updater.operators.Relocator;
import org.jetbrains.annotations.NotNull;

public class VersionedOperations {
    public static boolean run(@NotNull Section section, @NotNull Section object, @NotNull UpdaterSettings updaterSettings, char c2) {
        Versioning versioning = updaterSettings.getVersioning();
        if (versioning == null) {
            return false;
        }
        Version version = versioning.getDocumentVersion(section, false);
        object = Objects.requireNonNull(versioning.getDocumentVersion((Section)object, true), "Version ID of the defaults cannot be null! Is it malformed or not specified?");
        int n2 = version != null ? version.compareTo((Version)object) : -1;
        if (n2 > 0 && !updaterSettings.isEnableDowngrading()) {
            throw new UnsupportedOperationException(String.format("Downgrading is not enabled (%s > %s)!", ((Version)object).asID(), version.asID()));
        }
        if (n2 == 0) {
            return true;
        }
        if (n2 < 0) {
            VersionedOperations.iterate(section, version != null ? version : versioning.getFirstVersion(), (Version)object, updaterSettings, c2);
        }
        updaterSettings.getIgnoredRoutes(((Version)object).asID(), c2).forEach(route -> section.getOptionalBlock((Route)route).ifPresent(block -> block.setIgnored(true)));
        return false;
    }

    private static void iterate(@NotNull Section section, @NotNull Version version, @NotNull Version version2, @NotNull UpdaterSettings updaterSettings, char c2) {
        version = version.copy();
        while (version.compareTo(version2) <= 0) {
            version.next();
            Relocator.apply(section, updaterSettings.getRelocations(version.asID(), c2));
            Mapper.apply(section, updaterSettings.getMappers(version.asID(), c2));
            updaterSettings.getCustomLogic(version.asID()).forEach(consumer -> consumer.accept(section.getRoot()));
        }
    }
}

