/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.utils.conversion;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import me.extremall.advancedkits.libs.boostedyaml.utils.conversion.PrimitiveConversions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListConversions {
    @NotNull
    public static Optional<List<String>> toStringList(@Nullable List<?> list) {
        return ListConversions.construct(list, object -> Optional.ofNullable(object.toString()));
    }

    @NotNull
    public static Optional<List<Integer>> toIntList(@Nullable List<?> list) {
        return ListConversions.construct(list, PrimitiveConversions::toInt);
    }

    @NotNull
    public static Optional<List<BigInteger>> toBigIntList(@Nullable List<?> list) {
        return ListConversions.construct(list, PrimitiveConversions::toBigInt);
    }

    @NotNull
    public static Optional<List<Byte>> toByteList(@Nullable List<?> list) {
        return ListConversions.construct(list, PrimitiveConversions::toByte);
    }

    @NotNull
    public static Optional<List<Long>> toLongList(@Nullable List<?> list) {
        return ListConversions.construct(list, PrimitiveConversions::toLong);
    }

    @NotNull
    public static Optional<List<Double>> toDoubleList(@Nullable List<?> list) {
        return ListConversions.construct(list, PrimitiveConversions::toDouble);
    }

    @NotNull
    public static Optional<List<Float>> toFloatList(@Nullable List<?> list) {
        return ListConversions.construct(list, PrimitiveConversions::toFloat);
    }

    @NotNull
    public static Optional<List<Short>> toShortList(@Nullable List<?> list) {
        return ListConversions.construct(list, PrimitiveConversions::toShort);
    }

    @NotNull
    public static Optional<List<Map<?, ?>>> toMapList(@Nullable List<?> list) {
        return ListConversions.construct(list, object -> {
            if (object instanceof Map) {
                return Optional.of((Map)object);
            }
            return Optional.empty();
        });
    }

    @NotNull
    private static <T> Optional<List<T>> construct(@Nullable List<?> object, @NotNull Function<Object, Optional<T>> function) {
        if (object == null) {
            return Optional.empty();
        }
        ArrayList arrayList = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (e2 == null) continue;
            function.apply(e2).ifPresent(arrayList::add);
        }
        return Optional.of(arrayList);
    }
}

