/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.fcommons;

import me.extremall.advancedkits.libs.fcommons.FeatureSupport;
import me.extremall.advancedkits.libs.fcommons.Strings;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.Nullable;

public final class Colors {
    public static final char ALT_COLOR_CHAR = '&';
    private static final CharArray ALT_COLOR_CODES = new CharArray("0123456789AaBbCcDdEeFfKkLlMmNnOoRr");
    private static final CharArray ALT_HEX_CODES = new CharArray("0123456789AaBbCcDdEeFf");
    private static final int ALT_HEX_COLOR_LENGTH = 6;
    private static final CharArray STANDARD_COLOR_CODES = new CharArray("0123456789abcdefklmnor");
    private static final CharArray STANDARD_HEX_CODES = new CharArray("0123456789abcdef");
    private static final int STANDARD_HEX_COLOR_LENGTH = 12;

    public static String colorize(@Nullable String string) {
        if (Strings.isEmpty(string) || string.indexOf(38) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 == '&' && n2 + 1 < string.length()) {
                char c3 = string.charAt(n2 + 1);
                if (c3 == '#' && FeatureSupport.HEX_CHAT_COLORS && Colors.isAltHexColor(string, n2 + 2)) {
                    stringBuilder.append('\u00a7');
                    stringBuilder.append('x');
                    Colors.translateAltHexColor(string, n2 + 2, stringBuilder);
                    n2 += 8;
                    continue;
                }
                if (ALT_COLOR_CODES.contains(c3)) {
                    stringBuilder.append('\u00a7');
                    stringBuilder.append(Character.toLowerCase(c3));
                    n2 += 2;
                    continue;
                }
            }
            stringBuilder.append(c2);
            ++n2;
        }
        return stringBuilder.toString();
    }

    private static boolean isAltHexColor(String string, int n2) {
        if (string.length() - n2 < 6) {
            return false;
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            char c2 = string.charAt(n2 + i2);
            if (ALT_HEX_CODES.contains(c2)) continue;
            return false;
        }
        return true;
    }

    private static void translateAltHexColor(String string, int n2, StringBuilder stringBuilder) {
        for (int i2 = 0; i2 < 6; ++i2) {
            char c2 = string.charAt(n2 + i2);
            stringBuilder.append('\u00a7');
            stringBuilder.append(Character.toLowerCase(c2));
        }
    }

    public static String uncolorize(@Nullable String string) {
        if (Strings.isEmpty(string) || string.indexOf(167) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 == '\u00a7' && n2 + 1 < string.length()) {
                char c3 = string.charAt(n2 + 1);
                if (c3 == 'x' && FeatureSupport.HEX_CHAT_COLORS && Colors.isStandardHexColor(string, n2 + 2)) {
                    stringBuilder.append('&');
                    stringBuilder.append('#');
                    Colors.untranslateStandardHexColor(string, n2 + 2, stringBuilder);
                    n2 += 14;
                    continue;
                }
                if (STANDARD_COLOR_CODES.contains(c3)) {
                    stringBuilder.append('&');
                    stringBuilder.append(c3);
                    n2 += 2;
                    continue;
                }
            }
            stringBuilder.append(c2);
            ++n2;
        }
        return stringBuilder.toString();
    }

    private static boolean isStandardHexColor(String string, int n2) {
        if (string.length() - n2 < 12) {
            return false;
        }
        for (int i2 = 0; i2 < 12; i2 += 2) {
            char c2 = string.charAt(n2 + i2);
            char c3 = string.charAt(n2 + i2 + 1);
            if (c2 == '\u00a7' && STANDARD_HEX_CODES.contains(c3)) continue;
            return false;
        }
        return true;
    }

    private static void untranslateStandardHexColor(String string, int n2, StringBuilder stringBuilder) {
        for (int i2 = 0; i2 < 12; i2 += 2) {
            stringBuilder.append(string.charAt(n2 + i2 + 1));
        }
    }

    public static String trimTransparentWhitespace(@Nullable String string) {
        String string2;
        String string3;
        if (Strings.isEmpty(string)) {
            return string;
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = string.length();
        boolean bl2 = false;
        for (int i2 = 0; i2 < n4; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ' ' && !bl2) continue;
            if (c2 == '\u00a7') {
                if (i2 >= n4 - 1) continue;
                ChatColor chatColor = ChatColor.getByChar((char)string.charAt(i2 + 1));
                if (chatColor != null) {
                    if (chatColor == ChatColor.STRIKETHROUGH || chatColor == ChatColor.UNDERLINE) {
                        bl2 = true;
                    } else if (chatColor == ChatColor.RESET || chatColor.isColor()) {
                        bl2 = false;
                    }
                }
                ++i2;
                continue;
            }
            if (n2 == -1) {
                n2 = i2;
            }
            n3 = i2 + 1;
        }
        if (n2 == -1) {
            return string.replace(" ", "");
        }
        String string4 = string.substring(n2, n3);
        if (n2 > 0 && !(string3 = string.substring(0, n2).replace(" ", "")).isEmpty()) {
            string4 = string3 + string4;
        }
        if (n3 < string.length() && !(string2 = string.substring(n3).replace(" ", "")).isEmpty()) {
            string4 = string4 + string2;
        }
        return string4;
    }

    public static String optimize(@Nullable String string) {
        if (Strings.isEmpty(string) || string.indexOf(167) < 0) {
            return string;
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 == '\u00a7' && n3 < n2 - 1) {
                stringBuilder3.append(c2);
                stringBuilder3.append(string.charAt(n3 + 1));
                n3 += 2;
                continue;
            }
            if (stringBuilder3.length() > 0) {
                if (!Colors.contentEquals(stringBuilder3, stringBuilder2)) {
                    stringBuilder.append((CharSequence)stringBuilder3);
                }
                stringBuilder2.setLength(0);
                stringBuilder2.append((CharSequence)stringBuilder3);
                stringBuilder3.setLength(0);
            }
            stringBuilder.append(c2);
            ++n3;
        }
        if (stringBuilder3.length() > 0) {
            stringBuilder.append((CharSequence)stringBuilder3);
        }
        return stringBuilder.toString();
    }

    private static boolean contentEquals(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (stringBuilder.length() != stringBuilder2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < stringBuilder.length(); ++i2) {
            if (stringBuilder.charAt(i2) == stringBuilder2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    static class CharArray {
        private final char[] chars;

        CharArray(String string) {
            this.chars = string.toCharArray();
        }

        boolean contains(char c2) {
            char[] cArray = this.chars;
            int n2 = this.chars.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c3 = cArray[i2];
                if (c2 != c3) continue;
                return true;
            }
            return false;
        }
    }
}

