/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.fcommons;

import java.util.HashSet;
import java.util.Set;
import me.extremall.advancedkits.libs.fcommons.FeatureSupport;
import me.extremall.advancedkits.libs.fcommons.collection.EnumLookupRegistry;
import org.bukkit.Material;
import org.jetbrains.annotations.Nullable;

public final class MaterialsHelper {
    private static final EnumLookupRegistry<Material> MATERIALS_REGISTRY = MaterialsHelper.initMaterialsRegistry();
    private static final Set<Material> AIR_MATERIALS = MaterialsHelper.getExistingMaterials("AIR", "CAVE_AIR", "VOID_AIR");

    private static EnumLookupRegistry<Material> initMaterialsRegistry() {
        EnumLookupRegistry<Material> enumLookupRegistry = EnumLookupRegistry.fromEnumValues(Material.class);
        if (FeatureSupport.LEGACY_MATERIAL_IDS) {
            for (Material material : Material.values()) {
                enumLookupRegistry.put(Integer.toString(material.getId()), material);
            }
        }
        enumLookupRegistry.putEnumIfExisting("iron bar", "IRON_FENCE");
        enumLookupRegistry.putEnumIfExisting("iron bars", "IRON_FENCE");
        enumLookupRegistry.putEnumIfExisting("glass pane", "THIN_GLASS");
        enumLookupRegistry.putEnumIfExisting("nether wart", "NETHER_STALK");
        enumLookupRegistry.putEnumIfExisting("nether warts", "NETHER_STALK");
        enumLookupRegistry.putEnumIfExisting("slab", "STEP");
        enumLookupRegistry.putEnumIfExisting("double slab", "DOUBLE_STEP");
        enumLookupRegistry.putEnumIfExisting("stone brick", "SMOOTH_BRICK");
        enumLookupRegistry.putEnumIfExisting("stone bricks", "SMOOTH_BRICK");
        enumLookupRegistry.putEnumIfExisting("stone stair", "SMOOTH_STAIRS");
        enumLookupRegistry.putEnumIfExisting("stone stairs", "SMOOTH_STAIRS");
        enumLookupRegistry.putEnumIfExisting("potato", "POTATO_ITEM");
        enumLookupRegistry.putEnumIfExisting("carrot", "CARROT_ITEM");
        enumLookupRegistry.putEnumIfExisting("brewing stand", "BREWING_STAND_ITEM");
        enumLookupRegistry.putEnumIfExisting("cauldron", "CAULDRON_ITEM");
        enumLookupRegistry.putEnumIfExisting("carrot on stick", "CARROT_STICK");
        enumLookupRegistry.putEnumIfExisting("carrot on a stick", "CARROT_STICK");
        enumLookupRegistry.putEnumIfExisting("cobblestone wall", "COBBLE_WALL");
        enumLookupRegistry.putEnumIfExisting("acacia wood stairs", "ACACIA_STAIRS");
        enumLookupRegistry.putEnumIfExisting("dark oak wood stairs", "DARK_OAK_STAIRS");
        enumLookupRegistry.putEnumIfExisting("wood slab", "WOOD_STEP");
        enumLookupRegistry.putEnumIfExisting("double wood slab", "WOOD_DOUBLE_STEP");
        enumLookupRegistry.putEnumIfExisting("repeater", "DIODE");
        enumLookupRegistry.putEnumIfExisting("piston", "PISTON_BASE");
        enumLookupRegistry.putEnumIfExisting("sticky piston", "PISTON_STICKY_BASE");
        enumLookupRegistry.putEnumIfExisting("flower pot", "FLOWER_POT_ITEM");
        enumLookupRegistry.putEnumIfExisting("wood shovel", "WOOD_SPADE");
        enumLookupRegistry.putEnumIfExisting("stone shovel", "STONE_SPADE");
        enumLookupRegistry.putEnumIfExisting("gold shovel", "GOLD_SPADE");
        enumLookupRegistry.putEnumIfExisting("iron shovel", "IRON_SPADE");
        enumLookupRegistry.putEnumIfExisting("diamond shovel", "DIAMOND_SPADE");
        enumLookupRegistry.putEnumIfExisting("steak", "COOKED_BEEF");
        enumLookupRegistry.putEnumIfExisting("cooked porkchop", "GRILLED_PORK");
        enumLookupRegistry.putEnumIfExisting("raw porkchop", "PORK");
        enumLookupRegistry.putEnumIfExisting("hardened clay", "HARD_CLAY");
        enumLookupRegistry.putEnumIfExisting("huge brown mushroom", "HUGE_MUSHROOM_1");
        enumLookupRegistry.putEnumIfExisting("huge red mushroom", "HUGE_MUSHROOM_2");
        enumLookupRegistry.putEnumIfExisting("mycelium", "MYCEL");
        enumLookupRegistry.putEnumIfExisting("poppy", "RED_ROSE");
        enumLookupRegistry.putEnumIfExisting("comparator", "REDSTONE_COMPARATOR");
        enumLookupRegistry.putEnumIfExisting("skull", "SKULL_ITEM");
        enumLookupRegistry.putEnumIfExisting("head", "SKULL_ITEM");
        enumLookupRegistry.putEnumIfExisting("redstone torch", "REDSTONE_TORCH_ON");
        enumLookupRegistry.putEnumIfExisting("redstone lamp", "REDSTONE_LAMP_OFF");
        enumLookupRegistry.putEnumIfExisting("glistering melon", "SPECKLED_MELON");
        enumLookupRegistry.putEnumIfExisting("acacia leaves", "LEAVES_2");
        enumLookupRegistry.putEnumIfExisting("acacia log", "LOG_2");
        enumLookupRegistry.putEnumIfExisting("gunpowder", "SULPHUR");
        enumLookupRegistry.putEnumIfExisting("lilypad", "WATER_LILY");
        enumLookupRegistry.putEnumIfExisting("command block", "COMMAND");
        enumLookupRegistry.putEnumIfExisting("dye", "INK_SACK");
        return enumLookupRegistry;
    }

    @Nullable
    public static Material matchMaterial(String string) {
        return (Material)MATERIALS_REGISTRY.lookup(string);
    }

    private static Set<Material> getExistingMaterials(String ... stringArray) {
        HashSet<Material> hashSet = new HashSet<Material>();
        for (String string : stringArray) {
            try {
                hashSet.add(Material.valueOf((String)string));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return hashSet;
    }

    public static boolean isAir(Material material) {
        return AIR_MATERIALS.contains(material);
    }
}

