/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.fcommons;

import java.util.ArrayList;
import java.util.Collection;
import me.extremall.advancedkits.libs.fcommons.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Strings {
    public static boolean isEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static String truncate(@Nullable String string, int n2) {
        if (string != null && string.length() > n2) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static String[] trim(String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray2[i2] = stringArray[i2].trim();
        }
        return stringArray2;
    }

    public static String[] split(@NotNull String string, @NotNull String string2) {
        return Strings.split(string, string2, 0);
    }

    public static String[] split(@NotNull String string, @NotNull String string2, int n2) {
        int n3;
        Preconditions.notNull(string, "string");
        Preconditions.notEmpty(string2, "delimiter");
        Preconditions.checkArgument(n2 >= 0, "limit cannot be negative");
        if (string.isEmpty() || n2 == 1) {
            return new String[]{string};
        }
        int n4 = string.indexOf(string2);
        if (n4 == -1) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = null;
        int n5 = 0;
        while ((n3 = string.indexOf(string2, n5)) != -1) {
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            if (n2 > 0 && arrayList.size() >= n2 - 1) break;
            arrayList.add(string.substring(n5, n3));
            n5 = n3 + string2.length();
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return new String[]{string};
        }
        arrayList.add(string.substring(n5));
        return arrayList.toArray(new String[0]);
    }

    public static String[] splitAndTrim(@NotNull String string, @NotNull String string2) {
        return Strings.splitAndTrim(string, string2, 0);
    }

    public static String[] splitAndTrim(@NotNull String stringArray, @NotNull String string, int n2) {
        stringArray = Strings.split((String)stringArray, string, n2);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = stringArray[i2].trim();
        }
        return stringArray;
    }

    public static String joinFrom(@NotNull String string, String @NotNull [] stringArray, int n2) {
        return Strings.joinRange(string, stringArray, n2, stringArray.length);
    }

    public static String joinRange(@NotNull String string, String @NotNull [] stringArray, int n2, int n3) {
        Preconditions.notNull(string, "separator");
        Preconditions.notNull(stringArray, "elements");
        Preconditions.checkArgument(n2 <= n3, "fromIndex (" + n2 + ") cannot be greater than toIndex (" + n3 + ")");
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("fromIndex (" + n2 + ") cannot be negative");
        }
        if (n3 > stringArray.length) {
            throw new ArrayIndexOutOfBoundsException("toIndex (" + n3 + ") cannot be greater than array length (" + stringArray.length + ")");
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 < n3) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(stringArray[n2]);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String stripChars(@Nullable String string, char ... cArray) {
        if (Strings.isEmpty(string) || cArray.length == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Strings.arrayContains(cArray, c2)) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static boolean arrayContains(char[] cArray, char c2) {
        for (char c3 : cArray) {
            if (c3 != c2) continue;
            return true;
        }
        return false;
    }

    public static String capitalizeFully(@Nullable String string) {
        if (Strings.isEmpty(string)) {
            return string;
        }
        string = string.toLowerCase();
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        boolean bl2 = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isWhitespace(c2)) {
                stringBuilder.append(c2);
                bl2 = true;
                continue;
            }
            if (bl2) {
                stringBuilder.append(Character.toTitleCase(c2));
                bl2 = false;
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String capitalizeFirst(@Nullable String string) {
        if (Strings.isEmpty(string)) {
            return string;
        }
        return Character.toTitleCase(string.charAt(0)) + string.substring(1);
    }

    public static boolean isWhitespace(@Nullable String string) {
        if (Strings.isEmpty(string)) {
            return true;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasSentenceEnding(@Nullable String string) {
        if (Strings.isEmpty(string)) {
            return false;
        }
        String string2 = string;
        char c2 = string2.charAt(string2.length() - 1);
        return c2 == '.' || c2 == '?' || c2 == '!';
    }

    public static boolean containsIgnoreCase(@NotNull String[] stringArray, @NotNull String string) {
        for (String string2 : stringArray) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(@NotNull Collection<String> object, @NotNull String string) {
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }
}

