/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.gson;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import me.extremall.advancedkits.libs.gson.JsonElement;
import me.extremall.advancedkits.libs.gson.JsonIOException;
import me.extremall.advancedkits.libs.gson.JsonParseException;
import me.extremall.advancedkits.libs.gson.JsonSyntaxException;
import me.extremall.advancedkits.libs.gson.internal.Streams;
import me.extremall.advancedkits.libs.gson.stream.JsonReader;
import me.extremall.advancedkits.libs.gson.stream.JsonToken;
import me.extremall.advancedkits.libs.gson.stream.MalformedJsonException;

public final class JsonParser {
    @Deprecated
    public JsonParser() {
    }

    public static JsonElement parseString(String string) {
        return JsonParser.parseReader(new StringReader(string));
    }

    public static JsonElement parseReader(Reader closeable) {
        try {
            closeable = new JsonReader((Reader)closeable);
            JsonElement jsonElement = JsonParser.parseReader((JsonReader)closeable);
            if (!jsonElement.isJsonNull() && ((JsonReader)closeable).peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return jsonElement;
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonSyntaxException(numberFormatException);
        }
    }

    public static JsonElement parseReader(JsonReader jsonReader) {
        boolean bl2 = jsonReader.isLenient();
        jsonReader.setLenient(true);
        try {
            JsonElement jsonElement = Streams.parse(jsonReader);
            return jsonElement;
        }
        catch (StackOverflowError stackOverflowError) {
            throw new JsonParseException("Failed parsing JSON source: " + jsonReader + " to Json", stackOverflowError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new JsonParseException("Failed parsing JSON source: " + jsonReader + " to Json", outOfMemoryError);
        }
        finally {
            jsonReader.setLenient(bl2);
        }
    }

    @Deprecated
    public final JsonElement parse(String string) {
        return JsonParser.parseString(string);
    }

    @Deprecated
    public final JsonElement parse(Reader reader) {
        return JsonParser.parseReader(reader);
    }

    @Deprecated
    public final JsonElement parse(JsonReader jsonReader) {
        return JsonParser.parseReader(jsonReader);
    }
}

