/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.gson.internal;

import java.io.EOFException;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import me.extremall.advancedkits.libs.gson.JsonElement;
import me.extremall.advancedkits.libs.gson.JsonIOException;
import me.extremall.advancedkits.libs.gson.JsonNull;
import me.extremall.advancedkits.libs.gson.JsonSyntaxException;
import me.extremall.advancedkits.libs.gson.internal.bind.TypeAdapters;
import me.extremall.advancedkits.libs.gson.stream.JsonReader;
import me.extremall.advancedkits.libs.gson.stream.JsonWriter;
import me.extremall.advancedkits.libs.gson.stream.MalformedJsonException;

public final class Streams {
    private Streams() {
        throw new UnsupportedOperationException();
    }

    public static JsonElement parse(JsonReader jsonReader) {
        boolean bl2 = true;
        try {
            jsonReader.peek();
            bl2 = false;
            return TypeAdapters.JSON_ELEMENT.read(jsonReader);
        }
        catch (EOFException eOFException) {
            if (bl2) {
                return JsonNull.INSTANCE;
            }
            throw new JsonSyntaxException(eOFException);
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonSyntaxException(numberFormatException);
        }
    }

    public static void write(JsonElement jsonElement, JsonWriter jsonWriter) {
        TypeAdapters.JSON_ELEMENT.write(jsonWriter, jsonElement);
    }

    public static Writer writerForAppendable(Appendable appendable) {
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        return new AppendableWriter(appendable);
    }

    static final class AppendableWriter
    extends Writer {
        private final Appendable appendable;
        private final CurrentWrite currentWrite = new CurrentWrite();

        AppendableWriter(Appendable appendable) {
            this.appendable = appendable;
        }

        @Override
        public final void write(char[] cArray, int n2, int n3) {
            this.currentWrite.setChars(cArray);
            int n4 = n2;
            this.appendable.append(this.currentWrite, n4, n4 + n3);
        }

        @Override
        public final void flush() {
        }

        @Override
        public final void close() {
        }

        @Override
        public final void write(int n2) {
            this.appendable.append((char)n2);
        }

        @Override
        public final void write(String string, int n2, int n3) {
            Objects.requireNonNull(string);
            int n4 = n2;
            this.appendable.append(string, n4, n4 + n3);
        }

        @Override
        public final Writer append(CharSequence charSequence) {
            this.appendable.append(charSequence);
            return this;
        }

        @Override
        public final Writer append(CharSequence charSequence, int n2, int n3) {
            this.appendable.append(charSequence, n2, n3);
            return this;
        }

        static class CurrentWrite
        implements CharSequence {
            private char[] chars;
            private String cachedString;

            private CurrentWrite() {
            }

            void setChars(char[] cArray) {
                this.chars = cArray;
                this.cachedString = null;
            }

            @Override
            public int length() {
                return this.chars.length;
            }

            @Override
            public char charAt(int n2) {
                return this.chars[n2];
            }

            @Override
            public CharSequence subSequence(int n2, int n3) {
                return new String(this.chars, n2, n3 - n2);
            }

            @Override
            public String toString() {
                if (this.cachedString == null) {
                    this.cachedString = new String(this.chars);
                }
                return this.cachedString;
            }
        }
    }
}

