/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.gson.stream;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class JsonWriter
implements Closeable,
Flushable {
    private static final Pattern VALID_JSON_NUMBER_PATTERN = Pattern.compile("-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][-+]?[0-9]+)?");
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private final Writer out;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String indent;
    private String separator;
    private boolean lenient;
    private boolean htmlSafe;
    private String deferredName;
    private boolean serializeNulls;

    public JsonWriter(Writer writer) {
        this.push(6);
        this.separator = ":";
        this.serializeNulls = true;
        this.out = Objects.requireNonNull(writer, "out == null");
    }

    public final void setIndent(String string) {
        if (string.length() == 0) {
            this.indent = null;
            this.separator = ":";
            return;
        }
        this.indent = string;
        this.separator = ": ";
    }

    public final void setLenient(boolean bl2) {
        this.lenient = bl2;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public final void setHtmlSafe(boolean bl2) {
        this.htmlSafe = bl2;
    }

    public final boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public final void setSerializeNulls(boolean bl2) {
        this.serializeNulls = bl2;
    }

    public final boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public JsonWriter beginArray() {
        this.writeDeferredName();
        return this.open(1, '[');
    }

    public JsonWriter endArray() {
        return this.close(1, 2, ']');
    }

    public JsonWriter beginObject() {
        this.writeDeferredName();
        return this.open(3, '{');
    }

    public JsonWriter endObject() {
        return this.close(3, 5, '}');
    }

    private JsonWriter open(int n2, char c2) {
        this.beforeValue();
        this.push(n2);
        this.out.write(c2);
        return this;
    }

    private JsonWriter close(int n2, int n3, char c2) {
        int n4 = this.peek();
        if (n4 != n3 && n4 != n2) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException("Dangling name: " + this.deferredName);
        }
        --this.stackSize;
        if (n4 == n3) {
            this.newline();
        }
        this.out.write(c2);
        return this;
    }

    private void push(int n2) {
        if (this.stackSize == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stackSize << 1);
        }
        this.stack[this.stackSize++] = n2;
    }

    private int peek() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.stack[this.stackSize - 1];
    }

    private void replaceTop(int n2) {
        this.stack[this.stackSize - 1] = n2;
    }

    public JsonWriter name(String string) {
        Objects.requireNonNull(string, "name == null");
        if (this.deferredName != null) {
            throw new IllegalStateException();
        }
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.deferredName = string;
        return this;
    }

    private void writeDeferredName() {
        if (this.deferredName != null) {
            this.beforeName();
            JsonWriter jsonWriter = this;
            jsonWriter.string(jsonWriter.deferredName);
            this.deferredName = null;
        }
    }

    public JsonWriter value(String string) {
        if (string == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.string(string);
        return this;
    }

    public JsonWriter jsonValue(String string) {
        if (string == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.append(string);
        return this;
    }

    public JsonWriter nullValue() {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue();
        this.out.write("null");
        return this;
    }

    public JsonWriter value(boolean bl2) {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(bl2 ? "true" : "false");
        return this;
    }

    public JsonWriter value(Boolean bl2) {
        if (bl2 == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(bl2 != false ? "true" : "false");
        return this;
    }

    public JsonWriter value(float f2) {
        this.writeDeferredName();
        if (!this.lenient && (Float.isNaN(f2) || Float.isInfinite(f2))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + f2);
        }
        this.beforeValue();
        this.out.append(Float.toString(f2));
        return this;
    }

    public JsonWriter value(double d2) {
        this.writeDeferredName();
        if (!this.lenient && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + d2);
        }
        this.beforeValue();
        this.out.append(Double.toString(d2));
        return this;
    }

    public JsonWriter value(long l2) {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(Long.toString(l2));
        return this;
    }

    private static boolean isTrustedNumberType(Class<? extends Number> clazz) {
        return clazz == Integer.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Byte.class || clazz == Short.class || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == AtomicInteger.class || clazz == AtomicLong.class;
    }

    public JsonWriter value(Number serializable) {
        if (serializable == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        String string = serializable.toString();
        if (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN")) {
            if (!this.lenient) {
                throw new IllegalArgumentException("Numeric values must be finite, but was " + string);
            }
        } else if (!JsonWriter.isTrustedNumberType(serializable = serializable.getClass()) && !VALID_JSON_NUMBER_PATTERN.matcher(string).matches()) {
            throw new IllegalArgumentException("String created by " + serializable + " is not a valid JSON number: " + string);
        }
        this.beforeValue();
        this.out.append(string);
        return this;
    }

    @Override
    public void flush() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.out.flush();
    }

    @Override
    public void close() {
        this.out.close();
        int n2 = this.stackSize;
        if (n2 > 1 || n2 == 1 && this.stack[n2 - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    private void string(String string) {
        String[] stringArray = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        this.out.write(34);
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            String string2;
            char c2 = string.charAt(i2);
            if (c2 < '\u0080') {
                string2 = stringArray[c2];
                if (string2 == null) {
                    continue;
                }
            } else if (c2 == '\u2028') {
                string2 = "\\u2028";
            } else {
                if (c2 != '\u2029') continue;
                string2 = "\\u2029";
            }
            if (n2 < i2) {
                this.out.write(string, n2, i2 - n2);
            }
            this.out.write(string2);
            n2 = i2 + 1;
        }
        if (n2 < n3) {
            this.out.write(string, n2, n3 - n2);
        }
        this.out.write(34);
    }

    private void newline() {
        if (this.indent == null) {
            return;
        }
        this.out.write(10);
        int n2 = this.stackSize;
        for (int i2 = 1; i2 < n2; ++i2) {
            this.out.write(this.indent);
        }
    }

    private void beforeName() {
        int n2 = this.peek();
        if (n2 == 5) {
            this.out.write(44);
        } else if (n2 != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.newline();
        this.replaceTop(4);
    }

    private void beforeValue() {
        switch (this.peek()) {
            case 7: {
                if (!this.lenient) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case 6: {
                this.replaceTop(7);
                return;
            }
            case 1: {
                this.replaceTop(2);
                this.newline();
                return;
            }
            case 2: {
                this.out.append(',');
                this.newline();
                return;
            }
            case 4: {
                this.out.append(this.separator);
                this.replaceTop(5);
                return;
            }
        }
        throw new IllegalStateException("Nesting problem.");
    }

    static {
        for (int i2 = 0; i2 <= 31; ++i2) {
            JsonWriter.REPLACEMENT_CHARS[i2] = String.format("\\u%04x", i2);
        }
        JsonWriter.REPLACEMENT_CHARS[34] = "\\\"";
        JsonWriter.REPLACEMENT_CHARS[92] = "\\\\";
        JsonWriter.REPLACEMENT_CHARS[9] = "\\t";
        JsonWriter.REPLACEMENT_CHARS[8] = "\\b";
        JsonWriter.REPLACEMENT_CHARS[10] = "\\n";
        JsonWriter.REPLACEMENT_CHARS[13] = "\\r";
        JsonWriter.REPLACEMENT_CHARS[12] = "\\f";
        String[] stringArray = (String[])REPLACEMENT_CHARS.clone();
        HTML_SAFE_REPLACEMENT_CHARS = stringArray;
        stringArray[60] = "\\u003c";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[62] = "\\u003e";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[38] = "\\u0026";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[61] = "\\u003d";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[39] = "\\u0027";
    }
}

