/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.hikari.hikari;

import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import me.extremall.advancedkits.libs.hikari.hikari.HikariConfig;
import me.extremall.advancedkits.libs.hikari.hikari.HikariConfigMXBean;
import me.extremall.advancedkits.libs.hikari.hikari.HikariPoolMXBean;
import me.extremall.advancedkits.libs.hikari.hikari.metrics.MetricsTrackerFactory;
import me.extremall.advancedkits.libs.hikari.hikari.pool.HikariPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariDataSource
extends HikariConfig
implements Closeable,
DataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariDataSource.class);
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final HikariPool fastPathPool;
    private volatile HikariPool pool;

    public HikariDataSource() {
        this.fastPathPool = null;
    }

    public HikariDataSource(HikariConfig hikariConfig) {
        hikariConfig.validate();
        hikariConfig.copyStateTo(this);
        LOGGER.info("{} - Starting...", (Object)hikariConfig.getPoolName());
        HikariDataSource hikariDataSource = this;
        hikariDataSource.pool = hikariDataSource.fastPathPool = new HikariPool(this);
        LOGGER.info("{} - Start completed.", (Object)hikariConfig.getPoolName());
        this.seal();
    }

    @Override
    public Connection getConnection() {
        if (this.isClosed()) {
            throw new SQLException("HikariDataSource " + this + " has been closed.");
        }
        if (this.fastPathPool != null) {
            return this.fastPathPool.getConnection();
        }
        Object object = this.pool;
        if (object == null) {
            HikariDataSource hikariDataSource = this;
            synchronized (hikariDataSource) {
                object = this.pool;
                if (object == null) {
                    this.validate();
                    LOGGER.info("{} - Starting...", (Object)this.getPoolName());
                    try {
                        object = new HikariPool(this);
                        this.pool = object;
                        this.seal();
                    }
                    catch (HikariPool.PoolInitializationException poolInitializationException) {
                        object = poolInitializationException;
                        if (poolInitializationException.getCause() instanceof SQLException) {
                            throw (SQLException)((Throwable)object).getCause();
                        }
                        throw object;
                    }
                    LOGGER.info("{} - Start completed.", (Object)this.getPoolName());
                }
            }
        }
        return ((HikariPool)object).getConnection();
    }

    @Override
    public Connection getConnection(String string, String string2) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PrintWriter getLogWriter() {
        HikariPool hikariPool = this.pool;
        if (hikariPool != null) {
            return hikariPool.getUnwrappedDataSource().getLogWriter();
        }
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        HikariPool hikariPool = this.pool;
        if (hikariPool != null) {
            hikariPool.getUnwrappedDataSource().setLogWriter(printWriter);
        }
    }

    @Override
    public void setLoginTimeout(int n2) {
        HikariPool hikariPool = this.pool;
        if (hikariPool != null) {
            hikariPool.getUnwrappedDataSource().setLoginTimeout(n2);
        }
    }

    @Override
    public int getLoginTimeout() {
        HikariPool hikariPool = this.pool;
        if (hikariPool != null) {
            return hikariPool.getUnwrappedDataSource().getLoginTimeout();
        }
        return 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return (T)this;
        }
        Object object = this.pool;
        if (object != null) {
            if (clazz.isInstance(object = ((HikariPool)object).getUnwrappedDataSource())) {
                return (T)object;
            }
            if (object != null) {
                return object.unwrap(clazz);
            }
        }
        throw new SQLException("Wrapped DataSource is not an instance of " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        if (clazz.isInstance(this)) {
            return true;
        }
        Object object = this.pool;
        if (object != null) {
            if (clazz.isInstance(object = ((HikariPool)object).getUnwrappedDataSource())) {
                return true;
            }
            if (object != null) {
                return object.isWrapperFor(clazz);
            }
        }
        return false;
    }

    @Override
    public void setMetricRegistry(Object object) {
        boolean bl2 = this.getMetricRegistry() != null;
        super.setMetricRegistry(object);
        object = this.pool;
        if (object != null) {
            if (bl2) {
                throw new IllegalStateException("MetricRegistry can only be set one time");
            }
            ((HikariPool)object).setMetricRegistry(super.getMetricRegistry());
        }
    }

    @Override
    public void setMetricsTrackerFactory(MetricsTrackerFactory object) {
        boolean bl2 = this.getMetricsTrackerFactory() != null;
        super.setMetricsTrackerFactory((MetricsTrackerFactory)object);
        object = this.pool;
        if (object != null) {
            if (bl2) {
                throw new IllegalStateException("MetricsTrackerFactory can only be set one time");
            }
            ((HikariPool)object).setMetricsTrackerFactory(super.getMetricsTrackerFactory());
        }
    }

    @Override
    public void setHealthCheckRegistry(Object object) {
        boolean bl2 = this.getHealthCheckRegistry() != null;
        super.setHealthCheckRegistry(object);
        object = this.pool;
        if (object != null) {
            if (bl2) {
                throw new IllegalStateException("HealthCheckRegistry can only be set one time");
            }
            ((HikariPool)object).setHealthCheckRegistry(super.getHealthCheckRegistry());
        }
    }

    public boolean isRunning() {
        return this.pool != null && this.pool.poolState == 0;
    }

    public HikariPoolMXBean getHikariPoolMXBean() {
        return this.pool;
    }

    public HikariConfigMXBean getHikariConfigMXBean() {
        return this;
    }

    public void evictConnection(Connection connection) {
        HikariPool hikariPool;
        if (!this.isClosed() && (hikariPool = this.pool) != null && connection.getClass().getName().startsWith("me.extremall.advancedkits.libs.hikari.hikari")) {
            hikariPool.evictConnection(connection);
        }
    }

    @Override
    public void close() {
        if (this.isShutdown.getAndSet(true)) {
            return;
        }
        HikariPool hikariPool = this.pool;
        if (hikariPool != null) {
            try {
                LOGGER.info("{} - Shutdown initiated...", (Object)this.getPoolName());
                hikariPool.shutdown();
                LOGGER.info("{} - Shutdown completed.", (Object)this.getPoolName());
                return;
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn("{} - Interrupted during closing", (Object)this.getPoolName(), (Object)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isClosed() {
        return this.isShutdown.get();
    }

    public String toString() {
        return "HikariDataSource (" + this.pool + ")";
    }
}

