/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.hikari.hikari.pool;

import java.sql.Connection;
import java.sql.Statement;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import me.extremall.advancedkits.libs.hikari.hikari.pool.HikariPool;
import me.extremall.advancedkits.libs.hikari.hikari.pool.PoolBase;
import me.extremall.advancedkits.libs.hikari.hikari.pool.ProxyConnection;
import me.extremall.advancedkits.libs.hikari.hikari.pool.ProxyFactory;
import me.extremall.advancedkits.libs.hikari.hikari.pool.ProxyLeakTask;
import me.extremall.advancedkits.libs.hikari.hikari.util.ClockSource;
import me.extremall.advancedkits.libs.hikari.hikari.util.ConcurrentBag;
import me.extremall.advancedkits.libs.hikari.hikari.util.FastList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PoolEntry
implements ConcurrentBag.IConcurrentBagEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoolEntry.class);
    private static final AtomicIntegerFieldUpdater<PoolEntry> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(PoolEntry.class, "state");
    Connection connection;
    long lastAccessed;
    long lastBorrowed;
    private volatile int state = 0;
    private volatile boolean evict;
    private volatile ScheduledFuture<?> endOfLife;
    private volatile ScheduledFuture<?> keepalive;
    private final FastList<Statement> openStatements;
    private final HikariPool hikariPool;
    private final boolean isReadOnly;
    private final boolean isAutoCommit;

    PoolEntry(Connection connection, PoolBase poolBase, boolean bl2, boolean bl3) {
        this.connection = connection;
        this.hikariPool = (HikariPool)poolBase;
        this.isReadOnly = bl2;
        this.isAutoCommit = bl3;
        this.lastAccessed = ClockSource.currentTime();
        this.openStatements = new FastList(Statement.class, 16);
    }

    final void recycle(long l2) {
        if (this.connection != null) {
            this.lastAccessed = l2;
            this.hikariPool.recycle(this);
        }
    }

    final void setFutureEol(ScheduledFuture<?> scheduledFuture) {
        this.endOfLife = scheduledFuture;
    }

    public final void setKeepalive(ScheduledFuture<?> scheduledFuture) {
        this.keepalive = scheduledFuture;
    }

    final Connection createProxyConnection(ProxyLeakTask proxyLeakTask, long l2) {
        PoolEntry poolEntry = this;
        return ProxyFactory.getProxyConnection(poolEntry, poolEntry.connection, this.openStatements, proxyLeakTask, l2, this.isReadOnly, this.isAutoCommit);
    }

    final void resetConnectionState(ProxyConnection proxyConnection, int n2) {
        this.hikariPool.resetConnectionState(this.connection, proxyConnection, n2);
    }

    final String getPoolName() {
        return this.hikariPool.toString();
    }

    final boolean isMarkedEvicted() {
        return this.evict;
    }

    final void markEvicted() {
        this.evict = true;
    }

    final void evict(String string) {
        this.hikariPool.closeConnection(this, string);
    }

    final long getMillisSinceBorrowed() {
        return ClockSource.elapsedMillis(this.lastBorrowed);
    }

    final PoolBase getPoolBase() {
        return this.hikariPool;
    }

    public final String toString() {
        long l2 = ClockSource.currentTime();
        return this.connection + ", accessed " + ClockSource.elapsedDisplayString(this.lastAccessed, l2) + " ago, " + this.stateToString();
    }

    @Override
    public final int getState() {
        return stateUpdater.get(this);
    }

    @Override
    public final boolean compareAndSet(int n2, int n3) {
        return stateUpdater.compareAndSet(this, n2, n3);
    }

    @Override
    public final void setState(int n2) {
        stateUpdater.set(this, n2);
    }

    final Connection close() {
        ScheduledFuture<?> scheduledFuture = this.endOfLife;
        if (scheduledFuture != null && !scheduledFuture.isDone() && !scheduledFuture.cancel(false)) {
            LOGGER.warn("{} - maxLifeTime expiration task cancellation unexpectedly returned false for connection {}", (Object)this.getPoolName(), (Object)this.connection);
        }
        if ((scheduledFuture = this.keepalive) != null && !scheduledFuture.isDone() && !scheduledFuture.cancel(false)) {
            LOGGER.warn("{} - keepalive task cancellation unexpectedly returned false for connection {}", (Object)this.getPoolName(), (Object)this.connection);
        }
        scheduledFuture = this.connection;
        this.connection = null;
        this.endOfLife = null;
        this.keepalive = null;
        return scheduledFuture;
    }

    private String stateToString() {
        switch (this.state) {
            case 1: {
                return "IN_USE";
            }
            case 0: {
                return "NOT_IN_USE";
            }
            case -1: {
                return "REMOVED";
            }
            case -2: {
                return "RESERVED";
            }
        }
        return "Invalid";
    }
}

