/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.hikari.hikari.util;

import java.util.concurrent.TimeUnit;

public interface ClockSource {
    public static final ClockSource CLOCK = Factory.access$000();
    public static final TimeUnit[] TIMEUNITS_DESCENDING = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS};
    public static final String[] TIMEUNIT_DISPLAY_VALUES = new String[]{"ns", "\u00b5s", "ms", "s", "m", "h", "d"};

    public static long currentTime() {
        return CLOCK.currentTime0();
    }

    public long currentTime0();

    public static long toMillis(long l2) {
        return CLOCK.toMillis0(l2);
    }

    public long toMillis0(long var1);

    public static long toNanos(long l2) {
        return CLOCK.toNanos0(l2);
    }

    public long toNanos0(long var1);

    public static long elapsedMillis(long l2) {
        return CLOCK.elapsedMillis0(l2);
    }

    public long elapsedMillis0(long var1);

    public static long elapsedMillis(long l2, long l3) {
        return CLOCK.elapsedMillis0(l2, l3);
    }

    public long elapsedMillis0(long var1, long var3);

    public static long elapsedNanos(long l2) {
        return CLOCK.elapsedNanos0(l2);
    }

    public long elapsedNanos0(long var1);

    public static long elapsedNanos(long l2, long l3) {
        return CLOCK.elapsedNanos0(l2, l3);
    }

    public long elapsedNanos0(long var1, long var3);

    public static long plusMillis(long l2, long l3) {
        return CLOCK.plusMillis0(l2, l3);
    }

    public long plusMillis0(long var1, long var3);

    public static TimeUnit getSourceTimeUnit() {
        return CLOCK.getSourceTimeUnit0();
    }

    public TimeUnit getSourceTimeUnit0();

    public static String elapsedDisplayString(long l2, long l3) {
        return CLOCK.elapsedDisplayString0(l2, l3);
    }

    default public String elapsedDisplayString0(long l2, long l3) {
        long l4 = this.elapsedNanos0(l2, l3);
        StringBuilder stringBuilder = new StringBuilder(l4 < 0L ? "-" : "");
        l4 = Math.abs(l4);
        TimeUnit[] timeUnitArray = TIMEUNITS_DESCENDING;
        int n2 = TIMEUNITS_DESCENDING.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TimeUnit timeUnit = timeUnitArray[i2];
            long l5 = timeUnit.convert(l4, TimeUnit.NANOSECONDS);
            if (l5 <= 0L) continue;
            stringBuilder.append(l5).append(TIMEUNIT_DISPLAY_VALUES[timeUnit.ordinal()]);
            l4 -= TimeUnit.NANOSECONDS.convert(l5, timeUnit);
        }
        return stringBuilder.toString();
    }

    public static class NanosecondClockSource
    implements ClockSource {
        @Override
        public long currentTime0() {
            return System.nanoTime();
        }

        @Override
        public long toMillis0(long l2) {
            return TimeUnit.NANOSECONDS.toMillis(l2);
        }

        @Override
        public long toNanos0(long l2) {
            return l2;
        }

        @Override
        public long elapsedMillis0(long l2) {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
        }

        @Override
        public long elapsedMillis0(long l2, long l3) {
            return TimeUnit.NANOSECONDS.toMillis(l3 - l2);
        }

        @Override
        public long elapsedNanos0(long l2) {
            return System.nanoTime() - l2;
        }

        @Override
        public long elapsedNanos0(long l2, long l3) {
            return l3 - l2;
        }

        @Override
        public long plusMillis0(long l2, long l3) {
            return l2 + TimeUnit.MILLISECONDS.toNanos(l3);
        }

        @Override
        public TimeUnit getSourceTimeUnit0() {
            return TimeUnit.NANOSECONDS;
        }
    }

    public static final class MillisecondClockSource
    implements ClockSource {
        @Override
        public final long currentTime0() {
            return System.currentTimeMillis();
        }

        @Override
        public final long elapsedMillis0(long l2) {
            return System.currentTimeMillis() - l2;
        }

        @Override
        public final long elapsedMillis0(long l2, long l3) {
            return l3 - l2;
        }

        @Override
        public final long elapsedNanos0(long l2) {
            return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis() - l2);
        }

        @Override
        public final long elapsedNanos0(long l2, long l3) {
            return TimeUnit.MILLISECONDS.toNanos(l3 - l2);
        }

        @Override
        public final long toMillis0(long l2) {
            return l2;
        }

        @Override
        public final long toNanos0(long l2) {
            return TimeUnit.MILLISECONDS.toNanos(l2);
        }

        @Override
        public final long plusMillis0(long l2, long l3) {
            return l2 + l3;
        }

        @Override
        public final TimeUnit getSourceTimeUnit0() {
            return TimeUnit.MILLISECONDS;
        }
    }

    public static class Factory {
        private static ClockSource create() {
            String string = System.getProperty("os.name");
            if ("Mac OS X".equals(string)) {
                return new MillisecondClockSource();
            }
            return new NanosecondClockSource();
        }

        static /* synthetic */ ClockSource access$000() {
            return Factory.create();
        }
    }
}

