/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.key;

import java.util.Comparator;
import java.util.OptionalInt;
import java.util.stream.Stream;
import me.extremall.advancedkits.libs.kyori.adventure.key.KeyImpl;
import me.extremall.advancedkits.libs.kyori.adventure.key.KeyPattern;
import me.extremall.advancedkits.libs.kyori.adventure.key.Keyed;
import me.extremall.advancedkits.libs.kyori.adventure.key.Namespaced;
import me.extremall.advancedkits.libs.kyori.examination.Examinable;
import me.extremall.advancedkits.libs.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Key
extends Comparable<Key>,
Keyed,
Namespaced,
Examinable {
    public static final String MINECRAFT_NAMESPACE = "minecraft";
    public static final char DEFAULT_SEPARATOR = ':';

    @NotNull
    public static Key key(@NotNull @KeyPattern String string) {
        return Key.key(string, ':');
    }

    @NotNull
    public static Key key(@NotNull String string, char c2) {
        int n2 = string.indexOf(c2);
        c2 = (char)n2;
        String string2 = n2 > 0 ? string.substring(0, c2) : MINECRAFT_NAMESPACE;
        string = c2 >= '\u0000' ? string.substring(c2 + '\u0001') : string;
        return Key.key(string2, string);
    }

    @NotNull
    public static Key key(@NotNull Namespaced namespaced, @NotNull @KeyPattern.Value String string) {
        return Key.key(namespaced.namespace(), string);
    }

    @NotNull
    public static Key key(@NotNull @KeyPattern.Namespace String string, @NotNull @KeyPattern.Value String string2) {
        return new KeyImpl(string, string2);
    }

    @NotNull
    public static Comparator<? super Key> comparator() {
        return KeyImpl.COMPARATOR;
    }

    public static boolean parseable(@Nullable String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.indexOf(58);
        String string2 = n2 > 0 ? string.substring(0, n2) : MINECRAFT_NAMESPACE;
        String string3 = string = n2 >= 0 ? string.substring(n2 + 1) : string;
        return Key.parseableNamespace(string2) && Key.parseableValue(string);
    }

    public static boolean parseableNamespace(@NotNull String string) {
        return !Key.checkNamespace(string).isPresent();
    }

    @NotNull
    public static OptionalInt checkNamespace(@NotNull String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Key.allowedInNamespace(string.charAt(i2))) continue;
            return OptionalInt.of(i2);
        }
        return OptionalInt.empty();
    }

    public static boolean parseableValue(@NotNull String string) {
        return !Key.checkValue(string).isPresent();
    }

    @NotNull
    public static OptionalInt checkValue(@NotNull String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Key.allowedInValue(string.charAt(i2))) continue;
            return OptionalInt.of(i2);
        }
        return OptionalInt.empty();
    }

    public static boolean allowedInNamespace(char c2) {
        return KeyImpl.allowedInNamespace(c2);
    }

    public static boolean allowedInValue(char c2) {
        return KeyImpl.allowedInValue(c2);
    }

    @Override
    @NotNull
    @KeyPattern.Namespace
    public String namespace();

    @NotNull
    @KeyPattern.Value
    public String value();

    @NotNull
    public String asString();

    @NotNull
    default public String asMinimalString() {
        if (this.namespace().equals(MINECRAFT_NAMESPACE)) {
            return this.value();
        }
        return this.asString();
    }

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("namespace", this.namespace()), ExaminableProperty.of("value", this.value()));
    }

    @Override
    default public int compareTo(@NotNull Key key) {
        return Key.comparator().compare(this, key);
    }

    @Override
    @NotNull
    default public Key key() {
        return this;
    }
}

