/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.nbt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.AbstractBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.BinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.BinaryTagType;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.BinaryTagTypes;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ListBinaryTag;
import me.extremall.advancedkits.libs.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@Debug.Renderer(text="\"ListBinaryTag[type=\" + this.type.toString() + \"]\"", childrenArray="this.tags.toArray()", hasChildren="!this.tags.isEmpty()")
final class ListBinaryTagImpl
extends AbstractBinaryTag
implements ListBinaryTag {
    static final ListBinaryTag EMPTY = new ListBinaryTagImpl(BinaryTagTypes.END, Collections.emptyList());
    private final List<BinaryTag> tags;
    private final BinaryTagType<? extends BinaryTag> elementType;
    private final int hashCode;

    ListBinaryTagImpl(BinaryTagType<? extends BinaryTag> binaryTagType, List<BinaryTag> list) {
        this.tags = Collections.unmodifiableList(list);
        this.elementType = binaryTagType;
        this.hashCode = list.hashCode();
    }

    @Override
    @NotNull
    public final BinaryTagType<? extends BinaryTag> elementType() {
        return this.elementType;
    }

    @Override
    public final int size() {
        return this.tags.size();
    }

    @Override
    @NotNull
    public final BinaryTag get(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
        return this.tags.get(n2);
    }

    @Override
    @NotNull
    public final ListBinaryTag set(int n2, @NotNull BinaryTag binaryTag, @Nullable Consumer<? super BinaryTag> consumer) {
        return this.edit(list -> {
            BinaryTag binaryTag2 = list.set(n2, binaryTag);
            if (consumer != null) {
                consumer.accept(binaryTag2);
            }
        }, binaryTag.type());
    }

    @Override
    @NotNull
    public final ListBinaryTag remove(int n2, @Nullable Consumer<? super BinaryTag> consumer) {
        return this.edit(list -> {
            BinaryTag binaryTag = (BinaryTag)list.remove(n2);
            if (consumer != null) {
                consumer.accept(binaryTag);
            }
        }, null);
    }

    @Override
    @NotNull
    public final ListBinaryTag add(BinaryTag binaryTag) {
        ListBinaryTagImpl.noAddEnd(binaryTag);
        if (this.elementType != BinaryTagTypes.END) {
            ListBinaryTagImpl.mustBeSameType(binaryTag, this.elementType);
        }
        return this.edit(list -> list.add(binaryTag), binaryTag.type());
    }

    @Override
    @NotNull
    public final ListBinaryTag add(Iterable<? extends BinaryTag> iterable) {
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return this;
        }
        BinaryTagType<?> binaryTagType = ListBinaryTagImpl.mustBeSameType(iterable);
        return this.edit(list -> {
            iterable = iterable.iterator();
            while (iterable.hasNext()) {
                BinaryTag binaryTag = (BinaryTag)iterable.next();
                list.add(binaryTag);
            }
        }, binaryTagType);
    }

    static void noAddEnd(BinaryTag binaryTag) {
        if (binaryTag.type() == BinaryTagTypes.END) {
            throw new IllegalArgumentException(String.format("Cannot add a %s to a %s", BinaryTagTypes.END, BinaryTagTypes.LIST));
        }
    }

    static BinaryTagType<?> mustBeSameType(Iterable<? extends BinaryTag> object) {
        BinaryTagType<? extends BinaryTag> binaryTagType = null;
        object = object.iterator();
        while (object.hasNext()) {
            BinaryTag binaryTag = (BinaryTag)object.next();
            if (binaryTagType == null) {
                binaryTagType = binaryTag.type();
                continue;
            }
            ListBinaryTagImpl.mustBeSameType(binaryTag, binaryTagType);
        }
        return binaryTagType;
    }

    static void mustBeSameType(BinaryTag binaryTag, BinaryTagType<? extends BinaryTag> binaryTagType) {
        if (binaryTag.type() != binaryTagType) {
            throw new IllegalArgumentException(String.format("Trying to add tag of type %s to list of %s", binaryTag.type(), binaryTagType));
        }
    }

    private ListBinaryTag edit(Consumer<List<BinaryTag>> binaryTagType, @Nullable BinaryTagType<? extends BinaryTag> binaryTagType2) {
        ArrayList<BinaryTag> arrayList = new ArrayList<BinaryTag>(this.tags);
        binaryTagType.accept((BinaryTag)((Object)arrayList));
        binaryTagType = this.elementType;
        if (binaryTagType2 != null && binaryTagType == BinaryTagTypes.END) {
            binaryTagType = binaryTagType2;
        }
        return new ListBinaryTagImpl(binaryTagType, arrayList);
    }

    @Override
    @NotNull
    public final Stream<BinaryTag> stream() {
        return this.tags.stream();
    }

    @Override
    public final Iterator<BinaryTag> iterator() {
        final Iterator<BinaryTag> iterator = this.tags.iterator();
        return new Iterator<BinaryTag>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public BinaryTag next() {
                return (BinaryTag)iterator.next();
            }

            @Override
            public void forEachRemaining(Consumer<? super BinaryTag> consumer) {
                iterator.forEachRemaining(consumer);
            }
        };
    }

    @Override
    public final void forEach(Consumer<? super BinaryTag> consumer) {
        this.tags.forEach(consumer);
    }

    @Override
    public final Spliterator<BinaryTag> spliterator() {
        return Spliterators.spliterator(this.tags, 1040);
    }

    public final boolean equals(Object object) {
        return this == object || object instanceof ListBinaryTagImpl && this.tags.equals(((ListBinaryTagImpl)object).tags);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("tags", this.tags), ExaminableProperty.of("type", this.elementType));
    }
}

