/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.nbt;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.BinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.BinaryTagType;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.BinaryTagTypes;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ByteArrayBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ByteArrayBinaryTagImpl;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ByteBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.CompoundBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.DoubleBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.FloatBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.IntArrayBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.IntArrayBinaryTagImpl;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.IntBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ListBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.LongArrayBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.LongArrayBinaryTagImpl;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.LongBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ShortBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.StringBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.Tokens;

final class TagStringWriter
implements AutoCloseable {
    private final Appendable out;
    private final String indent;
    private int level;
    private boolean needsSeparator;
    private boolean legacy;

    TagStringWriter(Appendable appendable, String string) {
        this.out = appendable;
        this.indent = string;
    }

    public final TagStringWriter legacy(boolean bl2) {
        this.legacy = bl2;
        return this;
    }

    public final TagStringWriter writeTag(BinaryTag binaryTag) {
        BinaryTagType<? extends BinaryTag> binaryTagType = binaryTag.type();
        if (binaryTagType == BinaryTagTypes.COMPOUND) {
            return this.writeCompound((CompoundBinaryTag)binaryTag);
        }
        if (binaryTagType == BinaryTagTypes.LIST) {
            return this.writeList((ListBinaryTag)binaryTag);
        }
        if (binaryTagType == BinaryTagTypes.BYTE_ARRAY) {
            return this.writeByteArray((ByteArrayBinaryTag)binaryTag);
        }
        if (binaryTagType == BinaryTagTypes.INT_ARRAY) {
            return this.writeIntArray((IntArrayBinaryTag)binaryTag);
        }
        if (binaryTagType == BinaryTagTypes.LONG_ARRAY) {
            return this.writeLongArray((LongArrayBinaryTag)binaryTag);
        }
        if (binaryTagType == BinaryTagTypes.STRING) {
            return this.value(((StringBinaryTag)binaryTag).value(), '\u0000');
        }
        if (binaryTagType == BinaryTagTypes.BYTE) {
            return this.value(Byte.toString(((ByteBinaryTag)binaryTag).value()), 'b');
        }
        if (binaryTagType == BinaryTagTypes.SHORT) {
            return this.value(Short.toString(((ShortBinaryTag)binaryTag).value()), 's');
        }
        if (binaryTagType == BinaryTagTypes.INT) {
            return this.value(Integer.toString(((IntBinaryTag)binaryTag).value()), 'i');
        }
        if (binaryTagType == BinaryTagTypes.LONG) {
            return this.value(Long.toString(((LongBinaryTag)binaryTag).value()), Character.toUpperCase('l'));
        }
        if (binaryTagType == BinaryTagTypes.FLOAT) {
            return this.value(Float.toString(((FloatBinaryTag)binaryTag).value()), 'f');
        }
        if (binaryTagType == BinaryTagTypes.DOUBLE) {
            return this.value(Double.toString(((DoubleBinaryTag)binaryTag).value()), 'd');
        }
        throw new IOException("Unknown tag type: " + binaryTagType);
    }

    private TagStringWriter writeCompound(CompoundBinaryTag object) {
        this.beginCompound();
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            this.key((String)entry.getKey());
            this.writeTag((BinaryTag)entry.getValue());
        }
        this.endCompound();
        return this;
    }

    private TagStringWriter writeList(ListBinaryTag object) {
        this.beginList();
        int n2 = 0;
        boolean bl2 = this.prettyPrinting() && this.breakListElement(object.elementType());
        object = object.iterator();
        while (object.hasNext()) {
            BinaryTag binaryTag = (BinaryTag)object.next();
            this.printAndResetSeparator(!bl2);
            if (bl2) {
                this.newlineIndent();
            }
            if (this.legacy) {
                this.out.append(String.valueOf(n2++));
                this.appendSeparator(':');
            }
            this.writeTag(binaryTag);
        }
        this.endList(bl2);
        return this;
    }

    private TagStringWriter writeByteArray(ByteArrayBinaryTag object) {
        if (this.legacy) {
            throw new IOException("Legacy Mojangson only supports integer arrays!");
        }
        this.beginArray('b');
        char c2 = Character.toUpperCase('b');
        object = ByteArrayBinaryTagImpl.value((ByteArrayBinaryTag)object);
        int n2 = ((Object)object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.printAndResetSeparator(true);
            this.value(Byte.toString((byte)object[i2]), c2);
        }
        this.endArray();
        return this;
    }

    private TagStringWriter writeIntArray(IntArrayBinaryTag object) {
        if (this.legacy) {
            this.beginList();
        } else {
            this.beginArray('i');
        }
        object = IntArrayBinaryTagImpl.value((IntArrayBinaryTag)object);
        int n2 = ((Object)object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.printAndResetSeparator(true);
            this.value(Integer.toString((int)object[i2]), 'i');
        }
        this.endArray();
        return this;
    }

    private TagStringWriter writeLongArray(LongArrayBinaryTag object) {
        if (this.legacy) {
            throw new IOException("Legacy Mojangson only supports integer arrays!");
        }
        this.beginArray('l');
        object = LongArrayBinaryTagImpl.value((LongArrayBinaryTag)object);
        int n2 = ((Object)object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.printAndResetSeparator(true);
            this.value(Long.toString((long)object[i2]), 'l');
        }
        this.endArray();
        return this;
    }

    public final TagStringWriter beginCompound() {
        this.printAndResetSeparator(false);
        ++this.level;
        this.out.append('{');
        return this;
    }

    public final TagStringWriter endCompound() {
        --this.level;
        this.newlineIndent();
        this.out.append('}');
        this.needsSeparator = true;
        return this;
    }

    public final TagStringWriter key(String string) {
        this.printAndResetSeparator(false);
        this.newlineIndent();
        this.writeMaybeQuoted(string, false);
        this.appendSeparator(':');
        return this;
    }

    public final TagStringWriter value(String string, char c2) {
        if (c2 == '\u0000') {
            this.writeMaybeQuoted(string, true);
        } else {
            this.out.append(string);
            if (c2 != 'i') {
                this.out.append(c2);
            }
        }
        this.needsSeparator = true;
        return this;
    }

    public final TagStringWriter beginList() {
        this.printAndResetSeparator(false);
        ++this.level;
        this.out.append('[');
        return this;
    }

    public final TagStringWriter endList(boolean bl2) {
        --this.level;
        if (bl2) {
            this.newlineIndent();
        }
        this.out.append(']');
        this.needsSeparator = true;
        return this;
    }

    private TagStringWriter beginArray(char c2) {
        this.beginList().out.append(Character.toUpperCase(c2)).append(';');
        if (this.prettyPrinting()) {
            this.out.append(' ');
        }
        return this;
    }

    private TagStringWriter endArray() {
        return this.endList(false);
    }

    private void writeMaybeQuoted(String string, boolean bl2) {
        if (!bl2) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (Tokens.id(string.charAt(i2))) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            this.out.append('\"');
            this.out.append(TagStringWriter.escape(string, '\"'));
            this.out.append('\"');
            return;
        }
        this.out.append(string);
    }

    private static String escape(String string, char c2) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            if (c3 == c2 || c3 == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c3);
        }
        return stringBuilder.toString();
    }

    private void printAndResetSeparator(boolean bl2) {
        if (this.needsSeparator) {
            this.out.append(',');
            if (bl2 && this.prettyPrinting()) {
                this.out.append(' ');
            }
            this.needsSeparator = false;
        }
    }

    private boolean breakListElement(BinaryTagType<?> binaryTagType) {
        return binaryTagType == BinaryTagTypes.COMPOUND || binaryTagType == BinaryTagTypes.LIST || binaryTagType == BinaryTagTypes.BYTE_ARRAY || binaryTagType == BinaryTagTypes.INT_ARRAY || binaryTagType == BinaryTagTypes.LONG_ARRAY;
    }

    private boolean prettyPrinting() {
        return this.indent.length() > 0;
    }

    private void newlineIndent() {
        if (this.prettyPrinting()) {
            this.out.append(Tokens.NEWLINE);
            for (int i2 = 0; i2 < this.level; ++i2) {
                this.out.append(this.indent);
            }
        }
    }

    private Appendable appendSeparator(char c2) {
        this.out.append(c2);
        if (this.prettyPrinting()) {
            this.out.append(' ');
        }
        return this.out;
    }

    @Override
    public final void close() {
        if (this.level != 0) {
            throw new IllegalStateException("Document finished with unbalanced start and end objects");
        }
        if (this.out instanceof Writer) {
            ((Writer)this.out).flush();
        }
    }
}

