/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.extremall.advancedkits.libs.kyori.adventure.internal.Internals;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.ComponentLike;
import me.extremall.advancedkits.libs.kyori.adventure.text.JoinConfiguration;
import me.extremall.advancedkits.libs.kyori.adventure.text.TextComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.Style;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.StyleSetter;
import me.extremall.advancedkits.libs.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JoinConfigurationImpl
implements JoinConfiguration {
    static final Function<ComponentLike, Component> DEFAULT_CONVERTOR = ComponentLike::asComponent;
    static final Predicate<ComponentLike> DEFAULT_PREDICATE = componentLike -> true;
    static final JoinConfigurationImpl NULL = new JoinConfigurationImpl();
    static final JoinConfiguration STANDARD_NEW_LINES = JoinConfiguration.separator(Component.newline());
    static final JoinConfiguration STANDARD_SPACES = JoinConfiguration.separator(Component.space());
    static final JoinConfiguration STANDARD_COMMA_SEPARATED = JoinConfiguration.separator(Component.text(","));
    static final JoinConfiguration STANDARD_COMMA_SPACE_SEPARATED = JoinConfiguration.separator(Component.text(", "));
    static final JoinConfiguration STANDARD_ARRAY_LIKE = (JoinConfiguration)JoinConfiguration.builder().separator(Component.text(", ")).prefix(Component.text("[")).suffix(Component.text("]")).build();
    private final Component prefix;
    private final Component suffix;
    private final Component separator;
    private final Component lastSeparator;
    private final Component lastSeparatorIfSerial;
    private final Function<ComponentLike, Component> convertor;
    private final Predicate<ComponentLike> predicate;
    private final Style rootStyle;

    private JoinConfigurationImpl() {
        this.prefix = null;
        this.suffix = null;
        this.separator = null;
        this.lastSeparator = null;
        this.lastSeparatorIfSerial = null;
        this.convertor = DEFAULT_CONVERTOR;
        this.predicate = DEFAULT_PREDICATE;
        this.rootStyle = Style.empty();
    }

    private JoinConfigurationImpl(@NotNull BuilderImpl builderImpl) {
        this.prefix = ComponentLike.unbox(builderImpl.prefix);
        this.suffix = ComponentLike.unbox(builderImpl.suffix);
        this.separator = ComponentLike.unbox(builderImpl.separator);
        this.lastSeparator = ComponentLike.unbox(builderImpl.lastSeparator);
        this.lastSeparatorIfSerial = ComponentLike.unbox(builderImpl.lastSeparatorIfSerial);
        this.convertor = builderImpl.convertor;
        this.predicate = builderImpl.predicate;
        this.rootStyle = builderImpl.rootStyle;
    }

    @Override
    @Nullable
    public final Component prefix() {
        return this.prefix;
    }

    @Override
    @Nullable
    public final Component suffix() {
        return this.suffix;
    }

    @Override
    @Nullable
    public final Component separator() {
        return this.separator;
    }

    @Override
    @Nullable
    public final Component lastSeparator() {
        return this.lastSeparator;
    }

    @Override
    @Nullable
    public final Component lastSeparatorIfSerial() {
        return this.lastSeparatorIfSerial;
    }

    @Override
    @NotNull
    public final Function<ComponentLike, Component> convertor() {
        return this.convertor;
    }

    @Override
    @NotNull
    public final Predicate<ComponentLike> predicate() {
        return this.predicate;
    }

    @Override
    @NotNull
    public final Style parentStyle() {
        return this.rootStyle;
    }

    @Override
    public final @NotNull JoinConfiguration.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("prefix", this.prefix), ExaminableProperty.of("suffix", this.suffix), ExaminableProperty.of("separator", this.separator), ExaminableProperty.of("lastSeparator", this.lastSeparator), ExaminableProperty.of("lastSeparatorIfSerial", this.lastSeparatorIfSerial), ExaminableProperty.of("convertor", this.convertor), ExaminableProperty.of("predicate", this.predicate), ExaminableProperty.of("rootStyle", this.rootStyle));
    }

    public final String toString() {
        return Internals.toString(this);
    }

    @Contract(pure=true)
    @NotNull
    static Component join(@NotNull JoinConfiguration joinConfiguration, @NotNull Iterable<? extends ComponentLike> object) {
        Objects.requireNonNull(joinConfiguration, "config");
        Objects.requireNonNull(object, "components");
        object = object.iterator();
        if (!object.hasNext()) {
            return JoinConfigurationImpl.singleElementJoin(joinConfiguration, null);
        }
        ComponentLike componentLike = Objects.requireNonNull((ComponentLike)object.next(), "Null elements in \"components\" are not allowed");
        int n2 = 0;
        if (!object.hasNext()) {
            return JoinConfigurationImpl.singleElementJoin(joinConfiguration, componentLike);
        }
        Component component = joinConfiguration.prefix();
        Component component2 = joinConfiguration.suffix();
        Function<ComponentLike, Component> function = joinConfiguration.convertor();
        Predicate<ComponentLike> predicate = joinConfiguration.predicate();
        StyleSetter<Style> styleSetter = joinConfiguration.parentStyle();
        boolean bl2 = styleSetter != Style.empty();
        Component component3 = joinConfiguration.separator();
        boolean bl3 = component3 != null;
        StyleSetter<TextComponent.Builder> styleSetter2 = styleSetter = bl2 ? (TextComponent.Builder)Component.text().style((Style)styleSetter) : Component.text();
        if (component != null) {
            styleSetter.append(component);
        }
        while (componentLike != null) {
            if (!predicate.test(componentLike)) {
                if (!object.hasNext()) break;
                componentLike = (ComponentLike)object.next();
                continue;
            }
            styleSetter.append(Objects.requireNonNull(function.apply(componentLike), "Null output from \"convertor\" is not allowed"));
            ++n2;
            if (!object.hasNext()) {
                componentLike = null;
                continue;
            }
            componentLike = Objects.requireNonNull((ComponentLike)object.next(), "Null elements in \"components\" are not allowed");
            if (object.hasNext()) {
                if (!bl3) continue;
                styleSetter.append(component3);
                continue;
            }
            component = null;
            if (n2 > 1) {
                component = joinConfiguration.lastSeparatorIfSerial();
            }
            if (component == null) {
                component = joinConfiguration.lastSeparator();
            }
            if (component == null) {
                component = joinConfiguration.separator();
            }
            if (component == null) continue;
            styleSetter.append(component);
        }
        if (component2 != null) {
            styleSetter.append(component2);
        }
        return styleSetter.build();
    }

    @NotNull
    static Component singleElementJoin(@NotNull JoinConfiguration examinable, @Nullable ComponentLike componentLike) {
        boolean bl2;
        Component component = examinable.prefix();
        Component component2 = examinable.suffix();
        Function<ComponentLike, Component> function = examinable.convertor();
        Predicate<ComponentLike> predicate = examinable.predicate();
        boolean bl3 = bl2 = (examinable = examinable.parentStyle()) != Style.empty();
        if (component == null && component2 == null) {
            Component component3 = componentLike == null || !predicate.test(componentLike) ? Component.empty() : function.apply(componentLike);
            if (bl2) {
                return ((TextComponent.Builder)((TextComponent.Builder)Component.text().style((Style)examinable)).append(component3)).build();
            }
            return component3;
        }
        TextComponent.Builder builder = Component.text();
        if (component != null) {
            builder.append(component);
        }
        if (componentLike != null && predicate.test(componentLike)) {
            builder.append(function.apply(componentLike));
        }
        if (component2 != null) {
            builder.append(component2);
        }
        if (bl2) {
            return ((TextComponent.Builder)((TextComponent.Builder)Component.text().style((Style)examinable)).append(builder)).build();
        }
        return builder.build();
    }

    static final class BuilderImpl
    implements JoinConfiguration.Builder {
        private ComponentLike prefix;
        private ComponentLike suffix;
        private ComponentLike separator;
        private ComponentLike lastSeparator;
        private ComponentLike lastSeparatorIfSerial;
        private Function<ComponentLike, Component> convertor;
        private Predicate<ComponentLike> predicate;
        private Style rootStyle;

        BuilderImpl() {
            this(NULL);
        }

        private BuilderImpl(@NotNull JoinConfigurationImpl joinConfigurationImpl) {
            this.separator = joinConfigurationImpl.separator;
            this.lastSeparator = joinConfigurationImpl.lastSeparator;
            this.prefix = joinConfigurationImpl.prefix;
            this.suffix = joinConfigurationImpl.suffix;
            this.convertor = joinConfigurationImpl.convertor;
            this.lastSeparatorIfSerial = joinConfigurationImpl.lastSeparatorIfSerial;
            this.predicate = joinConfigurationImpl.predicate;
            this.rootStyle = joinConfigurationImpl.rootStyle;
        }

        @Override
        @NotNull
        public final JoinConfiguration.Builder prefix(@Nullable ComponentLike componentLike) {
            this.prefix = componentLike;
            return this;
        }

        @Override
        @NotNull
        public final JoinConfiguration.Builder suffix(@Nullable ComponentLike componentLike) {
            this.suffix = componentLike;
            return this;
        }

        @Override
        @NotNull
        public final JoinConfiguration.Builder separator(@Nullable ComponentLike componentLike) {
            this.separator = componentLike;
            return this;
        }

        @Override
        @NotNull
        public final JoinConfiguration.Builder lastSeparator(@Nullable ComponentLike componentLike) {
            this.lastSeparator = componentLike;
            return this;
        }

        @Override
        @NotNull
        public final JoinConfiguration.Builder lastSeparatorIfSerial(@Nullable ComponentLike componentLike) {
            this.lastSeparatorIfSerial = componentLike;
            return this;
        }

        @Override
        @NotNull
        public final JoinConfiguration.Builder convertor(@NotNull Function<ComponentLike, Component> function) {
            this.convertor = Objects.requireNonNull(function, "convertor");
            return this;
        }

        @Override
        @NotNull
        public final JoinConfiguration.Builder predicate(@NotNull Predicate<ComponentLike> predicate) {
            this.predicate = Objects.requireNonNull(predicate, "predicate");
            return this;
        }

        @Override
        @NotNull
        public final JoinConfiguration.Builder parentStyle(@NotNull Style style) {
            this.rootStyle = Objects.requireNonNull(style, "rootStyle");
            return this;
        }

        @Override
        @NotNull
        public final JoinConfiguration build() {
            return new JoinConfigurationImpl(this);
        }
    }
}

