/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.extremall.advancedkits.libs.kyori.adventure.internal.Internals;
import me.extremall.advancedkits.libs.kyori.adventure.internal.properties.AdventureProperties;
import me.extremall.advancedkits.libs.kyori.adventure.text.AbstractComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.AbstractComponentBuilder;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.ComponentLike;
import me.extremall.advancedkits.libs.kyori.adventure.text.LegacyFormattingDetected;
import me.extremall.advancedkits.libs.kyori.adventure.text.TextComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.Style;
import me.extremall.advancedkits.libs.kyori.adventure.util.Nag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

final class TextComponentImpl
extends AbstractComponent
implements TextComponent {
    private static final boolean WARN_WHEN_LEGACY_FORMATTING_DETECTED = Boolean.TRUE.equals(AdventureProperties.TEXT_WARN_WHEN_LEGACY_FORMATTING_DETECTED.value());
    @VisibleForTesting
    static final char SECTION_CHAR = '\u00a7';
    static final TextComponent EMPTY = TextComponentImpl.createDirect("");
    static final TextComponent NEWLINE = TextComponentImpl.createDirect("\n");
    static final TextComponent SPACE = TextComponentImpl.createDirect(" ");
    private final String content;

    static TextComponent create(@NotNull List<? extends ComponentLike> list, @NotNull Style style, @NotNull String string) {
        if ((list = ComponentLike.asComponents(list, IS_NOT_EMPTY)).isEmpty() && style.isEmpty() && string.isEmpty()) {
            return Component.empty();
        }
        return new TextComponentImpl(list, Objects.requireNonNull(style, "style"), Objects.requireNonNull(string, "content"));
    }

    @NotNull
    private static TextComponent createDirect(@NotNull String string) {
        return new TextComponentImpl(Collections.emptyList(), Style.empty(), string);
    }

    TextComponentImpl(@NotNull List<Component> object, @NotNull Style style, @NotNull String string) {
        super((List<? extends ComponentLike>)object, style);
        this.content = string;
        if (WARN_WHEN_LEGACY_FORMATTING_DETECTED && (object = this.warnWhenLegacyFormattingDetected()) != null) {
            Nag.print((Nag)object);
        }
    }

    @VisibleForTesting
    @Nullable
    final LegacyFormattingDetected warnWhenLegacyFormattingDetected() {
        if (this.content.indexOf(167) != -1) {
            return new LegacyFormattingDetected(this);
        }
        return null;
    }

    @Override
    @NotNull
    public final String content() {
        return this.content;
    }

    @Override
    @NotNull
    public final TextComponent content(@NotNull String string) {
        if (Objects.equals(this.content, string)) {
            return this;
        }
        return TextComponentImpl.create(this.children, this.style, string);
    }

    @Override
    @NotNull
    public final TextComponent children(@NotNull List<? extends ComponentLike> list) {
        return TextComponentImpl.create(list, this.style, this.content);
    }

    @Override
    @NotNull
    public final TextComponent style(@NotNull Style style) {
        return TextComponentImpl.create(this.children, style, this.content);
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextComponentImpl)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = (TextComponentImpl)object;
        return Objects.equals(this.content, ((TextComponentImpl)object).content);
    }

    @Override
    public final int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 31 + this.content.hashCode();
        return n2;
    }

    @Override
    public final String toString() {
        return Internals.toString(this);
    }

    @Override
    @NotNull
    public final TextComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    extends AbstractComponentBuilder<TextComponent, TextComponent.Builder>
    implements TextComponent.Builder {
        private String content = "";

        BuilderImpl() {
        }

        BuilderImpl(@NotNull TextComponent textComponent) {
            super(textComponent);
            this.content = textComponent.content();
        }

        @Override
        @NotNull
        public final TextComponent.Builder content(@NotNull String string) {
            this.content = Objects.requireNonNull(string, "content");
            return this;
        }

        @Override
        @NotNull
        public final String content() {
            return this.content;
        }

        @Override
        @NotNull
        public final TextComponent build() {
            if (this.isEmpty()) {
                return Component.empty();
            }
            return TextComponentImpl.create(this.children, this.buildStyle(), this.content);
        }

        private boolean isEmpty() {
            return this.content.isEmpty() && this.children.isEmpty() && !this.hasStyle();
        }
    }
}

