/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.internal.parser.match;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.internal.TagInternals;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.internal.parser.Token;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.internal.parser.TokenParser;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.internal.parser.TokenType;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.internal.parser.match.MatchedTokenConsumer;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.internal.parser.node.TagPart;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.PreProcess;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.Tag;
import org.jetbrains.annotations.NotNull;

public final class StringResolvingMatchedTokenConsumer
extends MatchedTokenConsumer<String> {
    private final StringBuilder builder;
    private final TokenParser.TagProvider tagProvider;

    public StringResolvingMatchedTokenConsumer(@NotNull String string, @NotNull TokenParser.TagProvider tagProvider) {
        super(string);
        this.builder = new StringBuilder(string.length());
        this.tagProvider = tagProvider;
    }

    @Override
    public final void accept(int n2, int n3, @NotNull TokenType object) {
        super.accept(n2, n3, (TokenType)((Object)object));
        if (object != TokenType.OPEN_TAG) {
            this.builder.append(this.input, n2, n3);
            return;
        }
        object = this.input.substring(n2, n3);
        String string = this.input.substring(n2 + 1, n3 - 1);
        string = (n3 = string.indexOf(58)) == -1 ? string : string.substring(0, n3);
        if (TagInternals.sanitizeAndCheckValidTagName(string)) {
            Tag tag;
            List<Token> list = TokenParser.tokenize((String)object, false);
            ArrayList<TagPart> arrayList = new ArrayList<TagPart>();
            List<Token> list2 = list.isEmpty() ? null : list.get(0).childTokens();
            if (list2 != null) {
                for (int i2 = 1; i2 < list2.size(); ++i2) {
                    arrayList.add(new TagPart((String)object, list2.get(i2), this.tagProvider));
                }
            }
            if ((tag = this.tagProvider.resolve(TokenParser.TagProvider.sanitizePlaceholderName(string), arrayList, list.get(0))) instanceof PreProcess) {
                this.builder.append(Objects.requireNonNull(((PreProcess)tag).value(), "PreProcess replacements cannot return null"));
                return;
            }
        }
        this.builder.append((String)object);
    }

    @Override
    @NotNull
    public final String result() {
        return this.builder.toString();
    }
}

