/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.renderer;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import me.extremall.advancedkits.libs.kyori.adventure.text.BlockNBTComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.BuildableComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.ComponentBuilder;
import me.extremall.advancedkits.libs.kyori.adventure.text.EntityNBTComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.KeybindComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.NBTComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.NBTComponentBuilder;
import me.extremall.advancedkits.libs.kyori.adventure.text.ScoreComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.SelectorComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.StorageNBTComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.TextComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.TranslatableComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.TranslationArgument;
import me.extremall.advancedkits.libs.kyori.adventure.text.event.HoverEvent;
import me.extremall.advancedkits.libs.kyori.adventure.text.event.HoverEventSource;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.Style;
import me.extremall.advancedkits.libs.kyori.adventure.text.renderer.AbstractComponentRenderer;
import me.extremall.advancedkits.libs.kyori.adventure.translation.Translator;
import me.extremall.advancedkits.libs.kyori.adventure.util.TriState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TranslatableComponentRenderer<C>
extends AbstractComponentRenderer<C> {
    private static final Set<Style.Merge> MERGES = Style.Merge.merges(Style.Merge.COLOR, Style.Merge.DECORATIONS, Style.Merge.INSERTION, Style.Merge.FONT);

    @NotNull
    public static TranslatableComponentRenderer<Locale> usingTranslationSource(final @NotNull Translator translator) {
        Objects.requireNonNull(translator, "source");
        return new TranslatableComponentRenderer<Locale>(){

            @Override
            @Nullable
            protected MessageFormat translate(@NotNull String string, @NotNull Locale locale) {
                return translator.translate(string, locale);
            }

            @Override
            @NotNull
            protected Component renderTranslatable(@NotNull TranslatableComponent translatableComponent, @NotNull Locale locale) {
                Object object = translator.hasAnyTranslations();
                if (object == TriState.TRUE || object == TriState.NOT_SET) {
                    object = translator.translate(translatableComponent, locale);
                    if (object != null) {
                        return object;
                    }
                    return super.renderTranslatable(translatableComponent, locale);
                }
                return translatableComponent;
            }
        };
    }

    @Nullable
    protected MessageFormat translate(@NotNull String string, @NotNull C c2) {
        return null;
    }

    @Nullable
    protected MessageFormat translate(@NotNull String string, @Nullable String string2, @NotNull C c2) {
        return this.translate(string, c2);
    }

    @Override
    @NotNull
    protected Component renderBlockNbt(@NotNull BlockNBTComponent blockNBTComponent, @NotNull C c2) {
        BlockNBTComponent.Builder builder = this.nbt(c2, Component.blockNBT(), blockNBTComponent).pos(blockNBTComponent.pos());
        return this.mergeStyleAndOptionallyDeepRender(blockNBTComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderEntityNbt(@NotNull EntityNBTComponent entityNBTComponent, @NotNull C c2) {
        EntityNBTComponent.Builder builder = this.nbt(c2, Component.entityNBT(), entityNBTComponent).selector(entityNBTComponent.selector());
        return this.mergeStyleAndOptionallyDeepRender(entityNBTComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderStorageNbt(@NotNull StorageNBTComponent storageNBTComponent, @NotNull C c2) {
        StorageNBTComponent.Builder builder = this.nbt(c2, Component.storageNBT(), storageNBTComponent).storage(storageNBTComponent.storage());
        return this.mergeStyleAndOptionallyDeepRender(storageNBTComponent, builder, c2);
    }

    protected <O extends NBTComponent<O, B>, B extends NBTComponentBuilder<O, B>> B nbt(@NotNull C c2, B b2, O object) {
        b2.nbtPath(object.nbtPath()).interpret(object.interpret());
        object = object.separator();
        if (object != null) {
            b2.separator(this.render((Component)object, c2));
        }
        return b2;
    }

    @Override
    @NotNull
    protected Component renderKeybind(@NotNull KeybindComponent keybindComponent, @NotNull C c2) {
        KeybindComponent.Builder builder = Component.keybind().keybind(keybindComponent.keybind());
        return this.mergeStyleAndOptionallyDeepRender(keybindComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderScore(@NotNull ScoreComponent scoreComponent, @NotNull C c2) {
        ScoreComponent.Builder builder = Component.score().name(scoreComponent.name()).objective(scoreComponent.objective()).value(scoreComponent.value());
        return this.mergeStyleAndOptionallyDeepRender(scoreComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderSelector(@NotNull SelectorComponent selectorComponent, @NotNull C c2) {
        SelectorComponent.Builder builder = Component.selector().pattern(selectorComponent.pattern());
        return this.mergeStyleAndOptionallyDeepRender(selectorComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderText(@NotNull TextComponent textComponent, @NotNull C c2) {
        TextComponent.Builder builder = Component.text().content(textComponent.content());
        return this.mergeStyleAndOptionallyDeepRender(textComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderTranslatable(@NotNull TranslatableComponent translatableComponent, @NotNull C c2) {
        @Nullable Object object = this.translate(translatableComponent.key(), translatableComponent.fallback(), c2);
        if (object == null) {
            TranslatableComponent.Builder builder = Component.translatable().key(translatableComponent.key()).fallback(translatableComponent.fallback());
            if (!translatableComponent.arguments().isEmpty()) {
                ArrayList<TranslationArgument> arrayList = new ArrayList<TranslationArgument>(translatableComponent.arguments());
                int n2 = arrayList.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    object = (TranslationArgument)arrayList.get(i2);
                    if (!(object.value() instanceof Component)) continue;
                    arrayList.set(i2, TranslationArgument.component(this.render((Component)object.value(), c2)));
                }
                builder.arguments(arrayList);
            }
            return this.mergeStyleAndOptionallyDeepRender(translatableComponent, builder, c2);
        }
        List<TranslationArgument> list = translatableComponent.arguments();
        TextComponent.Builder builder = Component.text();
        this.mergeStyle(translatableComponent, builder, c2);
        if (list.isEmpty()) {
            builder.content(((MessageFormat)object).format(null, new StringBuffer(), null).toString());
            return this.optionallyRenderChildrenAppendAndBuild(translatableComponent.children(), builder, c2);
        }
        Object[] objectArray = new Object[list.size()];
        StringBuffer stringBuffer = ((MessageFormat)object).format(objectArray, new StringBuffer(), (FieldPosition)null);
        object = ((MessageFormat)object).formatToCharacterIterator(objectArray);
        while (object.getIndex() < object.getEndIndex()) {
            int n3 = object.getRunLimit();
            Object object2 = (Integer)object.getAttribute(MessageFormat.Field.ARGUMENT);
            if (object2 != null) {
                if ((object2 = list.get((Integer)object2)).value() instanceof Component) {
                    builder.append(this.render(object2.asComponent(), c2));
                } else {
                    builder.append(object2.asComponent());
                }
            } else {
                builder.append((Component)Component.text(stringBuffer.substring(object.getIndex(), n3)));
            }
            object.setIndex(n3);
        }
        return this.optionallyRenderChildrenAppendAndBuild(translatableComponent.children(), builder, c2);
    }

    protected <O extends BuildableComponent<O, B>, B extends ComponentBuilder<O, B>> O mergeStyleAndOptionallyDeepRender(Component component, B b2, C c2) {
        this.mergeStyle(component, b2, c2);
        return this.optionallyRenderChildrenAppendAndBuild(component.children(), b2, c2);
    }

    protected <O extends BuildableComponent<O, B>, B extends ComponentBuilder<O, B>> O optionallyRenderChildrenAppendAndBuild(List<Component> list, B b2, C c2) {
        if (!list.isEmpty()) {
            list.forEach(component -> b2.append(this.render((Component)component, c2)));
        }
        return (O)b2.build();
    }

    protected <B extends ComponentBuilder<?, ?>> void mergeStyle(Component hoverEventSource, B b2, C c2) {
        b2.mergeStyle((Component)hoverEventSource, MERGES);
        b2.clickEvent(hoverEventSource.clickEvent());
        hoverEventSource = hoverEventSource.hoverEvent();
        if (hoverEventSource != null) {
            b2.hoverEvent((HoverEventSource)((HoverEvent)hoverEventSource).withRenderedValue(this, c2));
        }
    }
}

