/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.extremall.advancedkits.libs.gson.Gson;
import me.extremall.advancedkits.libs.gson.JsonElement;
import me.extremall.advancedkits.libs.gson.JsonObject;
import me.extremall.advancedkits.libs.gson.JsonParseException;
import me.extremall.advancedkits.libs.gson.TypeAdapter;
import me.extremall.advancedkits.libs.gson.reflect.TypeToken;
import me.extremall.advancedkits.libs.gson.stream.JsonReader;
import me.extremall.advancedkits.libs.gson.stream.JsonToken;
import me.extremall.advancedkits.libs.gson.stream.JsonWriter;
import me.extremall.advancedkits.libs.kyori.adventure.key.Key;
import me.extremall.advancedkits.libs.kyori.adventure.text.BlockNBTComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.BuildableComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.ComponentLike;
import me.extremall.advancedkits.libs.kyori.adventure.text.EntityNBTComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.KeybindComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.NBTComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.NBTComponentBuilder;
import me.extremall.advancedkits.libs.kyori.adventure.text.ScoreComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.SelectorComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.StorageNBTComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.TextComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.TranslatableComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.SerializerFactory;
import me.extremall.advancedkits.libs.kyori.adventure.util.Buildable;
import org.jetbrains.annotations.Nullable;

final class ComponentSerializerImpl
extends TypeAdapter<Component> {
    static final String TEXT = "text";
    static final String TRANSLATE = "translate";
    static final String TRANSLATE_FALLBACK = "fallback";
    static final String TRANSLATE_WITH = "with";
    static final String SCORE = "score";
    static final String SCORE_NAME = "name";
    static final String SCORE_OBJECTIVE = "objective";
    static final String SCORE_VALUE = "value";
    static final String SELECTOR = "selector";
    static final String KEYBIND = "keybind";
    static final String EXTRA = "extra";
    static final String NBT = "nbt";
    static final String NBT_INTERPRET = "interpret";
    static final String NBT_BLOCK = "block";
    static final String NBT_ENTITY = "entity";
    static final String NBT_STORAGE = "storage";
    static final String SEPARATOR = "separator";
    static final Type COMPONENT_LIST_TYPE = new TypeToken<List<Component>>(){}.getType();
    private final Gson gson;

    static TypeAdapter<Component> create(Gson gson) {
        return new ComponentSerializerImpl(gson).nullSafe();
    }

    private ComponentSerializerImpl(Gson gson) {
        this.gson = gson;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final BuildableComponent<?, ?> read(JsonReader jsonReader) {
        Object object;
        JsonToken jsonToken = jsonReader.peek();
        if (jsonToken == JsonToken.STRING || jsonToken == JsonToken.NUMBER || jsonToken == JsonToken.BOOLEAN) {
            return Component.text(ComponentSerializerImpl.readString(jsonReader));
        }
        if (jsonToken == JsonToken.BEGIN_ARRAY) {
            void var2_4;
            Object var2_3 = null;
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                Object object2 = this.read(jsonReader);
                if (var2_4 == null) {
                    Buildable.Builder builder = object2.toBuilder();
                    continue;
                }
                var2_4.append((Component)object2);
            }
            if (var2_4 == null) {
                throw ComponentSerializerImpl.notSureHowToDeserialize(jsonReader.getPath());
            }
            jsonReader.endArray();
            return var2_4.build();
        }
        if (jsonToken != JsonToken.BEGIN_OBJECT) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(jsonReader.getPath());
        }
        JsonObject jsonObject = new JsonObject();
        List list = Collections.emptyList();
        String string = null;
        String string2 = null;
        String string3 = null;
        List list2 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        boolean bl2 = false;
        BlockNBTComponent.Pos pos = null;
        String string10 = null;
        Key key = null;
        Object object3 = null;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            object = jsonReader.nextName();
            if (((String)object).equals(TEXT)) {
                string = ComponentSerializerImpl.readString(jsonReader);
                continue;
            }
            if (((String)object).equals(TRANSLATE)) {
                string2 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals(TRANSLATE_FALLBACK)) {
                string3 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals(TRANSLATE_WITH)) {
                list2 = (List)this.gson.fromJson(jsonReader, COMPONENT_LIST_TYPE);
                continue;
            }
            if (((String)object).equals(SCORE)) {
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    object = jsonReader.nextName();
                    if (((String)object).equals(SCORE_NAME)) {
                        string4 = jsonReader.nextString();
                        continue;
                    }
                    if (((String)object).equals(SCORE_OBJECTIVE)) {
                        string5 = jsonReader.nextString();
                        continue;
                    }
                    if (((String)object).equals(SCORE_VALUE)) {
                        string6 = jsonReader.nextString();
                        continue;
                    }
                    jsonReader.skipValue();
                }
                if (string4 == null || string5 == null) {
                    throw new JsonParseException("A score component requires a name and objective");
                }
                jsonReader.endObject();
                continue;
            }
            if (((String)object).equals(SELECTOR)) {
                string7 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals(KEYBIND)) {
                string8 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals(NBT)) {
                string9 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals(NBT_INTERPRET)) {
                bl2 = jsonReader.nextBoolean();
                continue;
            }
            if (((String)object).equals(NBT_BLOCK)) {
                pos = (BlockNBTComponent.Pos)this.gson.fromJson(jsonReader, SerializerFactory.BLOCK_NBT_POS_TYPE);
                continue;
            }
            if (((String)object).equals(NBT_ENTITY)) {
                string10 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals(NBT_STORAGE)) {
                key = (Key)this.gson.fromJson(jsonReader, SerializerFactory.KEY_TYPE);
                continue;
            }
            if (((String)object).equals(EXTRA)) {
                list = (List)this.gson.fromJson(jsonReader, COMPONENT_LIST_TYPE);
                continue;
            }
            if (((String)object).equals(SEPARATOR)) {
                object3 = this.read(jsonReader);
                continue;
            }
            jsonObject.add((String)object, (JsonElement)this.gson.fromJson(jsonReader, (Type)((Object)JsonElement.class)));
        }
        if (string != null) {
            object = Component.text().content(string);
        } else if (string2 != null) {
            object = list2 != null ? Component.translatable().key(string2).fallback(string3).args(list2) : Component.translatable().key(string2).fallback(string3);
        } else if (string4 != null && string5 != null) {
            object = string6 == null ? Component.score().name(string4).objective(string5) : Component.score().name(string4).objective(string5).value(string6);
        } else if (string7 != null) {
            object = Component.selector().pattern(string7).separator((ComponentLike)object3);
        } else if (string8 != null) {
            object = Component.keybind().keybind(string8);
        } else {
            if (string9 == null) throw ComponentSerializerImpl.notSureHowToDeserialize(jsonReader.getPath());
            if (pos != null) {
                object = ComponentSerializerImpl.nbt(Component.blockNBT(), string9, bl2, object3).pos(pos);
            } else if (string10 != null) {
                object = ComponentSerializerImpl.nbt(Component.entityNBT(), string9, bl2, object3).selector(string10);
            } else {
                if (key == null) throw ComponentSerializerImpl.notSureHowToDeserialize(jsonReader.getPath());
                object = ComponentSerializerImpl.nbt(Component.storageNBT(), string9, bl2, object3).storage(key);
            }
        }
        object.style(this.gson.fromJson((JsonElement)jsonObject, SerializerFactory.STYLE_TYPE)).append(list);
        jsonReader.endObject();
        return object.build();
    }

    private static String readString(JsonReader jsonReader) {
        JsonToken jsonToken = jsonReader.peek();
        if (jsonToken == JsonToken.STRING || jsonToken == JsonToken.NUMBER) {
            return jsonReader.nextString();
        }
        if (jsonToken == JsonToken.BOOLEAN) {
            return String.valueOf(jsonReader.nextBoolean());
        }
        throw new JsonParseException("Token of type " + (Object)((Object)jsonToken) + " cannot be interpreted as a string");
    }

    private static <C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>> B nbt(B b2, String string, boolean bl2, @Nullable Component component) {
        return b2.nbtPath(string).interpret(bl2).separator(component);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void write(JsonWriter jsonWriter, Component component) {
        JsonElement jsonElement;
        jsonWriter.beginObject();
        if (component.hasStyling() && (jsonElement = this.gson.toJsonTree(component.style(), SerializerFactory.STYLE_TYPE)).isJsonObject()) {
            for (Map.Entry<String, JsonElement> entry : jsonElement.getAsJsonObject().entrySet()) {
                jsonWriter.name(entry.getKey());
                this.gson.toJson(entry.getValue(), jsonWriter);
            }
        }
        if (!component.children().isEmpty()) {
            jsonWriter.name(EXTRA);
            this.gson.toJson(component.children(), COMPONENT_LIST_TYPE, jsonWriter);
        }
        if (component instanceof TextComponent) {
            jsonWriter.name(TEXT);
            jsonWriter.value(((TextComponent)component).content());
        } else if (component instanceof TranslatableComponent) {
            TranslatableComponent translatableComponent = (TranslatableComponent)component;
            jsonWriter.name(TRANSLATE);
            jsonWriter.value(translatableComponent.key());
            String string = translatableComponent.fallback();
            if (string != null) {
                jsonWriter.name(TRANSLATE_FALLBACK);
                jsonWriter.value(string);
            }
            if (!translatableComponent.args().isEmpty()) {
                jsonWriter.name(TRANSLATE_WITH);
                this.gson.toJson(translatableComponent.args(), COMPONENT_LIST_TYPE, jsonWriter);
            }
        } else if (component instanceof ScoreComponent) {
            ScoreComponent scoreComponent = (ScoreComponent)component;
            jsonWriter.name(SCORE);
            jsonWriter.beginObject();
            jsonWriter.name(SCORE_NAME);
            jsonWriter.value(scoreComponent.name());
            jsonWriter.name(SCORE_OBJECTIVE);
            jsonWriter.value(scoreComponent.objective());
            if (scoreComponent.value() != null) {
                jsonWriter.name(SCORE_VALUE);
                jsonWriter.value(scoreComponent.value());
            }
            jsonWriter.endObject();
        } else if (component instanceof SelectorComponent) {
            SelectorComponent selectorComponent = (SelectorComponent)component;
            jsonWriter.name(SELECTOR);
            jsonWriter.value(selectorComponent.pattern());
            this.serializeSeparator(jsonWriter, selectorComponent.separator());
        } else if (component instanceof KeybindComponent) {
            jsonWriter.name(KEYBIND);
            jsonWriter.value(((KeybindComponent)component).keybind());
        } else {
            if (!(component instanceof NBTComponent)) throw ComponentSerializerImpl.notSureHowToSerialize(component);
            NBTComponent nBTComponent = (NBTComponent)component;
            jsonWriter.name(NBT);
            jsonWriter.value(nBTComponent.nbtPath());
            jsonWriter.name(NBT_INTERPRET);
            jsonWriter.value(nBTComponent.interpret());
            this.serializeSeparator(jsonWriter, nBTComponent.separator());
            if (component instanceof BlockNBTComponent) {
                jsonWriter.name(NBT_BLOCK);
                this.gson.toJson((Object)((BlockNBTComponent)component).pos(), SerializerFactory.BLOCK_NBT_POS_TYPE, jsonWriter);
            } else if (component instanceof EntityNBTComponent) {
                jsonWriter.name(NBT_ENTITY);
                jsonWriter.value(((EntityNBTComponent)component).selector());
            } else {
                if (!(component instanceof StorageNBTComponent)) throw ComponentSerializerImpl.notSureHowToSerialize(component);
                jsonWriter.name(NBT_STORAGE);
                this.gson.toJson((Object)((StorageNBTComponent)component).storage(), SerializerFactory.KEY_TYPE, jsonWriter);
            }
        }
        jsonWriter.endObject();
    }

    private void serializeSeparator(JsonWriter jsonWriter, @Nullable Component component) {
        if (component != null) {
            jsonWriter.name(SEPARATOR);
            this.write(jsonWriter, component);
        }
    }

    static JsonParseException notSureHowToDeserialize(Object object) {
        return new JsonParseException("Don't know how to turn " + object + " into a Component");
    }

    private static IllegalArgumentException notSureHowToSerialize(Component component) {
        return new IllegalArgumentException("Don't know how to serialize " + component + " as a Component");
    }
}

