/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson;

import me.extremall.advancedkits.libs.gson.JsonParseException;
import me.extremall.advancedkits.libs.gson.JsonSyntaxException;
import me.extremall.advancedkits.libs.gson.TypeAdapter;
import me.extremall.advancedkits.libs.gson.stream.JsonReader;
import me.extremall.advancedkits.libs.gson.stream.JsonWriter;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.TextColor;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.TextDecoration;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.TextColorSerializer;
import org.jetbrains.annotations.Nullable;

final class TextColorWrapper {
    @Nullable
    final TextColor color;
    @Nullable
    final TextDecoration decoration;
    final boolean reset;

    TextColorWrapper(@Nullable TextColor textColor, @Nullable TextDecoration textDecoration, boolean bl2) {
        this.color = textColor;
        this.decoration = textDecoration;
        this.reset = bl2;
    }

    static final class Serializer
    extends TypeAdapter<TextColorWrapper> {
        static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public final void write(JsonWriter jsonWriter, TextColorWrapper textColorWrapper) {
            throw new JsonSyntaxException("Cannot write TextColorWrapper instances");
        }

        @Override
        public final TextColorWrapper read(JsonReader jsonReader) {
            boolean bl2;
            String string = jsonReader.nextString();
            TextColor textColor = TextColorSerializer.fromString(string);
            TextDecoration textDecoration = TextDecoration.NAMES.value(string);
            boolean bl3 = bl2 = textDecoration == null && string.equals("reset");
            if (textColor == null && textDecoration == null && !bl2) {
                throw new JsonParseException("Don't know how to parse " + string + " at " + jsonReader.getPath());
            }
            return new TextColorWrapper(textColor, textDecoration, bl2);
        }
    }
}

