/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.translation;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import me.extremall.advancedkits.libs.kyori.adventure.internal.Internals;
import me.extremall.advancedkits.libs.kyori.adventure.key.Key;
import me.extremall.advancedkits.libs.kyori.adventure.translation.TranslationLocales;
import me.extremall.advancedkits.libs.kyori.adventure.translation.TranslationRegistry;
import me.extremall.advancedkits.libs.kyori.adventure.util.TriState;
import me.extremall.advancedkits.libs.kyori.examination.Examinable;
import me.extremall.advancedkits.libs.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TranslationRegistryImpl
implements TranslationRegistry,
Examinable {
    private final Key name;
    private final Map<String, Translation> translations = new ConcurrentHashMap<String, Translation>();
    private Locale defaultLocale = Locale.US;

    TranslationRegistryImpl(Key key) {
        this.name = key;
    }

    @Override
    public final void register(@NotNull String string2, @NotNull Locale locale, @NotNull MessageFormat messageFormat) {
        this.translations.computeIfAbsent(string2, string -> new Translation((String)string)).register(locale, messageFormat);
    }

    @Override
    public final void unregister(@NotNull String string) {
        this.translations.remove(string);
    }

    @Override
    @NotNull
    public final Key name() {
        return this.name;
    }

    @Override
    public final boolean contains(@NotNull String string) {
        return this.translations.containsKey(string);
    }

    @Override
    @NotNull
    public final TriState hasAnyTranslations() {
        if (!this.translations.isEmpty()) {
            return TriState.TRUE;
        }
        return TriState.FALSE;
    }

    @Override
    @Nullable
    public final MessageFormat translate(@NotNull String object, @NotNull Locale locale) {
        if ((object = this.translations.get(object)) == null) {
            return null;
        }
        return ((Translation)object).translate(locale);
    }

    @Override
    public final void defaultLocale(@NotNull Locale locale) {
        this.defaultLocale = Objects.requireNonNull(locale, "defaultLocale");
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("translations", this.translations));
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TranslationRegistryImpl)) {
            return false;
        }
        object = (TranslationRegistryImpl)object;
        return this.name.equals(((TranslationRegistryImpl)object).name) && this.translations.equals(((TranslationRegistryImpl)object).translations) && this.defaultLocale.equals(((TranslationRegistryImpl)object).defaultLocale);
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.translations, this.defaultLocale);
    }

    public final String toString() {
        return Internals.toString(this);
    }

    final class Translation
    implements Examinable {
        private final String key;
        private final Map<Locale, MessageFormat> formats;

        Translation(String string) {
            this.key = Objects.requireNonNull(string, "translation key");
            this.formats = new ConcurrentHashMap<Locale, MessageFormat>();
        }

        final void register(@NotNull Locale locale, @NotNull MessageFormat messageFormat) {
            if (this.formats.putIfAbsent(Objects.requireNonNull(locale, "locale"), Objects.requireNonNull(messageFormat, "message format")) != null) {
                throw new IllegalArgumentException(String.format("Translation already exists: %s for %s", this.key, locale));
            }
        }

        @Nullable
        final MessageFormat translate(@NotNull Locale locale) {
            MessageFormat messageFormat = this.formats.get(Objects.requireNonNull(locale, "locale"));
            if (messageFormat == null && (messageFormat = this.formats.get(new Locale(locale.getLanguage()))) == null && (messageFormat = this.formats.get(TranslationRegistryImpl.this.defaultLocale)) == null) {
                messageFormat = this.formats.get(TranslationLocales.global());
            }
            return messageFormat;
        }

        @Override
        @NotNull
        public final Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("key", this.key), ExaminableProperty.of("formats", this.formats));
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Translation)) {
                return false;
            }
            object = (Translation)object;
            return this.key.equals(((Translation)object).key) && this.formats.equals(((Translation)object).formats);
        }

        public final int hashCode() {
            return Objects.hash(this.key, this.formats);
        }

        public final String toString() {
            return Internals.toString(this);
        }
    }
}

