/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.util;

import java.util.Optional;
import java.util.ServiceLoader;
import me.extremall.advancedkits.libs.kyori.adventure.internal.properties.AdventureProperties;
import me.extremall.advancedkits.libs.kyori.adventure.util.Services0;
import org.jetbrains.annotations.NotNull;

public final class Services {
    private static final boolean SERVICE_LOAD_FAILURES_ARE_FATAL = Boolean.TRUE.equals(AdventureProperties.SERVICE_LOAD_FAILURES_ARE_FATAL.value());

    private Services() {
    }

    @NotNull
    public static <P> Optional<P> service(@NotNull Class<P> clazz) {
        Object object = Services0.loader(clazz);
        object = ((ServiceLoader)object).iterator();
        while (object.hasNext()) {
            Object e2;
            try {
                e2 = object.next();
            }
            catch (Throwable throwable) {
                if (!SERVICE_LOAD_FAILURES_ARE_FATAL) continue;
                throw new IllegalStateException("Encountered an exception loading service " + clazz, throwable);
            }
            if (object.hasNext()) {
                throw new IllegalStateException("Expected to find one service " + clazz + ", found multiple");
            }
            return Optional.of(e2);
        }
        return Optional.empty();
    }

    @NotNull
    public static <P> Optional<P> serviceWithFallback(@NotNull Class<P> clazz) {
        Object object = Services0.loader(clazz);
        object = ((ServiceLoader)object).iterator();
        Object t2 = null;
        while (object.hasNext()) {
            Object e2;
            try {
                e2 = object.next();
            }
            catch (Throwable throwable) {
                if (!SERVICE_LOAD_FAILURES_ARE_FATAL) continue;
                throw new IllegalStateException("Encountered an exception loading service " + clazz, throwable);
            }
            if (e2 instanceof Fallback) {
                if (t2 != null) continue;
                t2 = e2;
                continue;
            }
            return Optional.of(e2);
        }
        return Optional.ofNullable(t2);
    }

    public static interface Fallback {
    }
}

