/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.libby.classloader;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.extremall.advancedkits.libs.libby.Library;
import me.extremall.advancedkits.libs.libby.LibraryManager;
import me.extremall.advancedkits.libs.libby.classloader.IsolatedClassLoader;
import sun.misc.Unsafe;

public class URLClassLoaderHelper {
    private static final Unsafe theUnsafe;
    private final URLClassLoader classLoader;
    private MethodHandle addURLMethodHandle = null;

    public URLClassLoaderHelper(URLClassLoader uRLClassLoader, LibraryManager libraryManager) {
        Objects.requireNonNull(libraryManager, "libraryManager");
        this.classLoader = Objects.requireNonNull(uRLClassLoader, "classLoader");
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            try {
                URLClassLoaderHelper.openUrlClassLoaderModule();
            }
            catch (Exception exception) {}
            try {
                method.setAccessible(true);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                if (exception.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                    if (theUnsafe != null) {
                        try {
                            this.addURLMethodHandle = this.getPrivilegedMethodHandle(method).bindTo(uRLClassLoader);
                            return;
                        }
                        catch (Exception exception3) {
                            this.addURLMethodHandle = null;
                        }
                    }
                    try {
                        this.addOpensWithAgent(libraryManager);
                        method.setAccessible(true);
                    }
                    catch (Exception exception4) {
                        System.err.println("Cannot access URLClassLoader#addURL(URL), if you are using Java 9+ try to add the following option to your java command: --add-opens java.base/java.net=ALL-UNNAMED");
                        throw new RuntimeException("Cannot access URLClassLoader#addURL(URL)", exception4);
                    }
                }
                throw new RuntimeException("Cannot set accessible URLClassLoader#addURL(URL)", exception2);
            }
            this.addURLMethodHandle = MethodHandles.lookup().unreflect(method).bindTo(uRLClassLoader);
            return;
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public void addToClasspath(URL uRL) {
        try {
            this.addURLMethodHandle.invokeWithArguments(Objects.requireNonNull(uRL, "url"));
            return;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void addToClasspath(Path path) {
        try {
            this.addToClasspath(Objects.requireNonNull(path, "path").toUri().toURL());
            return;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    private static void openUrlClassLoaderModule() {
        GenericDeclaration genericDeclaration = Class.forName("java.lang.Module");
        Object object = Class.class.getMethod("getModule", new Class[0]);
        genericDeclaration = ((Class)genericDeclaration).getMethod("addOpens", new Class[]{String.class, genericDeclaration});
        Object object2 = ((Method)object).invoke(URLClassLoader.class, new Object[0]);
        object = ((Method)object).invoke(URLClassLoaderHelper.class, new Object[0]);
        ((Method)genericDeclaration).invoke(object2, URLClassLoader.class.getPackage().getName(), object);
    }

    private MethodHandle getPrivilegedMethodHandle(Method method) {
        for (Field object : MethodHandles.Lookup.class.getDeclaredFields()) {
            if (object.getType() != MethodHandles.Lookup.class || !Modifier.isStatic(object.getModifiers()) || object.isSynthetic()) continue;
            try {
                Unsafe unsafe = theUnsafe;
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)unsafe.getObject(unsafe.staticFieldBase(object), theUnsafe.staticFieldOffset(object));
                return lookup.unreflect(method);
            }
            catch (Exception exception) {}
        }
        throw new RuntimeException("Cannot get privileged method handle.");
    }

    private void addOpensWithAgent(LibraryManager object) {
        IsolatedClassLoader isolatedClassLoader = new IsolatedClassLoader(new URL[0]);
        try {
            isolatedClassLoader.addPath(((LibraryManager)object).downloadLibrary(Library.builder().groupId("net.bytebuddy").artifactId("byte-buddy-agent").version("1.12.1").checksum("mcCtBT9cljUEniB5ESpPDYZMfVxEs1JRPllOiWTP+bM=").repository("https://repo1.maven.org/maven2/").build()));
            object = isolatedClassLoader.loadClass("net.bytebuddy.agent.ByteBuddyAgent");
            object = ((Class)object).getDeclaredMethod("install", new Class[0]).invoke(null, new Object[0]);
            GenericDeclaration genericDeclaration = Class.forName("java.lang.instrument.Instrumentation");
            genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod("redefineModule", Class.forName("java.lang.Module"), Set.class, Map.class, Map.class, Set.class, Map.class);
            Method method = Class.class.getDeclaredMethod("getModule", new Class[0]);
            Map<String, Set<Object>> map = Collections.singletonMap("java.net", Collections.singleton(method.invoke(this.getClass(), new Object[0])));
            ((Method)genericDeclaration).invoke(object, method.invoke(URLClassLoader.class, new Object[0]), Collections.emptySet(), Collections.emptyMap(), map, Collections.emptySet(), Collections.emptyMap());
        }
        catch (Throwable throwable) {
            try {
                isolatedClassLoader.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            isolatedClassLoader.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static {
        Unsafe unsafe = null;
        for (Field field : Unsafe.class.getDeclaredFields()) {
            try {
                if (field.getType() != Unsafe.class || !Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                unsafe = (Unsafe)field.get(null);
            }
            catch (Exception exception) {}
        }
        theUnsafe = unsafe;
    }
}

