/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.libby.logging;

import java.util.Objects;
import me.extremall.advancedkits.libs.libby.logging.LogLevel;
import me.extremall.advancedkits.libs.libby.logging.adapters.LogAdapter;

public class Logger {
    private final LogAdapter adapter;
    private LogLevel level = LogLevel.INFO;

    public Logger(LogAdapter logAdapter) {
        this.adapter = Objects.requireNonNull(logAdapter, "adapter");
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public void setLevel(LogLevel logLevel) {
        this.level = Objects.requireNonNull(logLevel, "level");
    }

    private boolean canLog(LogLevel logLevel) {
        return Objects.requireNonNull(logLevel, "level").compareTo(this.level) >= 0;
    }

    public void log(LogLevel logLevel, String string) {
        if (this.canLog(logLevel)) {
            this.adapter.log(logLevel, string);
        }
    }

    public void log(LogLevel logLevel, String string, Throwable throwable) {
        if (this.canLog(logLevel)) {
            this.adapter.log(logLevel, string, throwable);
        }
    }

    public void debug(String string) {
        this.log(LogLevel.DEBUG, string);
    }

    public void debug(String string, Throwable throwable) {
        this.log(LogLevel.DEBUG, string, throwable);
    }

    public void info(String string) {
        this.log(LogLevel.INFO, string);
    }

    public void info(String string, Throwable throwable) {
        this.log(LogLevel.INFO, string, throwable);
    }

    public void warn(String string) {
        this.log(LogLevel.WARN, string);
    }

    public void warn(String string, Throwable throwable) {
        this.log(LogLevel.WARN, string, throwable);
    }

    public void error(String string) {
        this.log(LogLevel.ERROR, string);
    }

    public void error(String string, Throwable throwable) {
        this.log(LogLevel.ERROR, string, throwable);
    }
}

