/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.nbtapi;

import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import me.extremall.advancedkits.libs.nbtapi.NBTCompound;
import me.extremall.advancedkits.libs.nbtapi.NBTCompoundList;
import me.extremall.advancedkits.libs.nbtapi.NBTContainer;
import me.extremall.advancedkits.libs.nbtapi.NBTList;
import me.extremall.advancedkits.libs.nbtapi.NBTListCompound;
import me.extremall.advancedkits.libs.nbtapi.NBTReflectionUtil;
import me.extremall.advancedkits.libs.nbtapi.NbtApiException;
import me.extremall.advancedkits.libs.nbtapi.iface.ReadWriteItemNBT;
import me.extremall.advancedkits.libs.nbtapi.iface.ReadWriteNBT;
import me.extremall.advancedkits.libs.nbtapi.iface.ReadableNBT;
import me.extremall.advancedkits.libs.nbtapi.utils.nmsmappings.ClassWrapper;
import me.extremall.advancedkits.libs.nbtapi.utils.nmsmappings.ReflectionMethod;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class NBTItem
extends NBTCompound
implements ReadWriteItemNBT {
    private ItemStack bukkitItem;
    private final boolean directApply;
    private final boolean finalizer;
    private ItemStack originalSrcStack = null;
    private Object cachedCompound = null;
    private boolean closed = false;

    public NBTItem(ItemStack itemStack) {
        this(itemStack, false);
    }

    protected NBTItem(ItemStack itemStack, boolean bl2, boolean bl3, boolean bl4) {
        super(null, null, bl3);
        if (itemStack == null || itemStack.getType() == Material.AIR || itemStack.getAmount() <= 0) {
            throw new NullPointerException("ItemStack can't be null/air/amount of 0! This is not a NBTAPI bug!");
        }
        this.finalizer = bl4;
        if (bl4) {
            this.bukkitItem = itemStack;
            this.originalSrcStack = itemStack;
            this.directApply = false;
            return;
        }
        if (bl3) {
            this.bukkitItem = itemStack;
            this.directApply = false;
            return;
        }
        this.directApply = bl2;
        this.bukkitItem = itemStack.clone();
        if (bl2) {
            this.originalSrcStack = itemStack;
        }
    }

    @Deprecated
    public NBTItem(ItemStack itemStack, boolean bl2) {
        super(null, null);
        if (itemStack == null || itemStack.getType() == Material.AIR || itemStack.getAmount() <= 0) {
            throw new NullPointerException("ItemStack can't be null/air/amount of 0! This is not a NBTAPI bug!");
        }
        this.finalizer = false;
        this.directApply = bl2;
        this.bukkitItem = itemStack.clone();
        if (bl2) {
            this.originalSrcStack = itemStack;
        }
    }

    @Override
    public Object getCompound() {
        if (this.closed) {
            throw new NbtApiException("Tried using closed NBT data!");
        }
        if (this.isReadOnly() && (this.cachedCompound != null || ClassWrapper.CRAFT_ITEMSTACK.getClazz().isAssignableFrom(this.bukkitItem.getClass()))) {
            if (this.cachedCompound == null) {
                this.cachedCompound = NBTReflectionUtil.getItemRootNBTTagCompound(NBTReflectionUtil.getCraftItemHandle(this.bukkitItem));
            }
            return this.cachedCompound;
        }
        if (this.finalizer) {
            if (this.cachedCompound == null) {
                this.updateCachedCompound();
            }
            return this.cachedCompound;
        }
        return NBTReflectionUtil.getItemRootNBTTagCompound(ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, this.bukkitItem));
    }

    private void updateCachedCompound() {
        if (this.finalizer) {
            this.cachedCompound = NBTReflectionUtil.getItemRootNBTTagCompound(ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, this.bukkitItem));
        }
    }

    protected void finalizeChanges() {
        if (!this.finalizer || this.cachedCompound == null) {
            return;
        }
        if (NBTReflectionUtil.getKeys(this).isEmpty()) {
            this.cachedCompound = null;
        }
        if (ClassWrapper.CRAFT_ITEMSTACK.getClazz().isAssignableFrom(this.originalSrcStack.getClass())) {
            Object object = NBTReflectionUtil.getCraftItemHandle(this.originalSrcStack);
            ReflectionMethod.ITEMSTACK_SET_TAG.run(object, this.cachedCompound);
            this.bukkitItem = this.originalSrcStack;
            return;
        }
        Object object = ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, this.bukkitItem);
        ReflectionMethod.ITEMSTACK_SET_TAG.run(object, this.cachedCompound);
        this.bukkitItem = (ItemStack)ReflectionMethod.ITEMSTACK_BUKKITMIRROR.run(null, object);
        this.originalSrcStack.setItemMeta(this.bukkitItem.getItemMeta());
    }

    @Override
    protected void setClosed() {
        this.closed = true;
    }

    @Override
    protected boolean isClosed() {
        return this.closed;
    }

    @Override
    protected void setCompound(Object object) {
        if (this.isReadOnly()) {
            throw new NbtApiException("Tried setting data in read only mode!");
        }
        if (this.closed) {
            throw new NbtApiException("Tried using closed NBT data!");
        }
        if (this.finalizer) {
            this.cachedCompound = object;
            return;
        }
        if (object != null && ((Set)ReflectionMethod.COMPOUND_GET_KEYS.run(object, new Object[0])).isEmpty()) {
            object = null;
        }
        if (ClassWrapper.CRAFT_ITEMSTACK.getClazz().isAssignableFrom(this.bukkitItem.getClass())) {
            Object object2 = NBTReflectionUtil.getCraftItemHandle(this.bukkitItem);
            ReflectionMethod.ITEMSTACK_SET_TAG.run(object2, object);
            return;
        }
        Object object3 = ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, this.bukkitItem);
        ReflectionMethod.ITEMSTACK_SET_TAG.run(object3, object);
        this.bukkitItem = (ItemStack)ReflectionMethod.ITEMSTACK_BUKKITMIRROR.run(null, object3);
    }

    public void applyNBT(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            throw new NullPointerException("ItemStack can't be null/Air! This is not a NBTAPI bug!");
        }
        NBTItem nBTItem = new NBTItem(new ItemStack(itemStack.getType()));
        nBTItem.mergeCompound(this);
        itemStack.setItemMeta(nBTItem.getItem().getItemMeta());
    }

    public void mergeNBT(ItemStack itemStack) {
        NBTItem nBTItem = new NBTItem(itemStack);
        nBTItem.mergeCompound(this);
        itemStack.setItemMeta(nBTItem.getItem().getItemMeta());
    }

    public void mergeCustomNBT(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            throw new NullPointerException("ItemStack can't be null/Air!");
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        NBTReflectionUtil.getUnhandledNBTTags(itemMeta).putAll(NBTReflectionUtil.getUnhandledNBTTags(this.bukkitItem.getItemMeta()));
        itemStack.setItemMeta(itemMeta);
    }

    @Override
    public boolean hasCustomNbtData() {
        this.finalizeChanges();
        ItemMeta itemMeta = this.bukkitItem.getItemMeta();
        return !NBTReflectionUtil.getUnhandledNBTTags(itemMeta).isEmpty();
    }

    @Override
    public void clearCustomNBT() {
        this.finalizeChanges();
        ItemMeta itemMeta = this.bukkitItem.getItemMeta();
        NBTReflectionUtil.getUnhandledNBTTags(itemMeta).clear();
        this.bukkitItem.setItemMeta(itemMeta);
        this.updateCachedCompound();
    }

    public ItemStack getItem() {
        return this.bukkitItem;
    }

    protected void setItem(ItemStack itemStack) {
        this.bukkitItem = itemStack;
    }

    @Override
    public boolean hasNBTData() {
        return this.getCompound() != null;
    }

    @Override
    public void modifyMeta(BiConsumer<ReadableNBT, ItemMeta> biConsumer) {
        this.finalizeChanges();
        ItemMeta itemMeta = this.bukkitItem.getItemMeta();
        biConsumer.accept(new NBTContainer(this.getResolvedObject()).setReadOnly(true), itemMeta);
        this.bukkitItem.setItemMeta(itemMeta);
        this.updateCachedCompound();
        if (this.directApply) {
            NBTItem nBTItem = this;
            nBTItem.applyNBT(nBTItem.originalSrcStack);
        }
    }

    @Override
    public <T extends ItemMeta> void modifyMeta(Class<T> itemMeta, BiConsumer<ReadableNBT, T> biConsumer) {
        this.finalizeChanges();
        itemMeta = this.bukkitItem.getItemMeta();
        biConsumer.accept(new NBTContainer(this.getResolvedObject()).setReadOnly(true), (ReadableNBT)itemMeta);
        this.bukkitItem.setItemMeta(itemMeta);
        this.updateCachedCompound();
        if (this.directApply) {
            NBTItem nBTItem = this;
            nBTItem.applyNBT(nBTItem.originalSrcStack);
        }
    }

    public static NBTContainer convertItemtoNBT(ItemStack itemStack) {
        return NBTReflectionUtil.convertNMSItemtoNBTCompound(ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, itemStack));
    }

    @Nullable
    public static ItemStack convertNBTtoItem(NBTCompound nBTCompound) {
        return (ItemStack)ReflectionMethod.ITEMSTACK_BUKKITMIRROR.run(null, NBTReflectionUtil.convertNBTCompoundtoNMSItem(nBTCompound));
    }

    public static NBTContainer convertItemArraytoNBT(ItemStack[] itemStackArray) {
        NBTContainer nBTContainer = new NBTContainer();
        nBTContainer.setInteger("size", itemStackArray.length);
        NBTCompoundList nBTCompoundList = nBTContainer.getCompoundList("items");
        for (int i2 = 0; i2 < itemStackArray.length; ++i2) {
            ItemStack itemStack = itemStackArray[i2];
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            NBTListCompound nBTListCompound = nBTCompoundList.addCompound();
            nBTListCompound.setInteger("Slot", i2);
            nBTListCompound.mergeCompound(NBTItem.convertItemtoNBT(itemStack));
        }
        return nBTContainer;
    }

    @Nullable
    public static ItemStack[] convertNBTtoItemArray(NBTCompound object) {
        if (!((NBTCompound)object).hasTag("size")) {
            return null;
        }
        ItemStack[] itemStackArray = new ItemStack[((NBTCompound)object).getInteger("size").intValue()];
        for (int i2 = 0; i2 < itemStackArray.length; ++i2) {
            itemStackArray[i2] = new ItemStack(Material.AIR);
        }
        if (!((NBTCompound)object).hasTag("items")) {
            return itemStackArray;
        }
        Object object2 = ((NBTCompound)object).getCompoundList("items");
        object = ((NBTList)object2).iterator();
        while (object.hasNext()) {
            object2 = (ReadWriteNBT)object.next();
            if (!(object2 instanceof NBTCompound)) continue;
            int n2 = object2.getInteger("Slot");
            itemStackArray[n2] = NBTItem.convertNBTtoItem((NBTCompound)object2);
        }
        return itemStackArray;
    }

    @Override
    protected void saveCompound() {
        if (this.directApply) {
            NBTItem nBTItem = this;
            nBTItem.applyNBT(nBTItem.originalSrcStack);
        }
    }
}

