/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.nbtapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import me.extremall.advancedkits.libs.nbtapi.NBTCompound;
import me.extremall.advancedkits.libs.nbtapi.NBTType;
import me.extremall.advancedkits.libs.nbtapi.NbtApiException;
import me.extremall.advancedkits.libs.nbtapi.iface.ReadWriteNBTList;
import me.extremall.advancedkits.libs.nbtapi.utils.MinecraftVersion;
import me.extremall.advancedkits.libs.nbtapi.utils.nmsmappings.ReflectionMethod;

public abstract class NBTList<T>
implements List<T>,
ReadWriteNBTList<T> {
    private String listName;
    private NBTCompound parent;
    private NBTType type;
    protected Object listObject;

    protected NBTList(NBTCompound nBTCompound, String string, NBTType nBTType, Object object) {
        this.parent = nBTCompound;
        this.listName = string;
        this.type = nBTType;
        this.listObject = object;
    }

    public String getName() {
        return this.listName;
    }

    public NBTCompound getParent() {
        return this.parent;
    }

    private void validateClosed() {
        if (this.parent.isClosed()) {
            throw new NbtApiException("Tried using closed NBT data!");
        }
    }

    private void validateWritable() {
        if (this.getParent().isReadOnly()) {
            throw new NbtApiException("Tried setting data in read only mode!");
        }
    }

    protected void save() {
        this.validateClosed();
        this.parent.set(this.listName, this.listObject);
    }

    protected abstract Object asTag(T var1);

    @Override
    public boolean add(T t2) {
        this.validateClosed();
        this.validateWritable();
        try {
            this.parent.getWriteLock().lock();
            if (MinecraftVersion.getVersion().getVersionId() >= MinecraftVersion.MC1_14_R1.getVersionId()) {
                ReflectionMethod.LIST_ADD.run(this.listObject, this.size(), this.asTag(t2));
            } else {
                ReflectionMethod.LEGACY_LIST_ADD.run(this.listObject, this.asTag(t2));
            }
            this.save();
            return true;
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.parent.getWriteLock().unlock();
        }
    }

    @Override
    public void add(int n2, T t2) {
        this.validateClosed();
        this.validateWritable();
        try {
            this.parent.getWriteLock().lock();
            if (MinecraftVersion.getVersion().getVersionId() >= MinecraftVersion.MC1_14_R1.getVersionId()) {
                ReflectionMethod.LIST_ADD.run(this.listObject, n2, this.asTag(t2));
            } else {
                ReflectionMethod.LEGACY_LIST_ADD.run(this.listObject, this.asTag(t2));
            }
            this.save();
            return;
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.parent.getWriteLock().unlock();
        }
    }

    @Override
    public T set(int n2, T t2) {
        this.validateClosed();
        this.validateWritable();
        try {
            this.parent.getWriteLock().lock();
            Object e2 = this.get(n2);
            ReflectionMethod.LIST_SET.run(this.listObject, n2, this.asTag(t2));
            this.save();
            Object e3 = e2;
            return (T)e3;
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.parent.getWriteLock().unlock();
        }
    }

    @Override
    public T remove(int n2) {
        this.validateClosed();
        this.validateWritable();
        try {
            this.parent.getWriteLock().lock();
            Object e2 = this.get(n2);
            ReflectionMethod.LIST_REMOVE_KEY.run(this.listObject, n2);
            this.save();
            Object e3 = e2;
            return (T)e3;
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.parent.getWriteLock().unlock();
        }
    }

    @Override
    public int size() {
        this.validateClosed();
        try {
            this.parent.getReadLock().lock();
            int n2 = (Integer)ReflectionMethod.LIST_SIZE.run(this.listObject, new Object[0]);
            return n2;
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.parent.getReadLock().unlock();
        }
    }

    @Override
    public NBTType getType() {
        return this.type;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        while (!this.isEmpty()) {
            this.remove(0);
        }
    }

    @Override
    public boolean contains(Object object) {
        this.validateClosed();
        try {
            this.parent.getReadLock().lock();
            for (int i2 = 0; i2 < this.size(); ++i2) {
                if (!object.equals(this.get(i2))) continue;
                this.parent.getReadLock().unlock();
                return true;
            }
            this.parent.getReadLock().unlock();
            return false;
        }
        catch (Throwable throwable) {
            this.parent.getReadLock().unlock();
            throw throwable;
        }
    }

    @Override
    public int indexOf(Object object) {
        this.validateClosed();
        try {
            this.parent.getReadLock().lock();
            for (int i2 = 0; i2 < this.size(); ++i2) {
                if (!object.equals(this.get(i2))) continue;
                int n2 = i2;
                this.parent.getReadLock().unlock();
                return n2;
            }
            this.parent.getReadLock().unlock();
            return -1;
        }
        catch (Throwable throwable) {
            this.parent.getReadLock().unlock();
            throw throwable;
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> object) {
        this.validateClosed();
        try {
            this.parent.getWriteLock().lock();
            int n2 = this.size();
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                this.add((T)e2);
            }
            boolean bl2 = n2 != this.size();
            return bl2;
        }
        finally {
            this.parent.getWriteLock().unlock();
        }
    }

    @Override
    public boolean addAll(int n2, Collection<? extends T> object) {
        this.validateClosed();
        try {
            this.parent.getWriteLock().lock();
            int n3 = this.size();
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                this.add(n2++, (T)e2);
            }
            boolean bl2 = n3 != this.size();
            return bl2;
        }
        finally {
            this.parent.getWriteLock().unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> object) {
        this.validateClosed();
        try {
            this.parent.getReadLock().lock();
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                if (this.contains(e2)) continue;
                return false;
            }
            return true;
        }
        finally {
            this.parent.getReadLock().unlock();
        }
    }

    @Override
    public int lastIndexOf(Object object) {
        this.validateClosed();
        try {
            int n2;
            this.parent.getReadLock().lock();
            int n3 = -1;
            for (n2 = 0; n2 < this.size(); ++n2) {
                if (!object.equals(this.get(n2))) continue;
                n3 = n2;
            }
            n2 = n3;
            return n2;
        }
        finally {
            this.parent.getReadLock().unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> object) {
        this.validateClosed();
        try {
            this.parent.getWriteLock().lock();
            int n2 = this.size();
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                this.remove(e2);
            }
            boolean bl2 = n2 != this.size();
            return bl2;
        }
        finally {
            this.parent.getWriteLock().unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> object) {
        this.validateClosed();
        try {
            this.parent.getWriteLock().lock();
            int n2 = this.size();
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                for (int i2 = 0; i2 < this.size(); ++i2) {
                    if (e2.equals(this.get(i2))) continue;
                    this.remove(i2--);
                }
            }
            boolean bl2 = n2 != this.size();
            return bl2;
        }
        finally {
            this.parent.getWriteLock().unlock();
        }
    }

    @Override
    public boolean remove(Object object) {
        this.validateClosed();
        try {
            int n2;
            this.parent.getWriteLock().lock();
            int n3 = this.size();
            while ((n2 = this.indexOf(object)) != -1) {
                this.remove(n2);
            }
            boolean bl2 = n3 != this.size();
            return bl2;
        }
        finally {
            this.parent.getWriteLock().unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return NBTList.this.size() > this.index + 1;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return NBTList.this.get(++this.index);
            }

            @Override
            public void remove() {
                NBTList.this.remove(this.index);
                --this.index;
            }
        };
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(final int n2) {
        final NBTList nBTList = this;
        return new ListIterator<T>(){
            int index;
            {
                this.index = n2 - 1;
            }

            @Override
            public void add(T t2) {
                nBTList.add(this.index, t2);
            }

            @Override
            public boolean hasNext() {
                return NBTList.this.size() > this.index + 1;
            }

            @Override
            public boolean hasPrevious() {
                return this.index >= 0 && this.index <= NBTList.this.size();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return NBTList.this.get(++this.index);
            }

            @Override
            public int nextIndex() {
                return this.index + 1;
            }

            @Override
            public T previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("Id: " + (this.index - 1));
                }
                return NBTList.this.get(this.index--);
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                nBTList.remove(this.index);
                --this.index;
            }

            @Override
            public void set(T t2) {
                nBTList.set(this.index, t2);
            }
        };
    }

    @Override
    public Object[] toArray() {
        this.validateClosed();
        try {
            this.parent.getReadLock().lock();
            Object[] objectArray = new Object[this.size()];
            for (int i2 = 0; i2 < this.size(); ++i2) {
                objectArray[i2] = this.get(i2);
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            this.parent.getReadLock().unlock();
        }
    }

    @Override
    public <E> E[] toArray(E[] object) {
        this.validateClosed();
        try {
            this.parent.getReadLock().lock();
            Object[] objectArray = Arrays.copyOf(object, this.size());
            Arrays.fill(objectArray, null);
            object = object.getClass().getComponentType();
            for (int i2 = 0; i2 < this.size(); ++i2) {
                Object e2 = this.get(i2);
                if (!((Class)object).isInstance(e2)) {
                    throw new ArrayStoreException("The array does not match the objects stored in the List.");
                }
                objectArray[i2] = this.get(i2);
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            this.parent.getReadLock().unlock();
        }
    }

    @Override
    public List<T> subList(int n2, int n3) {
        this.validateClosed();
        try {
            this.parent.getReadLock().lock();
            ArrayList arrayList = new ArrayList();
            while (n2 < n3) {
                arrayList.add(this.get(n2));
                ++n2;
            }
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.parent.getReadLock().unlock();
        }
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        return List.super.removeIf(predicate);
    }

    public String toString() {
        this.validateClosed();
        try {
            this.parent.getReadLock().lock();
            String string = this.listObject.toString();
            return string;
        }
        finally {
            this.parent.getReadLock().unlock();
        }
    }
}

