/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.paperlib;

import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import me.extremall.advancedkits.libs.paperlib.environments.CraftBukkitEnvironment;
import me.extremall.advancedkits.libs.paperlib.environments.Environment;
import me.extremall.advancedkits.libs.paperlib.environments.PaperEnvironment;
import me.extremall.advancedkits.libs.paperlib.environments.SpigotEnvironment;
import me.extremall.advancedkits.libs.paperlib.features.blockstatesnapshot.BlockStateSnapshotResult;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class PaperLib {
    private static Environment ENVIRONMENT = PaperLib.initialize();

    private PaperLib() {
    }

    private static Environment initialize() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            return new PaperEnvironment();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("org.spigotmc.SpigotConfig");
                return new SpigotEnvironment();
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return new CraftBukkitEnvironment();
            }
        }
    }

    @Nonnull
    public static Environment getEnvironment() {
        return ENVIRONMENT;
    }

    public static void setCustomEnvironment(@Nonnull Environment environment) {
        ENVIRONMENT = environment;
    }

    @Nonnull
    public static CompletableFuture<Boolean> teleportAsync(@Nonnull Entity entity, @Nonnull Location location) {
        return ENVIRONMENT.teleport(entity, location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Nonnull
    public static CompletableFuture<Boolean> teleportAsync(@Nonnull Entity entity, @Nonnull Location location, PlayerTeleportEvent.TeleportCause teleportCause) {
        return ENVIRONMENT.teleport(entity, location, teleportCause);
    }

    @Nonnull
    public static CompletableFuture<Chunk> getChunkAtAsync(@Nonnull Location location) {
        return PaperLib.getChunkAtAsync(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4, true);
    }

    @Nonnull
    public static CompletableFuture<Chunk> getChunkAtAsync(@Nonnull Location location, boolean bl2) {
        return PaperLib.getChunkAtAsync(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4, bl2);
    }

    @Nonnull
    public static CompletableFuture<Chunk> getChunkAtAsync(@Nonnull World world, int n2, int n3) {
        return PaperLib.getChunkAtAsync(world, n2, n3, true);
    }

    @Nonnull
    public static CompletableFuture<Chunk> getChunkAtAsync(@Nonnull World world, int n2, int n3, boolean bl2) {
        return ENVIRONMENT.getChunkAtAsync(world, n2, n3, bl2, false);
    }

    @Nonnull
    public static CompletableFuture<Chunk> getChunkAtAsync(@Nonnull World world, int n2, int n3, boolean bl2, boolean bl3) {
        return ENVIRONMENT.getChunkAtAsync(world, n2, n3, bl2, bl3);
    }

    @Nonnull
    public static CompletableFuture<Chunk> getChunkAtAsyncUrgently(@Nonnull World world, int n2, int n3, boolean bl2) {
        return ENVIRONMENT.getChunkAtAsync(world, n2, n3, bl2, true);
    }

    public static boolean isChunkGenerated(@Nonnull Location location) {
        return PaperLib.isChunkGenerated(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public static boolean isChunkGenerated(@Nonnull World world, int n2, int n3) {
        return ENVIRONMENT.isChunkGenerated(world, n2, n3);
    }

    @Nonnull
    public static BlockStateSnapshotResult getBlockState(@Nonnull Block block, boolean bl2) {
        return ENVIRONMENT.getBlockState(block, bl2);
    }

    public static CompletableFuture<Location> getBedSpawnLocationAsync(@Nonnull Player player, boolean bl2) {
        return ENVIRONMENT.getBedSpawnLocationAsync(player, bl2);
    }

    public static boolean isVersion(int n2) {
        return ENVIRONMENT.isVersion(n2);
    }

    public static boolean isVersion(int n2, int n3) {
        return ENVIRONMENT.isVersion(n2, n3);
    }

    public static int getMinecraftVersion() {
        return ENVIRONMENT.getMinecraftVersion();
    }

    public static int getMinecraftPatchVersion() {
        return ENVIRONMENT.getMinecraftPatchVersion();
    }

    public static int getMinecraftPreReleaseVersion() {
        return ENVIRONMENT.getMinecraftPreReleaseVersion();
    }

    public static boolean isSpigot() {
        return ENVIRONMENT.isSpigot();
    }

    public static boolean isPaper() {
        return ENVIRONMENT.isPaper();
    }

    public static void suggestPaper(@Nonnull Plugin plugin) {
        PaperLib.suggestPaper(plugin, Level.INFO);
    }

    public static void suggestPaper(@Nonnull Plugin object, @Nonnull Level level) {
        if (PaperLib.isPaper()) {
            return;
        }
        String string = object.getDescription().getName();
        object = object.getLogger();
        ((Logger)object).log(level, "====================================================");
        ((Logger)object).log(level, " " + string + " works better if you use Paper ");
        ((Logger)object).log(level, " as your server software. ");
        if (System.getProperty("paperlib.shown-benefits") == null) {
            System.setProperty("paperlib.shown-benefits", "1");
            ((Logger)object).log(level, "  ");
            ((Logger)object).log(level, " Paper offers significant performance improvements,");
            ((Logger)object).log(level, " bug fixes, security enhancements and optional");
            ((Logger)object).log(level, " features for server owners to enhance their server.");
            ((Logger)object).log(level, "  ");
            ((Logger)object).log(level, " Paper includes Timings v2, which is significantly");
            ((Logger)object).log(level, " better at diagnosing lag problems over v1.");
            ((Logger)object).log(level, "  ");
            ((Logger)object).log(level, " All of your plugins should still work, and the");
            ((Logger)object).log(level, " Paper community will gladly help you fix any issues.");
            ((Logger)object).log(level, "  ");
            ((Logger)object).log(level, " Join the Paper Community @ https://papermc.io");
        }
        ((Logger)object).log(level, "====================================================");
    }
}

