/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.xseries;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class ReflectionUtils {
    public static final String NMS_VERSION;
    public static final int MINOR_NUMBER;
    public static final int PATCH_NUMBER;
    public static final String CRAFTBUKKIT_PACKAGE;
    public static final String NMS_PACKAGE;
    private static final MethodHandle PLAYER_CONNECTION;
    private static final MethodHandle GET_HANDLE;
    private static final MethodHandle SEND_PACKET;

    public static String getVersionInformation() {
        return "(NMS: " + NMS_VERSION + " | Minecraft: " + Bukkit.getVersion() + " | Bukkit: " + Bukkit.getBukkitVersion() + ')';
    }

    public static Integer getLatestPatchNumberOf(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Minor version must be positive: " + n2);
        }
        int[] nArray = new int[]{1, 5, 2, 7, 2, 4, 10, 8, 4, 2, 2, 2, 2, 4, 2, 5, 1, 2, 4, 4};
        if (n2 > 20) {
            return null;
        }
        return nArray[n2 - 1];
    }

    private ReflectionUtils() {
    }

    public static <T> VersionHandler<T> v(int n2, T t2) {
        return new VersionHandler(n2, t2);
    }

    public static <T> VersionHandler<T> v(int n2, int n3, T t2) {
        return new VersionHandler(n2, n3, t2);
    }

    public static <T> CallableVersionHandler<T> v(int n2, Callable<T> callable) {
        return new CallableVersionHandler(n2, callable);
    }

    public static boolean supports(int n2) {
        return MINOR_NUMBER >= n2;
    }

    public static boolean supports(int n2, int n3) {
        if (MINOR_NUMBER == n2) {
            return ReflectionUtils.supportsPatch(n3);
        }
        return ReflectionUtils.supports(n2);
    }

    public static boolean supportsPatch(int n2) {
        return PATCH_NUMBER >= n2;
    }

    @Nullable
    public static Class<?> getNMSClass(@Nullable String string, @Nonnull String string2) {
        if (string != null && ReflectionUtils.supports(17)) {
            string2 = string + '.' + string2;
        }
        try {
            return Class.forName(NMS_PACKAGE + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    @Nullable
    public static Class<?> getNMSClass(@Nonnull String string) {
        return ReflectionUtils.getNMSClass(null, string);
    }

    @Nonnull
    public static CompletableFuture<Void> sendPacket(@Nonnull Player player, Object ... objectArray) {
        return CompletableFuture.runAsync(() -> ReflectionUtils.sendPacketSync(player, objectArray)).exceptionally(throwable -> {
            throwable.printStackTrace();
            return null;
        });
    }

    public static void sendPacketSync(@Nonnull Player object, Object ... objectArray) {
        try {
            object = GET_HANDLE.invoke((Player)object);
            object = PLAYER_CONNECTION.invoke(object);
            if (object != null) {
                for (Object object2 : objectArray) {
                    SEND_PACKET.invoke(object, object2);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            return;
        }
    }

    @Nullable
    public static Object getHandle(@Nonnull Player object) {
        Objects.requireNonNull(object, "Cannot get handle of null player");
        try {
            return GET_HANDLE.invoke((Player)object);
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Object getConnection(@Nonnull Player object) {
        Objects.requireNonNull(object, "Cannot get connection of null player");
        try {
            object = GET_HANDLE.invoke((Player)object);
            return PLAYER_CONNECTION.invoke(object);
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Class<?> getCraftClass(@Nonnull String string) {
        try {
            return Class.forName(CRAFTBUKKIT_PACKAGE + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    @Deprecated
    public static Class<?> getArrayClass(String object, boolean bl2) {
        object = "[L" + (bl2 ? NMS_PACKAGE : CRAFTBUKKIT_PACKAGE) + (String)object + ';';
        try {
            return Class.forName((String)object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = classNotFoundException;
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    public static Class<?> toArrayClass(Class<?> serializable) {
        try {
            return Class.forName("[L" + ((Class)serializable).getName() + ';');
        }
        catch (ClassNotFoundException classNotFoundException) {
            serializable = classNotFoundException;
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    static {
        Object object;
        Object object3 = null;
        for (Package package_ : Package.getPackages()) {
            object = package_.getName();
            if (!((String)object).startsWith("org.bukkit.craftbukkit.v")) continue;
            object3 = package_.getName().split("\\.")[3];
            try {
                Class.forName("org.bukkit.craftbukkit." + (String)object3 + ".entity.CraftPlayer");
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                object3 = null;
            }
        }
        if (object3 == null) {
            throw new IllegalArgumentException("Failed to parse server version. Could not find any package starting with name: 'org.bukkit.craftbukkit.v'");
        }
        NMS_VERSION = object3;
        if (((String[])(object3 = object3.substring(1).split("_"))).length <= 0) {
            throw new IllegalStateException("Version number division error: " + Arrays.toString(object3) + ' ' + ReflectionUtils.getVersionInformation());
        }
        String string = object3[1];
        try {
            MINOR_NUMBER = Integer.parseInt(string);
            if (MINOR_NUMBER < 0) {
                throw new IllegalStateException("Negative minor number? " + string + ' ' + ReflectionUtils.getVersionInformation());
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to parse minor number: " + string + ' ' + ReflectionUtils.getVersionInformation(), throwable);
        }
        Class<?> clazz = Pattern.compile("^\\d+\\.\\d+\\.(\\d+)").matcher(Bukkit.getBukkitVersion());
        if (((Matcher)((Object)clazz)).find()) {
            try {
                PATCH_NUMBER = Integer.parseInt(((Matcher)((Object)clazz)).group(1));
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Failed to parse minor number: " + clazz + ' ' + ReflectionUtils.getVersionInformation(), throwable);
            }
        } else {
            PATCH_NUMBER = 0;
        }
        CRAFTBUKKIT_PACKAGE = "org.bukkit.craftbukkit." + NMS_VERSION + '.';
        NMS_PACKAGE = ReflectionUtils.v(17, "net.minecraft.").orElse("net.minecraft.server." + NMS_VERSION + '.');
        object3 = ReflectionUtils.getNMSClass("server.level", "EntityPlayer");
        Class<?> clazz2 = ReflectionUtils.getCraftClass("entity.CraftPlayer");
        clazz = ReflectionUtils.getNMSClass("server.network", "PlayerConnection");
        Class<?> clazz3 = ReflectionUtils.supports(20) && ReflectionUtils.supportsPatch(2) ? ReflectionUtils.getNMSClass("server.network", "ServerCommonPacketListenerImpl") : clazz;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        object = null;
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        try {
            methodHandle2 = lookup.findGetter((Class<?>)object3, ReflectionUtils.v(20, "c").v(17, "b").orElse("playerConnection"), clazz);
            methodHandle = lookup.findVirtual(clazz2, "getHandle", MethodType.methodType(object3));
            object = lookup.findVirtual(clazz3, ReflectionUtils.v(20, 2, "b").v(18, "a").orElse("sendPacket"), MethodType.methodType(Void.TYPE, ReflectionUtils.getNMSClass("network.protocol", "Packet")));
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            object3 = reflectiveOperationException;
            reflectiveOperationException.printStackTrace();
        }
        PLAYER_CONNECTION = methodHandle2;
        SEND_PACKET = object;
        GET_HANDLE = methodHandle;
    }

    public static final class VersionHandler<T> {
        private int version;
        private int patch;
        private T handle;

        private VersionHandler(int n2, T t2) {
            this(n2, 0, t2);
        }

        private VersionHandler(int n2, int n3, T t2) {
            if (ReflectionUtils.supports(n2) && ReflectionUtils.supportsPatch(n3)) {
                this.version = n2;
                this.patch = n3;
                this.handle = t2;
            }
        }

        public final VersionHandler<T> v(int n2, T t2) {
            return this.v(n2, 0, t2);
        }

        public final VersionHandler<T> v(int n2, int n3, T t2) {
            if (n2 == this.version && n3 == this.patch) {
                throw new IllegalArgumentException("Cannot have duplicate version handles for version: " + n2 + '.' + n3);
            }
            if (n2 > this.version && ReflectionUtils.supports(n2) && n3 >= this.patch && ReflectionUtils.supportsPatch(n3)) {
                this.version = n2;
                this.patch = n3;
                this.handle = t2;
            }
            return this;
        }

        public final T orElse(T t2) {
            if (this.version == 0) {
                return t2;
            }
            return this.handle;
        }
    }

    public static final class CallableVersionHandler<T> {
        private int version;
        private Callable<T> handle;

        private CallableVersionHandler(int n2, Callable<T> callable) {
            if (ReflectionUtils.supports(n2)) {
                this.version = n2;
                this.handle = callable;
            }
        }

        public final CallableVersionHandler<T> v(int n2, Callable<T> callable) {
            if (n2 == this.version) {
                throw new IllegalArgumentException("Cannot have duplicate version handles for version: " + n2);
            }
            if (n2 > this.version && ReflectionUtils.supports(n2)) {
                this.version = n2;
                this.handle = callable;
            }
            return this;
        }

        public final T orElse(Callable<T> callable) {
            try {
                return (this.version == 0 ? callable : this.handle).call();
            }
            catch (Exception exception) {
                callable = exception;
                exception.printStackTrace();
                return null;
            }
        }
    }
}

