/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery;

import com.gmail.ianlim224.advancedlottery.ItemGrabber;
import com.gmail.ianlim224.advancedlottery.LotteryConfig;
import com.gmail.ianlim224.advancedlottery.LotteryGrabber;
import com.gmail.ianlim224.advancedlottery.PersistenceManager;
import com.gmail.ianlim224.advancedlottery.bungee.LotteryChannelListener;
import com.gmail.ianlim224.advancedlottery.commands.Executable;
import com.gmail.ianlim224.advancedlottery.commands.LotteryCommand;
import com.gmail.ianlim224.advancedlottery.commands.admin.AddPotCommand;
import com.gmail.ianlim224.advancedlottery.commands.admin.AddTicketsCommand;
import com.gmail.ianlim224.advancedlottery.commands.admin.EndCommand;
import com.gmail.ianlim224.advancedlottery.commands.admin.ReloadCommand;
import com.gmail.ianlim224.advancedlottery.commands.admin.ReminderCommand;
import com.gmail.ianlim224.advancedlottery.commands.admin.SetTimeCommand;
import com.gmail.ianlim224.advancedlottery.commands.player.BuyCommand;
import com.gmail.ianlim224.advancedlottery.commands.player.HelpCommand;
import com.gmail.ianlim224.advancedlottery.commands.player.MenuCommand;
import com.gmail.ianlim224.advancedlottery.commands.player.StatsCommand;
import com.gmail.ianlim224.advancedlottery.commands.player.TimeCommand;
import com.gmail.ianlim224.advancedlottery.config.ConfigManager;
import com.gmail.ianlim224.advancedlottery.gui.ConfirmGUI;
import com.gmail.ianlim224.advancedlottery.gui.HelpGUI;
import com.gmail.ianlim224.advancedlottery.gui.LotteryGUI;
import com.gmail.ianlim224.advancedlottery.hooks.AdvancedLotteryExpansion;
import com.gmail.ianlim224.advancedlottery.hooks.VaultEcon;
import com.gmail.ianlim224.advancedlottery.items.MenuItems;
import com.gmail.ianlim224.advancedlottery.legacy.LegacySkullImpl;
import com.gmail.ianlim224.advancedlottery.legacy.SkullManager;
import com.gmail.ianlim224.advancedlottery.legacy.V_1_13_SkullImpl;
import com.gmail.ianlim224.advancedlottery.listeners.InventoryClick;
import com.gmail.ianlim224.advancedlottery.listeners.InventoryClose;
import com.gmail.ianlim224.advancedlottery.listeners.PlayerJoin;
import com.gmail.ianlim224.advancedlottery.listeners.PlayerQuit;
import com.gmail.ianlim224.advancedlottery.messages.Messages;
import com.gmail.ianlim224.advancedlottery.mysql.LotterySql;
import com.gmail.ianlim224.advancedlottery.object.LotteryTicket;
import com.gmail.ianlim224.advancedlottery.parser.PlaceholderParser;
import com.gmail.ianlim224.advancedlottery.tasks.ItemTask;
import com.gmail.ianlim224.advancedlottery.time.LotteryTimer;
import com.gmail.ianlim224.advancedlottery.time.ReminderManager;
import com.gmail.ianlim224.advancedlottery.utils.FileLogging;
import com.gmail.ianlim224.advancedlottery.utils.SpigotCommons;
import com.gmail.ianlim224.advancedlottery.utils.UUIDFetcher;
import com.gmail.ianlim224.advancedlottery.utils.UpdateChecker;
import com.gmail.ianlim224.advancedlottery.utils.WinnerRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class AdvancedLottery
extends JavaPlugin {
    public static final String USER = "%%__USER__%%";
    static LotteryGrabber lotteryGrabber;
    private static AdvancedLottery instance;
    private final FileLogging fileLogging = new FileLogging(this);
    private final Random random = new Random();
    private final ReminderManager reminderManager = new ReminderManager(this);
    private final WinnerRegistry winnerRegistry = new WinnerRegistry(this);
    private final VaultEcon vaultEcon = new VaultEcon(this);
    private LotteryConfig lotteryConfig = new LotteryConfig(this);
    private ConfigManager messages = new ConfigManager(this, "", "messages.yml");
    private ConfigManager items = new ConfigManager(this, "", "items.yml");
    private LotteryTimer lotteryTimer;
    private SkullManager skullManager;
    private PersistenceManager persistenceManager = new PersistenceManager(this);
    private PluginMessageListener pluginMessageListener = new LotteryChannelListener();

    public static AdvancedLottery getInstance() {
        return instance;
    }

    public static LotteryGrabber getLotteryGrabber() {
        return lotteryGrabber;
    }

    public static String f(String msg) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    public static List<String> f(List<String> msg) {
        ArrayList<String> newList = new ArrayList<String>();
        for (int i = 0; i < msg.size(); ++i) {
            newList.add(AdvancedLottery.f(msg.get(i)));
        }
        return newList;
    }

    public static List<String> replace(List<String> list, String regex, String value) {
        ArrayList<String> newList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            newList.add(list.get(i).replaceAll(regex, value));
        }
        return newList;
    }

    public void onEnable() {
        instance = this;
        if (Material.getMaterial((String)"LEGACY_AIR") != null) {
            this.skullManager = new V_1_13_SkullImpl();
            this.getLogger().info("Detected server running on 1.13 or newer version");
        } else {
            this.skullManager = new LegacySkullImpl();
            this.getLogger().info("Detected server running on older version. Implementing legacy skull manager...");
        }
        if (!this.vaultEcon.setupEconomy()) {
            this.getLogger().severe("Disabled due to no Vault dependency found!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Hooked into vault!");
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.getLogger().info("Successfully hooked into PlaceholderAPI!");
            new AdvancedLotteryExpansion(this).register();
            Messages.setParser(new PlaceholderParser());
        }
        this.loadMessages();
        this.loadItems();
        this.lotteryConfig.loadDefault();
        this.lotteryConfig.loadGrabber();
        SpigotCommons.setMoneyFormat(lotteryGrabber.getMoneyFormat(), this);
        if (lotteryGrabber.shouldUpdate()) {
            this.checkForUpdates();
        }
        this.registerCommands();
        this.registerListeners();
        LotterySql sql = LotterySql.getInstance(this);
        sql.initDatabase();
        HelpGUI.getInstance(this).reload();
        LotteryGUI.getInstance().load(this);
        this.lotteryTimer = new LotteryTimer(this);
        this.lotteryTimer.start();
        this.reminderManager.read();
        this.winnerRegistry.read();
        this.startItemTask();
        UUIDFetcher.reload();
        if (this.persistenceManager.loadPreviousLotterySnapshot()) {
            Bukkit.broadcastMessage((String)AdvancedLottery.f("&aResuming previous lottery..."));
        }
        if (lotteryGrabber.isBungeeSync()) {
            this.getLogger().info("Enabling bungee sync");
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", this.pluginMessageListener);
        }
    }

    private void checkForUpdates() {
        UpdateChecker.init(this, 43668);
        UpdateChecker.get().requestUpdateCheck().whenCompleteAsync((updateResult, throwable) -> {
            if (updateResult.requiresUpdate()) {
                this.getLogger().info("---------------------------------");
                this.getLogger().info("There is a new version: v" + updateResult.getNewestVersion());
                this.getLogger().info("You are running v" + this.getDescription().getVersion());
                this.getLogger().info("Please download the new version at https://www.spigotmc.org/resources/lottery.43668/");
                this.getLogger().info("---------------------------------");
                return;
            }
            if (updateResult.getReason() == UpdateChecker.UpdateReason.UP_TO_DATE) {
                this.getLogger().info("You're running the latest version!");
            } else if (updateResult.getReason() == UpdateChecker.UpdateReason.UNRELEASED_VERSION) {
                this.getLogger().info("Running unreleased version of plugin!");
            } else {
                this.getLogger().info("Error checking for updates on spigot!");
            }
        });
    }

    public void onDisable() {
        if (this.getConfig().getBoolean("save_lottery_progress_on_stop")) {
            this.getLogger().info("Saving current lottery to be loaded on next server start!");
            this.persistenceManager.saveCurrentLotterySnapshot();
            Bukkit.broadcastMessage((String)AdvancedLottery.f("&aSaving current lottery progress..."));
        } else {
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendMessage(Messages.TICKET_MONEY_REFUNDED.getConfigValue(player));
            }
            for (Map.Entry entry : LotteryTicket.getInstance(this).getWhoBought().entrySet()) {
                this.vaultEcon.payMoney((double)((Integer)entry.getValue()).intValue() * (double)lotteryGrabber.getBuyPrice(), Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey())));
            }
        }
        LotterySql sql = LotterySql.getInstance(this);
        if (sql.isEnabled()) {
            sql.close();
        }
        this.winnerRegistry.save();
        this.reminderManager.save();
        this.reminderManager.clean();
        if (lotteryGrabber.isBungeeSync()) {
            Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
            Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)this);
        }
    }

    private void registerCommands() {
        PluginCommand mainCmd = this.getCommand("lottery");
        ArrayList<Executable> commands = new ArrayList<Executable>();
        commands.add(new HelpCommand());
        commands.add(new TimeCommand());
        commands.add(new BuyCommand());
        commands.add(new MenuCommand());
        commands.add(new StatsCommand());
        commands.add(new EndCommand());
        commands.add(new ReloadCommand());
        commands.add(new ReminderCommand());
        commands.add(new SetTimeCommand());
        commands.add(new AddPotCommand());
        commands.add(new AddTicketsCommand());
        mainCmd.setExecutor((CommandExecutor)new LotteryCommand(this, commands));
        mainCmd.setUsage(Messages.WRONG_USAGE.getConfigValue(null));
    }

    private void registerListeners() {
        PluginManager manager = this.getServer().getPluginManager();
        manager.registerEvents((Listener)new InventoryClick(this), (Plugin)this);
        manager.registerEvents((Listener)new ConfirmGUI(this), (Plugin)this);
        manager.registerEvents((Listener)new UUIDFetcher(), (Plugin)this);
        manager.registerEvents((Listener)new PlayerQuit(), (Plugin)this);
        manager.registerEvents((Listener)new InventoryClose(), (Plugin)this);
        manager.registerEvents((Listener)new PlayerJoin(this), (Plugin)this);
    }

    private void loadMessages() {
        Messages.setFc(this.messages.getConfig());
        for (Messages msg : Messages.values()) {
            this.messages.getConfig().addDefault(msg.getPath(), (Object)msg.getValue());
        }
        this.messages.getConfig().options().copyDefaults(true);
        this.messages.saveConfig();
    }

    private void loadItems() {
        MenuItems.setFc(this.items.getConfig());
        this.items.getConfig().options().header("Lottery items configuration file - this file will load the items in guis\nWarning: if any errors are detected, this file will automatically reset to default");
        for (MenuItems i : MenuItems.values()) {
            if (i.isLore()) {
                this.items.getConfig().addDefault(i.getPath(), i.getDefaultListValue());
                continue;
            }
            this.items.getConfig().addDefault(i.getPath(), (Object)i.getDefaultStringValue());
        }
        MenuItems.loadConfigValues();
        this.items.getConfig().options().copyDefaults(true);
        this.items.saveConfig();
        ItemGrabber.reload(this);
    }

    public ConfigManager getMessagesManager() {
        return this.messages;
    }

    public ConfigManager getItemsManager() {
        return this.items;
    }

    private void startItemTask() {
        this.getServer().getScheduler().runTaskTimer((Plugin)this, (Runnable)new ItemTask(this), 0L, 20L);
    }

    public Random getRandom() {
        return this.random;
    }

    public ReminderManager getReminderManager() {
        return this.reminderManager;
    }

    public WinnerRegistry getWinnerRegistry() {
        return this.winnerRegistry;
    }

    public VaultEcon getVaultEcon() {
        return this.vaultEcon;
    }

    public LotteryTimer getLotteryTimer() {
        return this.lotteryTimer;
    }

    public SkullManager getSkullManager() {
        return this.skullManager;
    }

    public LotteryConfig getLotteryConfig() {
        return this.lotteryConfig;
    }

    public FileLogging getFileLogging() {
        return this.fileLogging;
    }
}

