/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.gui;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import com.gmail.ianlim224.advancedlottery.ItemGrabber;
import com.gmail.ianlim224.advancedlottery.gui.ConfirmHolder;
import com.gmail.ianlim224.advancedlottery.items.MenuItems;
import com.gmail.ianlim224.advancedlottery.messages.Messages;
import com.gmail.ianlim224.advancedlottery.object.LotteryTicket;
import com.gmail.ianlim224.advancedlottery.object.Purchase;
import com.gmail.ianlim224.advancedlottery.sounds.CancelSound;
import com.gmail.ianlim224.advancedlottery.utils.ItemBuilder;
import com.gmail.ianlim224.advancedlottery.utils.SpigotCommons;
import com.gmail.ianlim224.utils.XMaterial;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ConfirmGUI
implements Listener {
    private static Map<UUID, Integer> counter = new HashMap<UUID, Integer>();
    private final Inventory inv = Bukkit.createInventory((InventoryHolder)new ConfirmHolder(), (int)54, (String)AdvancedLottery.f(AdvancedLottery.getLotteryGrabber().getConfirmMenuName()));
    private ItemGrabber grabber;
    private CancelSound sound;
    private AdvancedLottery plugin;
    private LotteryTicket ticket;

    public ConfirmGUI(AdvancedLottery plugin) {
        this.grabber = ItemGrabber.getInstance(plugin);
        this.sound = new CancelSound();
        this.plugin = plugin;
        this.ticket = LotteryTicket.getInstance(plugin);
    }

    public static int getCounter(Player player) {
        if (counter.containsKey(player.getUniqueId())) {
            return counter.get(player.getUniqueId());
        }
        throw new NullPointerException("Player is not added yet!");
    }

    public static void removePlayer(Player player) {
        counter.remove(player.getUniqueId());
    }

    public static void addPlayerToCounter(Player player) {
        counter.put(player.getUniqueId(), 1);
    }

    private ItemStack getTicketAmountItem(int amount) {
        return new ItemBuilder(XMaterial.matchXMaterial(MenuItems.TICKET_AMOUNT_MATERIAL.getStringValue()).get().parseMaterial()).setName(MenuItems.TICKET_AMOUNT_NAME.getStringValue().replaceAll("%ticket%", Integer.toString(amount))).setLore(AdvancedLottery.replace(AdvancedLottery.replace(MenuItems.TICKET_AMOUNT_LORE.getListValue(), "%money%", SpigotCommons.formatMoney((double)amount * this.plugin.getConfig().getDouble("buy_price"))), "%ticket%", Integer.toString(amount))).toItemStack();
    }

    private void setTicketAmountItem(int amount, Inventory inv) {
        inv.setItem(22, this.getTicketAmountItem(amount));
    }

    public void openGui(Player player) {
        ConfirmGUI.addPlayerToCounter(player);
        this.setTicketAmountItem(ConfirmGUI.getCounter(player), this.inv);
        this.load();
        player.openInventory(this.inv);
    }

    public void load() {
        int i;
        this.inv.setItem(4, this.grabber.getBuyNavigator());
        for (i = 0; i < 3; ++i) {
            this.inv.setItem(33 + i, this.grabber.getCancelBuy());
            this.inv.setItem(42 + i, this.grabber.getCancelBuy());
            this.inv.setItem(51 + i, this.grabber.getCancelBuy());
        }
        for (i = 0; i < 3; ++i) {
            this.inv.setItem(27 + i, this.grabber.getConfirmBuy());
            this.inv.setItem(36 + i, this.grabber.getConfirmBuy());
            this.inv.setItem(45 + i, this.grabber.getConfirmBuy());
        }
        this.inv.setItem(21, this.grabber.getAdd());
        this.inv.setItem(23, this.grabber.getMinus());
        this.setTicketAmountItem(1, this.inv);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onClick(InventoryClickEvent event) {
        ItemStack eventItem = event.getCurrentItem();
        double buyPrice = this.plugin.getConfig().getLong("buy_price");
        Player player = (Player)event.getWhoClicked();
        if (eventItem == null || !(event.getClickedInventory().getHolder() instanceof ConfirmHolder)) {
            return;
        }
        int counter = ConfirmGUI.getCounter(player);
        if (eventItem.equals((Object)this.grabber.getConfirmBuy())) {
            if (this.ticket.getMaxTicketsCanBeBought(player) < counter) {
                player.sendMessage(Messages.TOO_MANY_TICKETS.getConfigValue(player));
                this.sound.playSound(player, this.plugin);
                player.closeInventory();
                return;
            }
            if (this.plugin.getVaultEcon().getBalance((OfflinePlayer)player) < buyPrice * (double)ConfirmGUI.getCounter(player)) {
                player.sendMessage(Messages.NOT_ENOUGH_MONEY.getConfigValue(player));
                this.sound.playSound(player, this.plugin);
                player.closeInventory();
                return;
            }
            Purchase purchase = new Purchase((OfflinePlayer)player, counter, this.plugin);
            purchase.executePurchase(true, true);
            event.setCancelled(true);
            player.closeInventory();
            return;
        }
        if (eventItem.equals((Object)this.grabber.getCancelBuy())) {
            event.setCancelled(true);
            player.closeInventory();
            this.sound.playSound(player, this.plugin);
            return;
        }
        if (eventItem.equals((Object)this.grabber.getAdd())) {
            event.setCancelled(true);
            if (this.ticket.getMaxTicketsCanBeBought(player) >= counter + 1) {
                this.setCounter(player, counter + 1);
                this.setTicketAmountItem(ConfirmGUI.getCounter(player), event.getClickedInventory());
            }
        }
        if (eventItem.equals((Object)this.grabber.getMinus())) {
            event.setCancelled(true);
            if (counter == 1) {
                return;
            }
            this.setCounter(player, counter - 1);
            this.setTicketAmountItem(ConfirmGUI.getCounter(player), event.getClickedInventory());
        }
    }

    public void setCounter(Player player, int i) {
        if (!counter.containsKey(player.getUniqueId())) {
            throw new IllegalArgumentException("Player not found");
        }
        counter.put(player.getUniqueId(), i);
        this.setTicketAmountItem(i, this.inv);
    }
}

