/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.gui;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import com.gmail.ianlim224.advancedlottery.clickablechat.ClickableText;
import com.gmail.ianlim224.advancedlottery.gui.StatsHolder;
import com.gmail.ianlim224.advancedlottery.items.MenuItems;
import com.gmail.ianlim224.advancedlottery.messages.Messages;
import com.gmail.ianlim224.advancedlottery.object.LotteryTicket;
import com.gmail.ianlim224.advancedlottery.utils.ItemBuilder;
import com.gmail.ianlim224.utils.XMaterial;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerStatsGUI
implements Listener {
    private final AdvancedLottery plugin;
    private final Inventory inv;
    private final OfflinePlayer player;

    public PlayerStatsGUI(OfflinePlayer player, AdvancedLottery plugin) {
        this.plugin = plugin;
        this.player = player;
        this.inv = Bukkit.createInventory((InventoryHolder)new StatsHolder(), (int)54, (String)AdvancedLottery.f(AdvancedLottery.getLotteryGrabber().getPlayerMenuName()));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        for (int i = 0; i != 54; ++i) {
            this.inv.setItem(i, new ItemBuilder(XMaterial.MAGENTA_STAINED_GLASS_PANE.parseMaterial()).setName(" ").toItemStack());
        }
    }

    public void openGui(Player p) {
        ItemStack playerHead = new ItemBuilder(this.plugin.getSkullManager().getSkull(this.player)).setLore(Collections.emptyList()).setName(MenuItems.PLAYER_HEAD_NAME.getStringValue().replaceAll("%player%", this.player.getName())).toItemStack();
        this.inv.setItem(13, playerHead);
        String target = this.player.getName();
        LotteryTicket ticket = LotteryTicket.getInstance(AdvancedLottery.getInstance());
        ItemStack message = new ItemBuilder(XMaterial.matchXMaterial(MenuItems.SEND_MESSAGE_MATERIAL.getStringValue()).get().parseMaterial()).setName(MenuItems.SEND_MESSAGE_NAME.getStringValue()).setLore(MenuItems.SEND_MESSAGE_LORE.getStringValue().replaceAll("%player%", target)).toItemStack();
        ItemStack ticketsBought = new ItemBuilder(XMaterial.matchXMaterial(MenuItems.TICKETS_BOUGHT_MATERIAL.getStringValue()).get().parseMaterial()).setName(MenuItems.TICKETS_BOUGHT_NAME.getStringValue()).setLore(MenuItems.TICKETS_BOUGHT_LORE.getStringValue().replaceAll("%player%", target).replaceAll("%ticket%", Integer.toString(ticket.getTicketsBought(this.player.getUniqueId())))).toItemStack();
        this.inv.setItem(39, message);
        this.inv.setItem(41, ticketsBought);
        p.openInventory(this.inv);
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getInventory().getHolder() instanceof StatsHolder) {
            event.setCancelled(true);
            if (!this.player.isOnline()) {
                Player p = (Player)event.getWhoClicked();
                event.getWhoClicked().sendMessage(Messages.PLAYER_NOT_ONLINE.getConfigValue(p).replaceAll("%player%", this.player.getName()));
                event.getWhoClicked().closeInventory();
                return;
            }
            Player target = this.player.getPlayer();
            ItemStack item = event.getCurrentItem();
            if (item.getType() == Material.PAPER) {
                event.getWhoClicked().closeInventory();
                ClickableText chat = new ClickableText();
                chat.sendMessageWithAction((Player)event.getWhoClicked(), Messages.CLICK_ME_TEXT.getConfigValue((Player)event.getWhoClicked()), Messages.CLICK_ME_HOVER_TEXT.getConfigValue((Player)event.getWhoClicked()).replaceAll("%player%", this.player.getName()), target);
            }
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (event.getInventory().equals(this.inv)) {
            HandlerList.unregisterAll((Listener)this);
        }
    }
}

