/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.hooks;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import com.gmail.ianlim224.advancedlottery.mysql.LotterySql;
import com.gmail.ianlim224.advancedlottery.object.LotteryPot;
import com.gmail.ianlim224.advancedlottery.object.LotteryTicket;
import com.gmail.ianlim224.advancedlottery.utils.SpigotCommons;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class AdvancedLotteryExpansion
extends PlaceholderExpansion {
    private final AdvancedLottery plugin;

    public AdvancedLotteryExpansion(AdvancedLottery plugin) {
        this.plugin = plugin;
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (identifier.equals("money")) {
            return SpigotCommons.formatMoney(LotteryPot.getInstance(this.plugin).getMoneyInPot());
        }
        if (identifier.equals("winner")) {
            if (this.plugin.getWinnerRegistry().getWinner() == null) {
                return "None";
            }
            return this.plugin.getWinnerRegistry().getWinner().getName();
        }
        if (identifier.equals("time")) {
            return this.plugin.getLotteryTimer().time(false);
        }
        if (identifier.equals("time_short")) {
            return this.plugin.getLotteryTimer().time(true);
        }
        if (identifier.equals("tickets")) {
            if (player == null) {
                return "0";
            }
            return LotteryTicket.getInstance(this.plugin).getTicketsBought(player.getUniqueId()) + "";
        }
        if (identifier.equals("stats.total.tickets")) {
            LotterySql sql = LotterySql.getInstance(this.plugin);
            if (player == null || !sql.isEnabled()) {
                return "0";
            }
            return "" + sql.getStats(player.getUniqueId()).getTickets();
        }
        return null;
    }

    public String getIdentifier() {
        return "AdvancedLottery";
    }

    public String getAuthor() {
        return "Ean244";
    }

    public String getVersion() {
        return "2.0";
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }
}

